/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.joystickBasedStepping;

import atlas_msgs.msg.dds.AtlasLowLevelControlModeMessage;
import controller_msgs.msg.dds.AbortWalkingMessage;
import controller_msgs.msg.dds.ArmTrajectoryMessage;
import controller_msgs.msg.dds.FootLoadBearingMessage;
import controller_msgs.msg.dds.FootTrajectoryMessage;
import controller_msgs.msg.dds.OneDoFJointTrajectoryMessage;
import controller_msgs.msg.dds.PauseWalkingMessage;
import ihmc_common_msgs.msg.dds.TrajectoryPoint1DMessage;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotKickMessenger;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotPunchMessenger;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.atlas.AtlasLowLevelControlMode;
import us.ihmc.humanoidRobotics.communication.packets.walking.LoadBearingRequest;
import us.ihmc.idl.IDLSequence;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SegmentDependentList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class AtlasKickAndPunchMessenger
implements HumanoidRobotPunchMessenger,
HumanoidRobotKickMessenger,
RobotLowLevelMessenger {
    private final IHMCROS2Publisher<ArmTrajectoryMessage> armTrajectoryPublisher;
    private final IHMCROS2Publisher<FootTrajectoryMessage> footTrajectoryPublisher;
    private final IHMCROS2Publisher<FootLoadBearingMessage> footLoadBearingPublisher;
    private final IHMCROS2Publisher<AtlasLowLevelControlModeMessage> atlasLowLevelControlModePublisher;
    private final IHMCROS2Publisher<AbortWalkingMessage> abortWalkingPublisher;
    private final IHMCROS2Publisher<PauseWalkingMessage> pauseWalkingPublisher;

    public AtlasKickAndPunchMessenger(ROS2Node ros2Node, String robotName) {
        ROS2Topic inputTopic = ROS2Tools.getControllerInputTopic((String)robotName);
        this.armTrajectoryPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, ArmTrajectoryMessage.class, (ROS2Topic)inputTopic);
        this.footTrajectoryPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, FootTrajectoryMessage.class, (ROS2Topic)inputTopic);
        this.footLoadBearingPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, FootLoadBearingMessage.class, (ROS2Topic)inputTopic);
        this.atlasLowLevelControlModePublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, AtlasLowLevelControlModeMessage.class, (ROS2Topic)inputTopic);
        this.abortWalkingPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, AbortWalkingMessage.class, (ROS2Topic)inputTopic);
        this.pauseWalkingPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, PauseWalkingMessage.class, (ROS2Topic)inputTopic);
    }

    public void sendArmHomeConfiguration(double trajectoryDuration, RobotSide ... robotSides) {
        for (RobotSide robotSide : robotSides) {
            double[] jointAngles = new double[7];
            int index = 0;
            jointAngles[index++] = robotSide.negateIfRightSide(0.785398);
            jointAngles[index++] = robotSide.negateIfRightSide(-0.52379);
            jointAngles[index++] = 2.33708;
            jointAngles[index++] = robotSide.negateIfRightSide(2.35619);
            jointAngles[index++] = -0.337807;
            jointAngles[index++] = robotSide.negateIfRightSide(0.20773);
            jointAngles[index++] = -0.026599;
            ArmTrajectoryMessage message = HumanoidMessageTools.createArmTrajectoryMessage((RobotSide)robotSide, (double)trajectoryDuration, (double[])jointAngles);
            this.armTrajectoryPublisher.publish((Object)message);
        }
    }

    public void sendArmStraightConfiguration(double trajectoryDuration, RobotSide robotSide) {
        double[] jointAngles0 = new double[7];
        int index = 0;
        jointAngles0[index++] = robotSide.negateIfRightSide(-0.2);
        jointAngles0[index++] = robotSide.negateIfRightSide(-0.17);
        jointAngles0[index++] = 1.4;
        jointAngles0[index++] = robotSide.negateIfRightSide(1.8);
        jointAngles0[index++] = -0.337807;
        jointAngles0[index++] = robotSide.negateIfRightSide(0.20773);
        jointAngles0[index++] = -0.026599;
        double[] jointAngles1 = new double[7];
        index = 0;
        jointAngles1[index++] = robotSide.negateIfRightSide(-1.2);
        jointAngles1[index++] = robotSide.negateIfRightSide(-0.0);
        jointAngles1[index++] = 1.8;
        jointAngles1[index++] = robotSide.negateIfRightSide(0.6);
        jointAngles1[index++] = -0.337807;
        jointAngles1[index++] = robotSide.negateIfRightSide(0.20773);
        jointAngles1[index++] = -0.026599;
        ArmTrajectoryMessage message = HumanoidMessageTools.createArmTrajectoryMessage((RobotSide)robotSide, (double)(trajectoryDuration / 2.0), (double[])jointAngles0);
        IDLSequence.Object jointTrajectoryMessages = message.getJointspaceTrajectory().getJointTrajectoryMessages();
        for (int i = 0; i < jointTrajectoryMessages.size(); ++i) {
            TrajectoryPoint1DMessage trajectoryPoint1DMessage = HumanoidMessageTools.createTrajectoryPoint1DMessage((double)trajectoryDuration, (double)jointAngles1[i], (double)0.0);
            ((TrajectoryPoint1DMessage)((OneDoFJointTrajectoryMessage)jointTrajectoryMessages.get(i)).getTrajectoryPoints().add()).set(trajectoryPoint1DMessage);
        }
        this.armTrajectoryPublisher.publish((Object)message);
    }

    public void sendFlamingoHomeStance(RobotSide robotSide, double trajectoryDuration, double stanceWidth, SegmentDependentList<RobotSide, ? extends ReferenceFrame> soleFrames) {
        FramePose3D footPose = new FramePose3D((ReferenceFrame)soleFrames.get((Enum)robotSide.getOppositeSide()));
        footPose.appendTranslation(0.0, robotSide.negateIfRightSide(stanceWidth), 0.15);
        footPose.changeFrame(ReferenceFrame.getWorldFrame());
        FootTrajectoryMessage message = HumanoidMessageTools.createFootTrajectoryMessage((RobotSide)robotSide, (double)trajectoryDuration, (Pose3DReadOnly)footPose);
        this.footTrajectoryPublisher.publish((Object)message);
    }

    public void sendKick(RobotSide robotSide, double trajectoryDuration, double stanceWidth, SegmentDependentList<RobotSide, ? extends ReferenceFrame> soleFrames) {
        FramePose3D footPose = new FramePose3D((ReferenceFrame)soleFrames.get((Enum)robotSide.getOppositeSide()));
        footPose.appendTranslation(0.6, robotSide.negateIfRightSide(stanceWidth), 0.35);
        footPose.appendPitchRotation(-0.8);
        footPose.changeFrame(ReferenceFrame.getWorldFrame());
        FootTrajectoryMessage message = HumanoidMessageTools.createFootTrajectoryMessage((RobotSide)robotSide, (double)(0.33 * trajectoryDuration), (Pose3DReadOnly)footPose);
        this.footTrajectoryPublisher.publish((Object)message);
    }

    public void sendPutFootDown(RobotSide robotSide, double trajectoryDuration, double stanceWidth, SegmentDependentList<RobotSide, ? extends ReferenceFrame> soleFrames) {
        FramePose3D footPose = new FramePose3D((ReferenceFrame)soleFrames.get((Enum)robotSide.getOppositeSide()));
        footPose.appendTranslation(0.0, robotSide.negateIfRightSide(stanceWidth), 0.0);
        footPose.changeFrame(ReferenceFrame.getWorldFrame());
        FootTrajectoryMessage message = HumanoidMessageTools.createFootTrajectoryMessage((RobotSide)robotSide, (double)trajectoryDuration, (Pose3DReadOnly)footPose);
        this.footTrajectoryPublisher.publish((Object)message);
        this.footLoadBearingPublisher.publish((Object)HumanoidMessageTools.createFootLoadBearingMessage((RobotSide)robotSide, (LoadBearingRequest)LoadBearingRequest.LOAD));
    }

    public void sendFreezeRequest() {
        AtlasLowLevelControlModeMessage message = new AtlasLowLevelControlModeMessage();
        message.setRequestedAtlasLowLevelControlMode(AtlasLowLevelControlMode.FREEZE.toByte());
        this.atlasLowLevelControlModePublisher.publish((Object)message);
    }

    public void sendStandRequest() {
        AtlasLowLevelControlModeMessage message = new AtlasLowLevelControlModeMessage();
        message.setRequestedAtlasLowLevelControlMode(AtlasLowLevelControlMode.STAND_PREP.toByte());
        this.atlasLowLevelControlModePublisher.publish((Object)message);
    }

    public void sendAbortWalkingRequest() {
        this.abortWalkingPublisher.publish((Object)new AbortWalkingMessage());
    }

    public void sendPauseWalkingRequest() {
        PauseWalkingMessage message = new PauseWalkingMessage();
        message.setPause(true);
        this.pauseWalkingPublisher.publish((Object)message);
    }

    public void sendContinueWalkingRequest() {
        PauseWalkingMessage message = new PauseWalkingMessage();
        message.setPause(false);
        this.pauseWalkingPublisher.publish((Object)message);
    }
}

