/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.diagnostic;

import java.util.HashMap;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WholeBodySetpointParameters;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;

public class AtlasDiagnosticSetpoints
implements WholeBodySetpointParameters {
    private final HashMap<String, Double> setPoints = new HashMap();
    private final AtlasJointMap jointMap;

    public AtlasDiagnosticSetpoints(AtlasJointMap jointMap) {
        this.jointMap = jointMap;
        this.useDefaultAngles();
    }

    private void useDefaultAngles() {
        this.setSetpoint(this.jointMap.getNeckJointName(NeckJointName.PROXIMAL_NECK_PITCH), 0.0);
        this.setSetpoint(this.jointMap.getNeckJointName(NeckJointName.DISTAL_NECK_YAW), 0.0);
        this.setSetpoint(this.jointMap.getNeckJointName(NeckJointName.DISTAL_NECK_PITCH), 0.0);
        this.setSetpoint(this.jointMap.getSpineJointName(SpineJointName.SPINE_YAW), 0.0);
        this.setSetpoint(this.jointMap.getSpineJointName(SpineJointName.SPINE_PITCH), 0.0);
        this.setSetpoint(this.jointMap.getSpineJointName(SpineJointName.SPINE_ROLL), 0.0);
        for (RobotSide robotSide : RobotSide.values) {
            this.setSetpoint(this.jointMap.getLegJointName(robotSide, LegJointName.HIP_YAW), 0.0);
            this.setSetpoint(this.jointMap.getLegJointName(robotSide, LegJointName.HIP_ROLL), robotSide.negateIfRightSide(0.1));
            this.setSetpoint(this.jointMap.getLegJointName(robotSide, LegJointName.HIP_PITCH), -0.6);
            this.setSetpoint(this.jointMap.getLegJointName(robotSide, LegJointName.KNEE_PITCH), 1.3);
            this.setSetpoint(this.jointMap.getLegJointName(robotSide, LegJointName.ANKLE_PITCH), -0.65);
            this.setSetpoint(this.jointMap.getLegJointName(robotSide, LegJointName.ANKLE_ROLL), 0.0);
            this.setSetpoint(this.jointMap.getArmJointName(robotSide, ArmJointName.SHOULDER_YAW), 0.0);
            this.setSetpoint(this.jointMap.getArmJointName(robotSide, ArmJointName.SHOULDER_ROLL), robotSide.negateIfLeftSide(1.0));
            this.setSetpoint(this.jointMap.getArmJointName(robotSide, ArmJointName.ELBOW_PITCH), 2.0);
            this.setSetpoint(this.jointMap.getArmJointName(robotSide, ArmJointName.ELBOW_ROLL), robotSide.negateIfRightSide(0.5));
        }
    }

    private void setSetpoint(String jointName, double value) {
        this.setPoints.put(jointName, value);
    }

    public double getSetpoint(String jointName) {
        if (this.setPoints.containsKey(jointName)) {
            return this.setPoints.get(jointName);
        }
        return 0.0;
    }
}

