/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.diagnostic;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.atlas.diagnostic.AtlasDiagnosticSetpoints;
import us.ihmc.atlas.parameters.AtlasHighLevelControllerParameters;
import us.ihmc.commonWalkingControlModules.configurations.GroupParameter;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.highLevelStates.WholeBodySetpointParameters;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.sensorProcessing.outputData.JointDesiredBehaviorReadOnly;
import us.ihmc.sensorProcessing.outputData.JointDesiredControlMode;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.wholeBodyController.diagnostics.AutomatedDiagnosticConfiguration;
import us.ihmc.wholeBodyController.diagnostics.DiagnosticParameters;

public class AtlasDiagnosticParameters
extends DiagnosticParameters {
    private final AtlasJointMap jointMap;
    private final HumanoidRobotSensorInformation sensorInformation;
    private final boolean runningOnRealRobot;
    private final AtlasDiagnosticSetpoints setpoints;

    public AtlasDiagnosticParameters(AtlasJointMap jointMap, HumanoidRobotSensorInformation sensorInformation, boolean runningOnRealRobot) {
        this.jointMap = jointMap;
        this.sensorInformation = sensorInformation;
        this.runningOnRealRobot = runningOnRealRobot;
        this.setpoints = new AtlasDiagnosticSetpoints(jointMap);
    }

    public void scheduleCheckUps(AutomatedDiagnosticConfiguration configuration) {
        configuration.addWait(1.0);
        configuration.addJointCheckUps(AtlasDiagnosticParameters.defaultJointCheckUpConfiguration(this.jointMap));
        configuration.addPelvisIMUCheckUpDiagnostic(DiagnosticParameters.defaultPelvisIMUCheckUp((HumanoidRobotSensorInformation)this.sensorInformation, (HumanoidJointNameMap)this.jointMap));
    }

    public static List<List<String>> defaultJointCheckUpConfiguration(HumanoidJointNameMap jointMap) {
        ArrayList<List<String>> jointNames = new ArrayList<List<String>>();
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, LegJointName.ANKLE_ROLL));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, LegJointName.ANKLE_PITCH));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, LegJointName.KNEE_PITCH));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, LegJointName.HIP_PITCH));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, LegJointName.HIP_ROLL));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, LegJointName.HIP_YAW));
        jointNames.add(Collections.singletonList(jointMap.getSpineJointName(SpineJointName.SPINE_YAW)));
        jointNames.add(Collections.singletonList(jointMap.getSpineJointName(SpineJointName.SPINE_PITCH)));
        jointNames.add(Collections.singletonList(jointMap.getSpineJointName(SpineJointName.SPINE_ROLL)));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, ArmJointName.SHOULDER_YAW));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, ArmJointName.SHOULDER_ROLL));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, ArmJointName.ELBOW_PITCH));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, ArmJointName.ELBOW_ROLL));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, ArmJointName.FIRST_WRIST_PITCH));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, ArmJointName.WRIST_ROLL));
        jointNames.add(AtlasHighLevelControllerParameters.getLeftAndRightJointNames(jointMap, ArmJointName.SECOND_WRIST_PITCH));
        return jointNames;
    }

    public double getInitialJointSplineDuration() {
        return this.runningOnRealRobot ? 10.0 : 1.0;
    }

    public List<GroupParameter<JointDesiredBehaviorReadOnly>> getDesiredJointBehaviors() {
        ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>> behaviors = new ArrayList<GroupParameter<JointDesiredBehaviorReadOnly>>();
        if (this.runningOnRealRobot) {
            throw new RuntimeException("Add gains for real robot.");
        }
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SHOULDER_YAW, JointDesiredControlMode.EFFORT, 200.0, 20.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SHOULDER_ROLL, JointDesiredControlMode.EFFORT, 200.0, 20.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.ELBOW_PITCH, JointDesiredControlMode.EFFORT, 100.0, 10.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.ELBOW_ROLL, JointDesiredControlMode.EFFORT, 100.0, 10.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.FIRST_WRIST_PITCH, JointDesiredControlMode.EFFORT, 50.0, 5.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.WRIST_ROLL, JointDesiredControlMode.EFFORT, 10.0, 1.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, ArmJointName.SECOND_WRIST_PITCH, JointDesiredControlMode.EFFORT, 0.5, 0.05);
        AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, NeckJointName.PROXIMAL_NECK_PITCH, JointDesiredControlMode.EFFORT, 50.0, 5.0);
        AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_YAW, JointDesiredControlMode.EFFORT, 400.0, 40.0);
        AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_PITCH, JointDesiredControlMode.EFFORT, 400.0, 40.0);
        AtlasHighLevelControllerParameters.configureBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, SpineJointName.SPINE_ROLL, JointDesiredControlMode.EFFORT, 400.0, 40.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_YAW, JointDesiredControlMode.EFFORT, 200.0, 20.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_ROLL, JointDesiredControlMode.EFFORT, 200.0, 20.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.HIP_PITCH, JointDesiredControlMode.EFFORT, 20.0, 20.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.KNEE_PITCH, JointDesiredControlMode.EFFORT, 100.0, 10.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.ANKLE_PITCH, JointDesiredControlMode.EFFORT, 50.0, 5.0);
        AtlasHighLevelControllerParameters.configureSymmetricBehavior(behaviors, (HumanoidJointNameMap)this.jointMap, LegJointName.ANKLE_ROLL, JointDesiredControlMode.EFFORT, 50.0, 5.0);
        return behaviors;
    }

    public WholeBodySetpointParameters getDiagnosticSetpoints() {
        return this.setpoints;
    }
}

