/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors.scsSensorSimulation;

import java.util.Random;
import java.util.concurrent.LinkedBlockingQueue;
import us.ihmc.atlas.behaviors.scsSensorSimulation.SensorOnlyRobot;
import us.ihmc.euclid.referenceFrame.FramePoint3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.referenceFrame.interfaces.FramePoint3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.yoGraphics.BagOfBalls;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphic;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicPosition;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.GPULidar;
import us.ihmc.robotics.controllers.PDController;
import us.ihmc.robotics.lidar.LidarScan;
import us.ihmc.robotics.lidar.LidarScanParameters;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.yoVariables.euclid.referenceFrame.YoFramePoint3D;
import us.ihmc.yoVariables.registry.YoRegistry;
import us.ihmc.yoVariables.variable.YoDouble;

public class SensorOnlyController
implements RobotController {
    private YoRegistry registry = new YoRegistry(this.getClass().getSimpleName());
    private final SensorOnlyRobot robot;
    private final SimulationConstructionSet scs;
    private final LidarScanParameters lidarScanParameters;
    private GPULidar gpuLidar;
    private LinkedBlockingQueue<LidarScan> gpuLidarScanBuffer = new LinkedBlockingQueue();
    private YoDouble tauLidarZ;
    private YoDouble tauLidarX;
    private YoDouble qLidarZ;
    private YoDouble qLidarX;
    private final YoFramePoint3D point = new YoFramePoint3D("point", ReferenceFrame.getWorldFrame(), this.registry);
    private final BagOfBalls bagOfBalls;
    private PDController pdControllerZ;
    private PDController pdControllerX;
    private final YoDouble proportionalGain;
    private final YoDouble derivativeGain;
    private double lastPositionZ;
    private double lastPositionX;
    private double lastTime;
    private double desiredZRate = 0.3;
    private static final double DESIRED_X_RATE = 0.3;
    private final Random random = new Random(1776L);

    public SensorOnlyController(SensorOnlyRobot robot, YoGraphicsListRegistry yoGraphicsListRegistry, SimulationConstructionSet scs) {
        this.robot = robot;
        this.scs = scs;
        this.lidarScanParameters = robot.getLidarScanParameters();
        YoGraphicPosition yoGraphicPosition = new YoGraphicPosition("point", this.point, 0.01, YoAppearance.Purple());
        yoGraphicsListRegistry.registerYoGraphic("test", (YoGraphic)yoGraphicPosition);
        this.bagOfBalls = new BagOfBalls(this.lidarScanParameters.getPointsPerSweep(), 0.005, YoAppearance.AliceBlue(), this.registry, yoGraphicsListRegistry);
        this.tauLidarZ = (YoDouble)robot.findVariable("tau_gimbalZ");
        this.tauLidarX = (YoDouble)robot.findVariable("tau_gimbalX");
        this.qLidarZ = (YoDouble)robot.findVariable("q_gimbalZ");
        this.qLidarX = (YoDouble)robot.findVariable("q_gimbalX");
        this.proportionalGain = new YoDouble("lidarPGain", this.registry);
        this.derivativeGain = new YoDouble("lidarDGain", this.registry);
        this.pdControllerX = new PDController(this.proportionalGain, this.derivativeGain, "LidarControllerX", this.registry);
        this.pdControllerZ = new PDController(this.proportionalGain, this.derivativeGain, "LidarControllerZ", this.registry);
        this.pdControllerZ.setProportionalGain(1.0);
        this.pdControllerZ.setDerivativeGain(1.0);
        this.lastPositionZ = this.qLidarZ.getDoubleValue();
        this.lastPositionX = this.qLidarX.getDoubleValue();
        this.lastTime = scs.getTime();
    }

    public void initialize() {
        this.startGPULidar();
    }

    private void startGPULidar() {
        this.gpuLidar = this.scs.getGraphics3dAdapter().createGPULidar(this.lidarScanParameters.getPointsPerSweep(), this.lidarScanParameters.getScanHeight(), (double)this.lidarScanParameters.getFieldOfView(), (double)this.lidarScanParameters.getMinRange(), (double)this.lidarScanParameters.getMaxRange());
        this.gpuLidar.addGPULidarListener((scan, currentTransform, time) -> this.gpuLidarScanBuffer.add(new LidarScan(this.lidarScanParameters, new RigidBodyTransform((RigidBodyTransformReadOnly)currentTransform), new RigidBodyTransform((RigidBodyTransformReadOnly)currentTransform), scan)));
    }

    public YoRegistry getYoRegistry() {
        return this.registry;
    }

    public String getName() {
        return this.registry.getName();
    }

    public String getDescription() {
        return this.getName();
    }

    public void doControl() {
        double currentTime = this.scs.getTime();
        double dt = currentTime - this.lastTime;
        this.lastTime = currentTime;
        double currentZPosition = this.qLidarZ.getValueAsDouble();
        double desiredZPosition = this.lastPositionZ + this.desiredZRate * dt;
        double currentZRate = (currentZPosition - this.lastPositionZ) * dt;
        double desiredXRate = Math.cos(currentZPosition) * 0.3;
        double currentXPosition = this.qLidarX.getValueAsDouble();
        double desiredXPosition = this.lastPositionX + desiredXRate * dt;
        double currentXRate = (currentXPosition - this.lastPositionX) * dt;
        double zCorrectionSum = this.pdControllerZ.compute(currentZPosition, desiredZPosition, currentZRate, this.desiredZRate);
        double xCorrectionSum = this.pdControllerX.compute(currentXPosition, desiredXPosition, currentXRate, desiredXRate);
        this.tauLidarZ.set(zCorrectionSum);
        this.tauLidarX.set(xCorrectionSum);
        this.lastPositionX = currentXPosition;
        this.lastPositionZ = currentZPosition;
        RigidBodyTransform transform = new RigidBodyTransform();
        this.robot.getLidarXJoint().getTransformToWorld((RigidBodyTransformBasics)transform);
        this.gpuLidar.setTransformFromWorld(transform, 0.0);
        while (!this.gpuLidarScanBuffer.isEmpty()) {
            LidarScan scan = this.gpuLidarScanBuffer.poll();
            for (int i = 0; i < scan.size(); ++i) {
                this.bagOfBalls.setBallLoop((FramePoint3DReadOnly)new FramePoint3D(ReferenceFrame.getWorldFrame(), (Tuple3DReadOnly)scan.getPoint(i)), YoAppearance.randomColor((Random)this.random));
            }
        }
    }
}

