/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors.scsSensorSimulation;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.List;
import javax.imageio.ImageIO;
import perception_msgs.msg.dds.VideoPacket;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.behaviors.SCSVideoDataROS2Bridge;
import us.ihmc.atlas.behaviors.scsSensorSimulation.FunctionalRobotController;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.environments.BehaviorPlanarRegionEnvironments;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.producers.VideoDataServer;
import us.ihmc.communication.producers.VideoDataServerImageCallback;
import us.ihmc.euclid.Axis3D;
import us.ihmc.euclid.referenceFrame.FramePose3D;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.graphicsDescription.Graphics3DObject;
import us.ihmc.graphicsDescription.HeightMap;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearance;
import us.ihmc.graphicsDescription.appearance.YoAppearanceTexture;
import us.ihmc.graphicsDescription.image.ImageCallback;
import us.ihmc.jMonkeyEngineToolkit.GroundProfile3D;
import us.ihmc.jMonkeyEngineToolkit.HeightMapWithNormals;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.lidar.LidarScanParameters;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.robotDescription.LidarSensorDescription;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.ROS2Input;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.FiducialDoorEnvironment;
import us.ihmc.simulationConstructionSetTools.util.environments.PlanarRegionsListDefinedEnvironment;
import us.ihmc.simulationconstructionset.CameraMount;
import us.ihmc.simulationconstructionset.FloatingJoint;
import us.ihmc.simulationconstructionset.GimbalJoint;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.Link;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.simulatedSensors.LidarMount;
import us.ihmc.simulationconstructionset.util.RobotController;
import us.ihmc.tools.gui.AWTTools;
import us.ihmc.wholeBodyController.AdditionalSimulationContactPoints;
import us.ihmc.wholeBodyController.FootContactPoints;

public class SCSDoorAndCameraSimulator {
    private final ROS2Input<RobotConfigurationData> robotConfigurationData;
    private final ROS2SyncedRobotModel syncedRobot;
    private final FramePose3D tempNeckFramePose = new FramePose3D();
    private final SimulationConstructionSet scs;
    private final FloatingJoint floatingHeadJoint;

    public SCSDoorAndCameraSimulator(ROS2Node ros2Node, CommonAvatarEnvironmentInterface environment, DRCRobotModel robotModel, boolean startMinimized) {
        this.robotConfigurationData = new ROS2Input((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, ROS2Tools.HUMANOID_CONTROLLER.withRobot(robotModel.getSimpleRobotName()).withOutput());
        this.syncedRobot = new ROS2SyncedRobotModel(robotModel, (ROS2NodeInterface)ros2Node);
        Robot robot = new Robot("Robot");
        this.floatingHeadJoint = new FloatingJoint("head", (Tuple3DReadOnly)new Vector3D(), robot);
        Link link = new Link("lidar");
        double radius = 0.05;
        link.setMassAndRadiiOfGyration(1.0, radius, radius, radius);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        link.setLinkGraphics(linkGraphics);
        linkGraphics.addModelFile("models/hokuyo.dae", YoAppearance.Black());
        linkGraphics.translate(0.0, 0.0, -0.1);
        link.setLinkGraphics(linkGraphics);
        this.floatingHeadJoint.setLink(link);
        String videoCameraMountName = "videoCameraMount";
        CameraMount videoCameraMount = new CameraMount(videoCameraMountName, (Tuple3DReadOnly)new Vector3D(), robot);
        this.floatingHeadJoint.addCameraMount(videoCameraMount);
        GimbalJoint gimbalJoint = this.setupLidarGimbal(robot);
        robot.addRootJoint((Joint)this.floatingHeadJoint);
        robot.setGravity(0.0);
        if (environment.getEnvironmentRobots() != null) {
            Robot[] robots = new Robot[1 + environment.getEnvironmentRobots().size()];
            robots[0] = robot;
            List environmentRobots = environment.getEnvironmentRobots();
            for (int i = 0; i < environmentRobots.size(); ++i) {
                robots[i + 1] = (Robot)environmentRobots.get(i);
            }
            this.scs = new SimulationConstructionSet(robots);
        } else {
            this.scs = new SimulationConstructionSet(robot);
        }
        this.scs.setDT(0.001, 100);
        FunctionalRobotController controller = new FunctionalRobotController();
        controller.setDoControl(this::doControl);
        robot.setController((RobotController)controller);
        ROS2Input robotConfigurationData = new ROS2Input((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, ROS2Tools.HUMANOID_CONTROLLER.withRobot(robotModel.getSimpleRobotName()).withOutput());
        IHMCROS2Publisher scsCameraPublisher = new IHMCROS2Publisher((ROS2NodeInterface)ros2Node, VideoPacket.class, ROS2Tools.IHMC_ROOT);
        CameraConfiguration cameraConfiguration = new CameraConfiguration(videoCameraMountName);
        cameraConfiguration.setCameraMount(videoCameraMountName);
        cameraConfiguration.setCameraFieldOfView(80.0);
        this.scs.setupCamera(cameraConfiguration);
        int width = 1024;
        int height = 544;
        int framesPerSecond = 25;
        this.scs.startStreamingVideoData(cameraConfiguration, width, height, (ImageCallback)new VideoDataServerImageCallback((VideoDataServer)new SCSVideoDataROS2Bridge(arg_0 -> ((IHMCROS2Publisher)scsCameraPublisher).publish(arg_0))), () -> ((RobotConfigurationData)robotConfigurationData.getLatest()).getSyncTimestamp(), framesPerSecond);
        this.scs.setGroundVisible(false);
        this.scs.addStaticLinkGraphics(environment.getTerrainObject3D().getLinkGraphics());
        this.scs.getGUI().getFrame().setSize(AWTTools.getDimensionOfSmallestScreenScaled((double)0.6666666666666666));
        this.scs.startOnAThread();
        if (startMinimized) {
            this.scs.getGUI().getFrame().setState(1);
        }
        this.scs.simulate();
    }

    private GimbalJoint setupLidarGimbal(Robot lidarRobot) {
        double height = 0.2;
        double radius = 0.05;
        GimbalJoint gimbalJoint = new GimbalJoint("gimbalZ", "gimbalX", "gimbalY", (Vector3DReadOnly)new Vector3D(0.0, 0.0, 1.0), lidarRobot, Axis3D.Z, Axis3D.X, Axis3D.Y);
        Link link = new Link("lidar");
        link.setMassAndRadiiOfGyration(1.0, radius, radius, radius);
        Graphics3DObject linkGraphics = new Graphics3DObject();
        link.setLinkGraphics(linkGraphics);
        gimbalJoint.setLink(link);
        gimbalJoint.setDamping(1.0);
        CameraMount robotCam = new CameraMount("camera", (Tuple3DReadOnly)new Vector3D(radius + 0.001, 0.0, height / 2.0), lidarRobot);
        gimbalJoint.addCameraMount(robotCam);
        RigidBodyTransform transform = new RigidBodyTransform();
        transform.getTranslation().set((Tuple3DReadOnly)new Vector3D(radius + 0.001, 0.0, height / 2.0));
        LidarScanParameters lidarScanParameters = new LidarScanParameters(720, -1.5707964f, 1.5707964f, 0.0f, 0.1f, 30.0f, 0.0f);
        LidarSensorDescription lidarSensorDescription = new LidarSensorDescription("lidar", (RigidBodyTransformReadOnly)transform);
        lidarSensorDescription.setPointsPerSweep(lidarScanParameters.getPointsPerSweep());
        lidarSensorDescription.setScanHeight(lidarScanParameters.getScanHeight());
        lidarSensorDescription.setSweepYawLimits((double)lidarScanParameters.getSweepYawMin(), (double)lidarScanParameters.getSweepYawMax());
        lidarSensorDescription.setHeightPitchLimits((double)lidarScanParameters.heightPitchMin, (double)lidarScanParameters.heightPitchMax);
        lidarSensorDescription.setRangeLimits((double)lidarScanParameters.getMinRange(), (double)lidarScanParameters.getMaxRange());
        LidarMount lidarMount = new LidarMount(lidarSensorDescription);
        gimbalJoint.addLidarMount(lidarMount);
        linkGraphics.addModelFile("models/hokuyo.dae", YoAppearance.Black());
        linkGraphics.translate(0.0, 0.0, -0.1);
        link.setLinkGraphics(linkGraphics);
        return gimbalJoint;
    }

    private void doControl() {
        this.syncedRobot.update();
        this.tempNeckFramePose.setToZero((ReferenceFrame)this.syncedRobot.getReferenceFrames().getNeckFrame(NeckJointName.PROXIMAL_NECK_PITCH));
        this.tempNeckFramePose.changeFrame(ReferenceFrame.getWorldFrame());
        this.floatingHeadJoint.setPosition((Tuple3DReadOnly)this.tempNeckFramePose.getPosition());
        this.floatingHeadJoint.setQuaternion((QuaternionReadOnly)this.tempNeckFramePose.getOrientation());
    }

    private Graphics3DObject createGroundLinkGraphicsFromGroundProfile(GroundProfile3D groundProfile) {
        Graphics3DObject texturedGroundLinkGraphics = new Graphics3DObject();
        HeightMapWithNormals heightMap = groundProfile.getHeightMapIfAvailable();
        texturedGroundLinkGraphics.addHeightMap((HeightMap)heightMap, 300, 300, YoAppearance.DarkGreen());
        return texturedGroundLinkGraphics;
    }

    private static AtlasRobotModel createRobotModel() {
        AdditionalSimulationContactPoints simulationContactPoints = new AdditionalSimulationContactPoints((Enum[])RobotSide.values, 8, 3, true, true);
        return new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.SCS, false, (FootContactPoints<RobotSide>)simulationContactPoints);
    }

    private static CommonAvatarEnvironmentInterface createCommonAvatarEnvironment() {
        String environmentName = PlanarRegionsListDefinedEnvironment.class.getSimpleName();
        BufferedImage image = (BufferedImage)ExceptionTools.handle(() -> ImageIO.read(Class.class.getResourceAsStream("/sampleMeshes/cinderblock.png")), (ExceptionHandler)DefaultExceptionHandler.PRINT_STACKTRACE);
        YoAppearanceTexture cinderBlockTexture = new YoAppearanceTexture(image);
        return new PlanarRegionsListDefinedEnvironment(environmentName, BehaviorPlanarRegionEnvironments.createRoughUpAndDownStepsWithFlatTop(), (AppearanceDefinition)cinderBlockTexture, 0.02, false);
    }

    public static void main(String[] args) throws IOException {
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.INTRAPROCESS, (String)"REA_module");
        boolean startMinimized = false;
        new SCSDoorAndCameraSimulator(ros2Node, (CommonAvatarEnvironmentInterface)new FiducialDoorEnvironment(), SCSDoorAndCameraSimulator.createRobotModel(), startMinimized);
    }
}

