/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.tuple.ImmutablePair;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.parameters.AtlasPhysicalProperties;
import us.ihmc.atlas.ros.AtlasOrderedJointMap;
import us.ihmc.avatar.drcRobot.RobotPhysicalProperties;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.controllers.pidGains.implementations.YoPDGains;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.JointRole;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.wholeBodyController.DRCHandType;
import us.ihmc.yoVariables.registry.YoRegistry;

public class AtlasJointMap
implements HumanoidJointNameMap {
    public static final boolean ENABLE_JOINT_VELOCITY_TORQUE_LIMITS = false;
    public static final String chestName = "utorso";
    public static final String pelvisName = "pelvis";
    public static final String headName = "head";
    public static final SideDependentList<String> handNames;
    protected final SideDependentList<String> forearmNames = new SideDependentList();
    public static final SideDependentList<String> footNames;
    private final LegJointName[] legJoints = new LegJointName[]{LegJointName.HIP_YAW, LegJointName.HIP_ROLL, LegJointName.HIP_PITCH, LegJointName.KNEE_PITCH, LegJointName.ANKLE_PITCH, LegJointName.ANKLE_ROLL};
    private final ArmJointName[] armJoints;
    private final SpineJointName[] spineJoints = new SpineJointName[]{SpineJointName.SPINE_PITCH, SpineJointName.SPINE_ROLL, SpineJointName.SPINE_YAW};
    private final NeckJointName[] neckJoints = new NeckJointName[]{NeckJointName.PROXIMAL_NECK_PITCH};
    private final LinkedHashMap<String, JointRole> jointRoles = new LinkedHashMap();
    private final LinkedHashMap<String, ImmutablePair<RobotSide, LegJointName>> legJointNames = new LinkedHashMap();
    private final LinkedHashMap<String, ImmutablePair<RobotSide, ArmJointName>> armJointNames = new LinkedHashMap();
    private final LinkedHashMap<String, SpineJointName> spineJointNames = new LinkedHashMap();
    private final LinkedHashMap<String, NeckJointName> neckJointNames = new LinkedHashMap();
    private final SideDependentList<EnumMap<LegJointName, String>> legJointStrings = SideDependentList.createListOfEnumMaps(LegJointName.class);
    private final SideDependentList<EnumMap<ArmJointName, String>> armJointStrings = SideDependentList.createListOfEnumMaps(ArmJointName.class);
    private final EnumMap<SpineJointName, String> spineJointStrings = new EnumMap(SpineJointName.class);
    private final EnumMap<NeckJointName, String> neckJointStrings = new EnumMap(NeckJointName.class);
    private final AtlasRobotVersion atlasVersion;
    private final AtlasPhysicalProperties atlasPhysicalProperties;
    private final SideDependentList<String> nameOfJointsBeforeHands = new SideDependentList();
    private final String[] jointNamesBeforeFeet = new String[2];

    public AtlasJointMap(AtlasRobotVersion atlasVersion, AtlasPhysicalProperties atlasPhysicalProperties) {
        this.atlasVersion = atlasVersion;
        this.atlasPhysicalProperties = atlasPhysicalProperties;
        this.armJoints = atlasVersion != AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_FOREARMS ? new ArmJointName[]{ArmJointName.SHOULDER_YAW, ArmJointName.SHOULDER_ROLL, ArmJointName.ELBOW_PITCH, ArmJointName.ELBOW_ROLL, ArmJointName.FIRST_WRIST_PITCH, ArmJointName.WRIST_ROLL, ArmJointName.SECOND_WRIST_PITCH} : new ArmJointName[]{ArmJointName.SHOULDER_YAW, ArmJointName.SHOULDER_ROLL, ArmJointName.ELBOW_PITCH, ArmJointName.ELBOW_ROLL};
        for (RobotSide robotSide : RobotSide.values) {
            String[] forcedSideJointNames = (String[])AtlasOrderedJointMap.forcedSideDependentJointNames.get((Enum)robotSide);
            this.legJointNames.put(forcedSideJointNames[4], (ImmutablePair<RobotSide, LegJointName>)new ImmutablePair((Object)robotSide, (Object)LegJointName.HIP_YAW));
            this.legJointNames.put(forcedSideJointNames[5], (ImmutablePair<RobotSide, LegJointName>)new ImmutablePair((Object)robotSide, (Object)LegJointName.HIP_ROLL));
            this.legJointNames.put(forcedSideJointNames[6], (ImmutablePair<RobotSide, LegJointName>)new ImmutablePair((Object)robotSide, (Object)LegJointName.HIP_PITCH));
            this.legJointNames.put(forcedSideJointNames[7], (ImmutablePair<RobotSide, LegJointName>)new ImmutablePair((Object)robotSide, (Object)LegJointName.KNEE_PITCH));
            this.legJointNames.put(forcedSideJointNames[8], (ImmutablePair<RobotSide, LegJointName>)new ImmutablePair((Object)robotSide, (Object)LegJointName.ANKLE_PITCH));
            this.legJointNames.put(forcedSideJointNames[9], (ImmutablePair<RobotSide, LegJointName>)new ImmutablePair((Object)robotSide, (Object)LegJointName.ANKLE_ROLL));
            this.armJointNames.put(forcedSideJointNames[16], (ImmutablePair<RobotSide, ArmJointName>)new ImmutablePair((Object)robotSide, (Object)ArmJointName.SHOULDER_YAW));
            this.armJointNames.put(forcedSideJointNames[17], (ImmutablePair<RobotSide, ArmJointName>)new ImmutablePair((Object)robotSide, (Object)ArmJointName.SHOULDER_ROLL));
            this.armJointNames.put(forcedSideJointNames[18], (ImmutablePair<RobotSide, ArmJointName>)new ImmutablePair((Object)robotSide, (Object)ArmJointName.ELBOW_PITCH));
            this.armJointNames.put(forcedSideJointNames[19], (ImmutablePair<RobotSide, ArmJointName>)new ImmutablePair((Object)robotSide, (Object)ArmJointName.ELBOW_ROLL));
            if (atlasVersion != AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_FOREARMS) {
                handNames.put((Enum)robotSide, (Object)(AtlasJointMap.getRobotSidePrefix(robotSide) + "hand"));
            } else {
                handNames.put((Enum)robotSide, (Object)(AtlasJointMap.getRobotSidePrefix(robotSide) + "larm"));
            }
            if (atlasVersion == AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_FOREARMS) continue;
            this.armJointNames.put(forcedSideJointNames[20], (ImmutablePair<RobotSide, ArmJointName>)new ImmutablePair((Object)robotSide, (Object)ArmJointName.FIRST_WRIST_PITCH));
            this.armJointNames.put(forcedSideJointNames[21], (ImmutablePair<RobotSide, ArmJointName>)new ImmutablePair((Object)robotSide, (Object)ArmJointName.WRIST_ROLL));
            this.armJointNames.put(forcedSideJointNames[22], (ImmutablePair<RobotSide, ArmJointName>)new ImmutablePair((Object)robotSide, (Object)ArmJointName.SECOND_WRIST_PITCH));
        }
        this.spineJointNames.put(AtlasOrderedJointMap.jointNames[0], SpineJointName.SPINE_YAW);
        this.spineJointNames.put(AtlasOrderedJointMap.jointNames[1], SpineJointName.SPINE_PITCH);
        this.spineJointNames.put(AtlasOrderedJointMap.jointNames[2], SpineJointName.SPINE_ROLL);
        this.neckJointNames.put(AtlasOrderedJointMap.jointNames[3], NeckJointName.PROXIMAL_NECK_PITCH);
        for (String legJointString : this.legJointNames.keySet()) {
            RobotSide robotSide = (RobotSide)this.legJointNames.get(legJointString).getLeft();
            LegJointName legJointName = (LegJointName)this.legJointNames.get(legJointString).getRight();
            ((EnumMap)this.legJointStrings.get((Enum)robotSide)).put(legJointName, legJointString);
            this.jointRoles.put(legJointString, JointRole.LEG);
        }
        for (String armJointString : this.armJointNames.keySet()) {
            RobotSide robotSide = (RobotSide)this.armJointNames.get(armJointString).getLeft();
            ArmJointName armJointName = (ArmJointName)this.armJointNames.get(armJointString).getRight();
            ((EnumMap)this.armJointStrings.get((Enum)robotSide)).put(armJointName, armJointString);
            this.jointRoles.put(armJointString, JointRole.ARM);
        }
        for (String spineJointString : this.spineJointNames.keySet()) {
            this.spineJointStrings.put(this.spineJointNames.get(spineJointString), spineJointString);
            this.jointRoles.put(spineJointString, JointRole.SPINE);
        }
        for (String neckJointString : this.neckJointNames.keySet()) {
            this.neckJointStrings.put(this.neckJointNames.get(neckJointString), neckJointString);
            this.jointRoles.put(neckJointString, JointRole.NECK);
        }
        for (RobotSide robtSide : RobotSide.values) {
            if (atlasVersion != AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_FOREARMS) {
                this.nameOfJointsBeforeHands.put((Enum)robtSide, (Object)((String)((EnumMap)this.armJointStrings.get((Enum)robtSide)).get(ArmJointName.SECOND_WRIST_PITCH)));
                continue;
            }
            this.nameOfJointsBeforeHands.put((Enum)robtSide, (Object)((String)((EnumMap)this.armJointStrings.get((Enum)robtSide)).get(ArmJointName.ELBOW_ROLL)));
        }
        this.jointNamesBeforeFeet[0] = this.getJointBeforeFootName(RobotSide.LEFT);
        this.jointNamesBeforeFeet[1] = this.getJointBeforeFootName(RobotSide.RIGHT);
    }

    public SideDependentList<String> getNameOfJointBeforeHands() {
        if (this.atlasVersion != AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_FOREARMS) {
            return this.nameOfJointsBeforeHands;
        }
        return null;
    }

    public String getNameOfJointBeforeChest() {
        return this.spineJointStrings.get(SpineJointName.SPINE_ROLL);
    }

    private static String getRobotSidePrefix(RobotSide robotSide) {
        return robotSide == RobotSide.LEFT ? "l_" : "r_";
    }

    public ImmutablePair<RobotSide, LegJointName> getLegJointName(String jointName) {
        return this.legJointNames.get(jointName);
    }

    public ImmutablePair<RobotSide, ArmJointName> getArmJointName(String jointName) {
        return this.armJointNames.get(jointName);
    }

    public JointRole getJointRole(String jointName) {
        return this.jointRoles.get(jointName);
    }

    public NeckJointName getNeckJointName(String jointName) {
        return this.neckJointNames.get(jointName);
    }

    public SpineJointName getSpineJointName(String jointName) {
        return this.spineJointNames.get(jointName);
    }

    public String getPelvisName() {
        return pelvisName;
    }

    public String getChestName() {
        return chestName;
    }

    public String getHeadName() {
        return headName;
    }

    public String getHandName(RobotSide robotSide) {
        return (String)handNames.get((Enum)robotSide);
    }

    public String getForearmName(RobotSide robotSide) {
        return (String)this.forearmNames.get((Enum)robotSide);
    }

    public String getFootName(RobotSide robotSide) {
        return (String)footNames.get((Enum)robotSide);
    }

    public LegJointName[] getLegJointNames() {
        return this.legJoints;
    }

    public ArmJointName[] getArmJointNames() {
        return this.armJoints;
    }

    public SpineJointName[] getSpineJointNames() {
        return this.spineJoints;
    }

    public NeckJointName[] getNeckJointNames() {
        return this.neckJoints;
    }

    public String getJointBeforeFootName(RobotSide robotSide) {
        return (String)((EnumMap)this.legJointStrings.get((Enum)robotSide)).get(LegJointName.ANKLE_ROLL);
    }

    public String getJointBeforeHandName(RobotSide robotSide) {
        return (String)this.nameOfJointsBeforeHands.get((Enum)robotSide);
    }

    public List<ImmutablePair<String, YoPDGains>> getPassiveJointNameWithGains(YoRegistry registry) {
        return null;
    }

    public String getModelName() {
        return this.atlasVersion.getModelName();
    }

    public boolean isTorqueVelocityLimitsEnabled() {
        return false;
    }

    public Set<String> getLastSimulatedJoints() {
        HashSet<String> lastSimulatedJoints = new HashSet<String>();
        for (RobotSide robotSide : RobotSide.values) {
            DRCHandType handModel = this.atlasVersion.getHandModel(robotSide);
            if (handModel == null || handModel.isHandSimulated()) continue;
            lastSimulatedJoints.add((String)((EnumMap)this.armJointStrings.get((Enum)robotSide)).get(ArmJointName.SECOND_WRIST_PITCH));
        }
        return lastSimulatedJoints;
    }

    public String[] getOrderedJointNames() {
        return AtlasOrderedJointMap.jointNames;
    }

    public RigidBodyTransform getSoleToParentFrameTransform(RobotSide robotSide) {
        return (RigidBodyTransform)this.atlasPhysicalProperties.getSoleToAnkleFrameTransforms().get((Enum)robotSide);
    }

    public RigidBodyTransform getHandControlFrameToWristTransform(RobotSide robotSide) {
        RigidBodyTransform attachmentPlateToPalm = this.atlasVersion.getOffsetFromAttachmentPlate(robotSide);
        RigidBodyTransform attachmentPlateToWrist = (RigidBodyTransform)this.atlasPhysicalProperties.getHandAttachmentPlateToWristTransforms().get((Enum)robotSide);
        RigidBodyTransform handControlFrameToWristTranform = new RigidBodyTransform();
        handControlFrameToWristTranform.set(attachmentPlateToWrist);
        handControlFrameToWristTranform.multiply((RigidBodyTransformReadOnly)attachmentPlateToPalm);
        Vector3D translation = new Vector3D();
        translation.set((Tuple3DReadOnly)handControlFrameToWristTranform.getTranslation());
        translation.scale(this.getModelScale());
        handControlFrameToWristTranform.getTranslation().set((Tuple3DReadOnly)translation);
        return handControlFrameToWristTranform;
    }

    public String getLegJointName(RobotSide robotSide, LegJointName legJointName) {
        return (String)((EnumMap)this.legJointStrings.get((Enum)robotSide)).get(legJointName);
    }

    public String getArmJointName(RobotSide robotSide, ArmJointName armJointName) {
        return (String)((EnumMap)this.armJointStrings.get((Enum)robotSide)).get(armJointName);
    }

    public String getNeckJointName(NeckJointName neckJointName) {
        return this.neckJointStrings.get(neckJointName);
    }

    public String getSpineJointName(SpineJointName spineJointName) {
        return this.spineJointStrings.get(spineJointName);
    }

    public String[] getPositionControlledJointsForSimulation() {
        return this.getOrderedJointNames();
    }

    public String getUnsanitizedRootJointInSdf() {
        return pelvisName;
    }

    public String[] getJointNamesBeforeFeet() {
        return this.jointNamesBeforeFeet;
    }

    public RobotSide getEndEffectorsRobotSegment(String joineNameBeforeEndEffector) {
        for (RobotSide robotSide : RobotSide.values) {
            String jointBeforeFootName = this.getJointBeforeFootName(robotSide);
            if (jointBeforeFootName != null && jointBeforeFootName.equals(joineNameBeforeEndEffector)) {
                return robotSide;
            }
            String endOfArm = this.atlasVersion != AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_FOREARMS ? (String)((EnumMap)this.armJointStrings.get((Enum)robotSide)).get(ArmJointName.SECOND_WRIST_PITCH) : (String)((EnumMap)this.armJointStrings.get((Enum)robotSide)).get(ArmJointName.ELBOW_ROLL);
            if (endOfArm == null || !endOfArm.equals(joineNameBeforeEndEffector)) continue;
            return robotSide;
        }
        throw new IllegalArgumentException(joineNameBeforeEndEffector + " was not listed as an end effector in " + this.getClass().getSimpleName());
    }

    public double getModelScale() {
        return this.atlasPhysicalProperties.getModelScale();
    }

    public double getMassScalePower() {
        return this.atlasPhysicalProperties.getMassScalePower();
    }

    public RobotPhysicalProperties getPhysicalProperties() {
        return this.atlasPhysicalProperties;
    }

    public String[] getHighInertiaForStableSimulationJoints() {
        return new String[]{"hokuyo_joint"};
    }

    public double getJointBLimit(String jointName) {
        ImmutablePair<RobotSide, ArmJointName> pair;
        double defaultValue = super.getJointBLimit(jointName);
        if (!this.atlasVersion.hasRobotiqHands(jointName.startsWith("l_") ? RobotSide.LEFT : RobotSide.RIGHT) && (pair = this.getArmJointName(jointName)) != null) {
            switch ((ArmJointName)pair.getValue()) {
                case FIRST_WRIST_PITCH: 
                case SECOND_WRIST_PITCH: 
                case WRIST_ROLL: {
                    return 0.5 * defaultValue;
                }
            }
        }
        return defaultValue;
    }

    static {
        LogTools.info((String)"Running with torque and velocity limits disabled.");
        handNames = new SideDependentList();
        footNames = new SideDependentList((Object)(AtlasJointMap.getRobotSidePrefix(RobotSide.LEFT) + "foot"), (Object)(AtlasJointMap.getRobotSidePrefix(RobotSide.RIGHT) + "foot"));
    }
}

