/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas;

import com.martiansoftware.jsap.FlaggedOption;
import com.martiansoftware.jsap.JSAP;
import com.martiansoftware.jsap.JSAPException;
import com.martiansoftware.jsap.JSAPResult;
import com.martiansoftware.jsap.Parameter;
import com.martiansoftware.jsap.StringParser;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.fiducialDetectorToolBox.FiducialDetectorToolboxModule;
import us.ihmc.avatar.networkProcessor.objectDetectorToolBox.ObjectDetectorToolboxModule;
import us.ihmc.pubsub.DomainFactory;

public class AtlasCombinedFiducialModuleStarter {
    public static void main(String[] args) throws JSAPException {
        AtlasRobotModel robotModel;
        JSAP jsap = new JSAP();
        FlaggedOption robotModelFlag = new FlaggedOption("robotModel").setLongFlag("model").setShortFlag('m').setRequired(true).setStringParser((StringParser)JSAP.STRING_PARSER);
        robotModelFlag.setHelp("Robot models: " + AtlasRobotModelFactory.robotModelsToString());
        jsap.registerParameter((Parameter)robotModelFlag);
        JSAPResult config = jsap.parse(args);
        try {
            robotModel = AtlasRobotModelFactory.createDRCRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ.toString(), RobotTarget.REAL_ROBOT, false);
        }
        catch (IllegalArgumentException e) {
            System.err.println("Incorrect robot model " + config.getString("robotModel"));
            System.out.println(jsap.getHelp());
            return;
        }
        DomainFactory.PubSubImplementation pubSubImplementation = DomainFactory.PubSubImplementation.FAST_RTPS;
        new FiducialDetectorToolboxModule(robotModel.getSimpleRobotName(), robotModel.getTarget(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), pubSubImplementation);
        new ObjectDetectorToolboxModule(robotModel.getSimpleRobotName(), robotModel.createFullRobotModel(), robotModel.getLogModelProvider(), pubSubImplementation);
    }
}

