/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import java.net.URI;
import perception_msgs.msg.dds.LidarScanMessage;
import sensor_msgs.PointCloud2;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.behaviors.tools.CommunicationHelper;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.ihmcPerception.depthData.PointCloudData;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;
import us.ihmc.tools.thread.Throttler;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosTools;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class AtlasZED2ROS1ToREABridge {
    private static final double REA_OUTPUT_FREQUENCY = UnitConversions.hertzToSeconds((double)10.0);

    public AtlasZED2ROS1ToREABridge() {
        RosMainNode ros1Node = RosTools.createRosNode((URI)NetworkParameters.getROSURI(), (String)"zed2_to_rea");
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"zed2_to_rea");
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT);
        final CommunicationHelper ros2Helper = new CommunicationHelper((DRCRobotModel)robotModel, (ROS2NodeInterface)ros2Node);
        final ROS2SyncedRobotModel syncedRobot = ros2Helper.newSyncedRobot();
        final RigidBodyTransform transformToWorld = new RigidBodyTransform();
        final Throttler throttler = new Throttler();
        final ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"ZED2ToREABridge", (boolean)true);
        AbstractRosTopicSubscriber<PointCloud2> ousterSubscriber = new AbstractRosTopicSubscriber<PointCloud2>("sensor_msgs/PointCloud2"){

            public void onNewMessage(PointCloud2 pointCloud2) {
                if (throttler.run(REA_OUTPUT_FREQUENCY)) {
                    executor.submit(() -> {
                        syncedRobot.update();
                        PointCloudData pointCloudData = new PointCloudData(pointCloud2, 1600000, false);
                        FramePose3DReadOnly ousterPose = syncedRobot.getFramePoseReadOnly(HumanoidReferenceFrames::getOusterLidarFrame);
                        ousterPose.get((RigidBodyTransformBasics)transformToWorld);
                        pointCloudData.applyTransform(transformToWorld);
                        LidarScanMessage lidarScanMessage = pointCloudData.toLidarScanMessage();
                        lidarScanMessage.getLidarPosition().set((Tuple3DReadOnly)ousterPose.getPosition());
                        lidarScanMessage.getLidarOrientation().set((QuaternionReadOnly)ousterPose.getOrientation());
                        lidarScanMessage.setSensorPoseConfidence(1.0);
                        ros2Helper.publish(ROS2Tools.MULTISENSE_LIDAR_SCAN, (Object)lidarScanMessage);
                    });
                }
            }
        };
        ros1Node.attachSubscriber("/zed/zed_node/left/image_rect_color/compressed", (RosTopicSubscriberInterface)ousterSubscriber);
        ros1Node.execute();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            executor.destroy();
            ros1Node.shutdown();
        }, "IHMC-OusterROS1ToREABridgeShutdown"));
    }

    public static void main(String[] args) {
        new AtlasZED2ROS1ToREABridge();
    }
}

