/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import boofcv.struct.calib.CameraPinholeBrown;
import java.awt.color.ColorSpace;
import java.awt.image.ComponentColorModel;
import java.net.URI;
import java.nio.ByteBuffer;
import org.bytedeco.javacpp.BytePointer;
import org.bytedeco.javacpp.IntPointer;
import org.bytedeco.opencv.global.opencv_core;
import org.bytedeco.opencv.global.opencv_imgcodecs;
import org.bytedeco.opencv.global.opencv_imgproc;
import org.bytedeco.opencv.opencv_core.Mat;
import org.jboss.netty.buffer.ChannelBuffer;
import perception_msgs.msg.dds.VideoPacket;
import sensor_msgs.Image;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.behaviors.tools.CommunicationHelper;
import us.ihmc.codecs.yuv.JPEGEncoder;
import us.ihmc.codecs.yuv.YUVPictureConverter;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.euclid.referenceFrame.interfaces.FramePose3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.frames.HumanoidReferenceFrames;
import us.ihmc.log.LogTools;
import us.ihmc.perception.ImageEncodingTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.tools.UnitConversions;
import us.ihmc.tools.thread.MissingThreadTools;
import us.ihmc.tools.thread.ResettableExceptionHandlingExecutorService;
import us.ihmc.tools.thread.Throttler;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosTools;
import us.ihmc.utilities.ros.subscriber.AbstractRosTopicSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class AtlasZED2LeftEyeToMultiSenseLeftEyeBridge {
    private static final double OUTPUT_FREQUENCY = UnitConversions.hertzToSeconds((double)10.0);

    public AtlasZED2LeftEyeToMultiSenseLeftEyeBridge() {
        RosMainNode ros1Node = RosTools.createRosNode((URI)NetworkParameters.getROSURI(), (String)"zed2_to_left_eye");
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"zed2_to_left_eye");
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT);
        final CommunicationHelper ros2Helper = new CommunicationHelper((DRCRobotModel)robotModel, (ROS2NodeInterface)ros2Node);
        final ROS2SyncedRobotModel syncedRobot = ros2Helper.newSyncedRobot();
        final RigidBodyTransform transformToWorld = new RigidBodyTransform();
        final Throttler throttler = new Throttler();
        YUVPictureConverter converter = new YUVPictureConverter();
        JPEGEncoder encoder = new JPEGEncoder();
        int imageWidth = 640;
        int imageHeight = 360;
        double fx = 500.0;
        double fy = 500.0;
        final CameraPinholeBrown depthCameraIntrinsics = new CameraPinholeBrown(fx, fy, 0.0, (double)imageWidth / 2.0, (double)imageHeight / 2.0, imageWidth, imageHeight);
        final ResettableExceptionHandlingExecutorService executor = MissingThreadTools.newSingleThreadExecutor((String)"ZED2LeftEyeToLeftEyeBridge", (boolean)true);
        ColorSpace colorSpace = ColorSpace.getInstance(1000);
        ComponentColorModel colorModel = new ComponentColorModel(colorSpace, false, false, 1, 0);
        String bgr8Name = "bgr8";
        int bgr8 = ImageEncodingTools.getCvType((String)bgr8Name);
        final Mat inputImageMat = new Mat(720, 1280, opencv_core.CV_8UC3);
        final Mat decodedImageMat = new Mat(720, 1280, opencv_core.CV_8UC3);
        Mat compressedImageMat = new Mat(720, 1280, opencv_core.CV_8UC3);
        final IntPointer compressionParameters = new IntPointer(new int[]{1, 75});
        final BytePointer outputBuffer = new BytePointer();
        AbstractRosTopicSubscriber<Image> subscriber = new AbstractRosTopicSubscriber<Image>("sensor_msgs/Image"){

            public void onNewMessage(Image ros1Image) {
                if (throttler.run(OUTPUT_FREQUENCY)) {
                    executor.submit(() -> {
                        syncedRobot.update();
                        try {
                            ChannelBuffer nettyImageData = ros1Image.getData();
                            ByteBuffer dataByteBuffer = nettyImageData.toByteBuffer();
                            int arrayOffset = nettyImageData.arrayOffset();
                            dataByteBuffer.position(arrayOffset);
                            ByteBuffer offsetByteBuffer = dataByteBuffer.slice();
                            BytePointer imageDataPointer = new BytePointer(offsetByteBuffer);
                            inputImageMat.data(imageDataPointer);
                            opencv_imgproc.cvtColor((Mat)inputImageMat, (Mat)decodedImageMat, (int)128);
                            opencv_imgcodecs.imencode((String)".jpg", (Mat)decodedImageMat, (BytePointer)outputBuffer, (IntPointer)compressionParameters);
                            byte[] data = new byte[outputBuffer.asBuffer().remaining()];
                            outputBuffer.asBuffer().get(data);
                            FramePose3DReadOnly ousterPose = syncedRobot.getFramePoseReadOnly(HumanoidReferenceFrames::getOusterLidarFrame);
                            ousterPose.get((RigidBodyTransformBasics)transformToWorld);
                            VideoPacket message = new VideoPacket();
                            message.setTimestamp(System.nanoTime());
                            message.getData().add(data);
                            message.getPosition().set((Tuple3DReadOnly)ousterPose.getPosition());
                            message.getOrientation().set((QuaternionReadOnly)ousterPose.getOrientation());
                            message.setVideoSource((byte)0);
                            message.getIntrinsicParameters().set(HumanoidMessageTools.toIntrinsicParametersMessage((CameraPinholeBrown)depthCameraIntrinsics));
                            ros2Helper.publish(ROS2Tools.VIDEO, (Object)message);
                        }
                        catch (Exception e) {
                            LogTools.error((String)e.getMessage());
                            e.printStackTrace();
                        }
                    });
                }
            }
        };
        ros1Node.attachSubscriber("/zed/color/left/image_raw", (RosTopicSubscriberInterface)subscriber);
        ros1Node.execute();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            executor.destroy();
            ros1Node.shutdown();
        }, "IHMC-ZED2LeftEyeROS1ToLeftEyeBridgeShutdown"));
    }

    public static void main(String[] args) {
        new AtlasZED2LeftEyeToMultiSenseLeftEyeBridge();
    }
}

