/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import java.net.URI;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.parameters.AtlasSensorInformation;
import us.ihmc.atlas.ros.AtlasPPSTimestampOffsetProvider;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher.StereoVisionPointCloudPublisher;
import us.ihmc.avatar.ros.DRCROSPPSTimestampOffsetProvider;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.ros.RobotROSClockCalculatorFromPPSOffset;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullRobotModelFactory;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.sensorProcessing.parameters.AvatarRobotPointCloudParameters;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosTools;

public class AtlasStereoVisionPointCloudPublisher {
    private final StereoVisionPointCloudPublisher multisenseStereoVisionPointCloudPublisher;

    public AtlasStereoVisionPointCloudPublisher() {
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.REAL_ROBOT);
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"stereo_bridge");
        RosMainNode ros1Node = RosTools.createRosNode((URI)NetworkParameters.getROSURI(), (String)"stereo_bridge");
        AtlasSensorInformation sensorInformation = robotModel.getSensorInformation();
        DRCROSPPSTimestampOffsetProvider timestampOffsetProvider = AtlasPPSTimestampOffsetProvider.getInstance(sensorInformation);
        RobotROSClockCalculatorFromPPSOffset rosClockCalculator = new RobotROSClockCalculatorFromPPSOffset(timestampOffsetProvider);
        this.multisenseStereoVisionPointCloudPublisher = new StereoVisionPointCloudPublisher((FullRobotModelFactory)robotModel, (ROS2NodeInterface)ros2Node, ROS2Tools.MULTISENSE_STEREO_POINT_CLOUD);
        this.multisenseStereoVisionPointCloudPublisher.setROSClockCalculator((RobotROSClockCalculator)rosClockCalculator);
        AvatarRobotPointCloudParameters multisenseStereoParameters = sensorInformation.getPointCloudParameters(0);
        this.multisenseStereoVisionPointCloudPublisher.receiveStereoPointCloudFromROS1(multisenseStereoParameters.getRosTopic(), ros1Node);
        this.multisenseStereoVisionPointCloudPublisher.setRangeFilter(0.2, 2.5);
        this.multisenseStereoVisionPointCloudPublisher.setPublisherPeriodInMillisecond(1500L);
        this.multisenseStereoVisionPointCloudPublisher.setMaximumNumberOfPoints(200000);
        ros1Node.execute();
        this.multisenseStereoVisionPointCloudPublisher.start();
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogTools.info((String)"Shutting down network processor modules.");
            this.multisenseStereoVisionPointCloudPublisher.shutdown();
            ThreadTools.sleep((long)10L);
        }, this.getClass().getSimpleName() + "Shutdown"));
    }

    public static void main(String[] args) {
        new AtlasStereoVisionPointCloudPublisher();
    }
}

