/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.net.URI;
import us.ihmc.atlas.sensors.AtlasPointCloudSensorManager;
import us.ihmc.avatar.drcRobot.RobotPhysicalProperties;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.lidarScanPublisher.LidarScanPublisher;
import us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher.StereoVisionPointCloudPublisher;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.avatar.sensors.DRCSensorSuiteManager;
import us.ihmc.avatar.sensors.multisense.MultiSenseSensorManager;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.communication.net.ObjectCommunicator;
import us.ihmc.ihmcPerception.camera.FisheyeCameraReceiver;
import us.ihmc.ihmcPerception.camera.SCSCameraDataReceiver;
import us.ihmc.ihmcPerception.depthData.CollisionBoxProvider;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModelFactory;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.sensorProcessing.communication.producers.RobotConfigurationDataBuffer;
import us.ihmc.sensorProcessing.parameters.AvatarRobotCameraParameters;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.parameters.AvatarRobotPointCloudParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.RosNodeInterface;

public class AtlasSensorSuiteManager
implements DRCSensorSuiteManager {
    private static final boolean USE_DEPTH_FRAME_ESTIMATED_BY_TRACKING = false;
    public static final String NODE_NAME = "ihmc_atlas_sensor_suite_node";
    private final ROS2NodeInterface ros2Node;
    private final String robotName;
    private final FullHumanoidRobotModelFactory modelFactory;
    private final CollisionBoxProvider collisionBoxProvider;
    private final RobotROSClockCalculator rosClockCalculator;
    private final HumanoidRobotSensorInformation sensorInformation;
    private final RobotConfigurationDataBuffer robotConfigurationDataBuffer;
    private SCSCameraDataReceiver cameraDataReceiver;
    private MultiSenseSensorManager multiSenseSensorManager;
    private LidarScanPublisher lidarScanPublisher;
    private StereoVisionPointCloudPublisher multisenseStereoVisionPointCloudPublisher;
    private AtlasPointCloudSensorManager pointCloudSensorManager;
    private FisheyeCameraReceiver leftFishEyeCameraReceiver;
    private FisheyeCameraReceiver rightFishEyeCameraReceiver;
    private RosMainNode rosMainNode;
    private boolean enableVideoPublisher = true;
    private boolean enableLidarScanPublisher = true;
    private boolean enableStereoVisionPointCloudPublisher = false;
    private boolean enableDepthPointCloudPublisher = false;
    private boolean enableFisheyeCameraPublishers = false;

    public AtlasSensorSuiteManager(String robotName, FullHumanoidRobotModelFactory modelFactory, CollisionBoxProvider collisionBoxProvider, RobotROSClockCalculator rosClockCalculator, HumanoidRobotSensorInformation sensorInformation, HumanoidJointNameMap jointMap, RobotPhysicalProperties physicalProperties, RobotTarget targetDeployment, ROS2NodeInterface ros2Node) {
        this.robotName = robotName;
        this.collisionBoxProvider = collisionBoxProvider;
        this.rosClockCalculator = rosClockCalculator;
        this.sensorInformation = sensorInformation;
        this.robotConfigurationDataBuffer = new RobotConfigurationDataBuffer();
        this.modelFactory = modelFactory;
        this.ros2Node = ros2Node == null ? ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)NODE_NAME) : ros2Node;
    }

    public void setEnableVideoPublisher(boolean enableVideoPublisher) {
        this.enableVideoPublisher = enableVideoPublisher;
    }

    public void setEnableLidarScanPublisher(boolean enableLidarScanPublisher) {
        this.enableLidarScanPublisher = enableLidarScanPublisher;
    }

    public void setEnableStereoVisionPointCloudPublisher(boolean enableStereoVisionPointCloudPublisher) {
        this.enableStereoVisionPointCloudPublisher = enableStereoVisionPointCloudPublisher;
    }

    public void setEnableDepthPointCloudPublisher(boolean enableDepthPointCloudPublisher) {
        this.enableDepthPointCloudPublisher = enableDepthPointCloudPublisher;
    }

    public void setEnableFisheyeCameraPublishers(boolean enableFisheyeCameraPublishers) {
        this.enableFisheyeCameraPublishers = enableFisheyeCameraPublishers;
    }

    public void initializeSimulatedSensors(ObjectCommunicator scsSensorsCommunicator) {
        if (this.enableVideoPublisher) {
            ROS2Tools.createCallbackSubscription((ROS2NodeInterface)this.ros2Node, (ROS2Topic)ROS2Tools.getRobotConfigurationDataTopic((String)this.robotName), s -> this.robotConfigurationDataBuffer.receivedPacket((RobotConfigurationData)s.takeNextData()));
            this.cameraDataReceiver = new SCSCameraDataReceiver(this.sensorInformation.getCameraParameters(0).getRobotSide(), (FullRobotModelFactory)this.modelFactory, this.sensorInformation.getCameraParameters(0).getSensorNameInSdf(), this.robotConfigurationDataBuffer, scsSensorsCommunicator, this.ros2Node, arg_0 -> ((RobotROSClockCalculator)this.rosClockCalculator).computeRobotMonotonicTime(arg_0));
        }
        if (this.enableLidarScanPublisher) {
            this.lidarScanPublisher = this.createLidarScanPublisher();
            this.lidarScanPublisher.receiveLidarFromSCS(scsSensorsCommunicator);
            this.lidarScanPublisher.setScanFrameToLidarSensorFrame();
        }
    }

    public void initializePhysicalSensors(URI rosCoreURI) {
        if (rosCoreURI == null) {
            throw new RuntimeException(this.getClass().getSimpleName() + " Physical sensor requires rosURI to be set in " + NetworkParameters.defaultParameterFile);
        }
        this.rosMainNode = new RosMainNode(rosCoreURI, "atlas/sensorSuiteManager", true);
        if (this.enableVideoPublisher) {
            ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, RobotConfigurationData.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)this.robotName), s -> this.robotConfigurationDataBuffer.receivedPacket((RobotConfigurationData)s.takeNextData()));
            AvatarRobotCameraParameters multisenseLeftEyeCameraParameters = this.sensorInformation.getCameraParameters(0);
            AvatarRobotLidarParameters multisenseLidarParameters = this.sensorInformation.getLidarParameters(0);
            AvatarRobotPointCloudParameters multisenseStereoParameters = this.sensorInformation.getPointCloudParameters(0);
            this.multiSenseSensorManager = new MultiSenseSensorManager((FullRobotModelFactory)this.modelFactory, this.robotConfigurationDataBuffer, this.rosMainNode, this.ros2Node, this.rosClockCalculator, multisenseLeftEyeCameraParameters, multisenseLidarParameters, multisenseStereoParameters, this.sensorInformation.setupROSParameterSetters());
        }
        if (this.enableLidarScanPublisher) {
            AvatarRobotLidarParameters multisenseLidarParameters = this.sensorInformation.getLidarParameters(0);
            this.lidarScanPublisher = this.createLidarScanPublisher();
            this.lidarScanPublisher.receiveLidarFromROSAsPointCloud2WithSource(multisenseLidarParameters.getRosTopic(), this.rosMainNode);
            this.lidarScanPublisher.setScanFrameToWorldFrame();
        }
        if (this.enableStereoVisionPointCloudPublisher) {
            this.multisenseStereoVisionPointCloudPublisher = new StereoVisionPointCloudPublisher((FullRobotModelFactory)this.modelFactory, this.ros2Node, ROS2Tools.MULTISENSE_STEREO_POINT_CLOUD);
            this.multisenseStereoVisionPointCloudPublisher.setROSClockCalculator(this.rosClockCalculator);
            AvatarRobotPointCloudParameters multisenseStereoParameters = this.sensorInformation.getPointCloudParameters(0);
            this.multisenseStereoVisionPointCloudPublisher.receiveStereoPointCloudFromROS1(multisenseStereoParameters.getRosTopic(), this.rosMainNode);
        }
        LogTools.info((String)"Enable depth point cloud publisher: {}", (Object)this.enableDepthPointCloudPublisher);
        if (this.enableDepthPointCloudPublisher) {
            this.pointCloudSensorManager = new AtlasPointCloudSensorManager(this.modelFactory, this.ros2Node, this.rosClockCalculator, false);
            this.pointCloudSensorManager.setCollisionBoxProvider(this.collisionBoxProvider);
            this.pointCloudSensorManager.receiveDataFromROS1(this.rosMainNode);
        }
        if (this.enableFisheyeCameraPublishers) {
            AvatarRobotCameraParameters leftFishEyeCameraParameters = this.sensorInformation.getCameraParameters(2);
            AvatarRobotCameraParameters rightFishEyeCameraParameters = this.sensorInformation.getCameraParameters(3);
            this.leftFishEyeCameraReceiver = new FisheyeCameraReceiver(this.modelFactory, leftFishEyeCameraParameters, this.robotConfigurationDataBuffer, this.ros2Node, arg_0 -> ((RobotROSClockCalculator)this.rosClockCalculator).computeRobotMonotonicTime(arg_0), this.rosMainNode);
            this.rightFishEyeCameraReceiver = new FisheyeCameraReceiver(this.modelFactory, rightFishEyeCameraParameters, this.robotConfigurationDataBuffer, this.ros2Node, arg_0 -> ((RobotROSClockCalculator)this.rosClockCalculator).computeRobotMonotonicTime(arg_0), this.rosMainNode);
        }
        this.rosClockCalculator.subscribeToROS1Topics((RosNodeInterface)this.rosMainNode);
    }

    public void connect() {
        if (this.cameraDataReceiver != null) {
            this.cameraDataReceiver.start();
        }
        if (this.multiSenseSensorManager != null) {
            this.multiSenseSensorManager.initializeParameterListeners();
            this.multiSenseSensorManager.start();
        }
        if (this.lidarScanPublisher != null) {
            this.lidarScanPublisher.start();
        }
        if (this.multisenseStereoVisionPointCloudPublisher != null) {
            this.multisenseStereoVisionPointCloudPublisher.start();
        }
        if (this.pointCloudSensorManager != null) {
            this.pointCloudSensorManager.start();
        }
        if (this.leftFishEyeCameraReceiver != null) {
            this.leftFishEyeCameraReceiver.start();
        }
        if (this.rightFishEyeCameraReceiver != null) {
            this.rightFishEyeCameraReceiver.start();
        }
        if (this.rosMainNode != null) {
            this.rosMainNode.execute();
        }
    }

    public void closeAndDispose() {
        if (this.lidarScanPublisher != null) {
            this.lidarScanPublisher.shutdown();
        }
        if (this.multisenseStereoVisionPointCloudPublisher != null) {
            this.multisenseStereoVisionPointCloudPublisher.shutdown();
        }
        if (this.pointCloudSensorManager != null) {
            this.pointCloudSensorManager.shutdown();
        }
        if (this.cameraDataReceiver != null) {
            this.cameraDataReceiver.closeAndDispose();
        }
        if (this.multiSenseSensorManager != null) {
            this.multiSenseSensorManager.closeAndDispose();
        }
        if (this.rosMainNode != null) {
            this.rosMainNode.shutdown();
        }
        if (this.leftFishEyeCameraReceiver != null) {
            this.leftFishEyeCameraReceiver.closeAndDispose();
        }
        if (this.rightFishEyeCameraReceiver != null) {
            this.rightFishEyeCameraReceiver.closeAndDispose();
        }
        if (this.ros2Node.getName().equals(NODE_NAME)) {
            ((ROS2Node)this.ros2Node).destroy();
        }
    }

    private LidarScanPublisher createLidarScanPublisher() {
        AvatarRobotLidarParameters multisenseLidarParameters = this.sensorInformation.getLidarParameters(0);
        String sensorName = multisenseLidarParameters.getSensorNameInSdf();
        LidarScanPublisher lidarScanPublisher = new LidarScanPublisher(sensorName, (FullRobotModelFactory)this.modelFactory, this.ros2Node);
        lidarScanPublisher.setROSClockCalculator(this.rosClockCalculator);
        lidarScanPublisher.setShadowFilter();
        lidarScanPublisher.setSelfCollisionFilter(this.collisionBoxProvider);
        return lidarScanPublisher;
    }

    public LidarScanPublisher getLidarScanPublisher() {
        return this.lidarScanPublisher;
    }

    public StereoVisionPointCloudPublisher getMultisenseStereoVisionPointCloudPublisher() {
        return this.multisenseStereoVisionPointCloudPublisher;
    }

    public MultiSenseSensorManager getMultiSenseSensorManager() {
        return this.multiSenseSensorManager;
    }
}

