/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import controller_msgs.msg.dds.FootstepDataMessage;
import controller_msgs.msg.dds.FootstepStatusMessage;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.StereoVisionPointCloudMessage;
import ihmc_common_msgs.msg.dds.StampedPosePacket;
import java.io.File;
import java.text.DecimalFormat;
import java.util.LinkedList;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import us.ihmc.atlas.parameters.AtlasSensorInformation;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.walking.FootstepStatus;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.pubsub.subscriber.Subscriber;
import us.ihmc.robotEnvironmentAwareness.communication.SLAMModuleAPI;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMFrame;
import us.ihmc.robotEnvironmentAwareness.slam.SLAMModule;
import us.ihmc.robotEnvironmentAwareness.slam.SurfaceElementICPSLAMParameters;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class AtlasSLAMModule
extends SLAMModule {
    private static final double PELVIS_VELOCITY_STATIONARY_THRESHOLD = 0.001;
    private static final double TOLERANCE_PELVIS_VELOCITY = 0.01;
    private final LinkedList<Boolean> stationaryFlagQueue = new LinkedList();
    private final LinkedList<Boolean> reasonableVelocityFlagQueue = new LinkedList();
    private final AtomicBoolean robotStatus = new AtomicBoolean(false);
    private final AtomicBoolean velocityStatus = new AtomicBoolean(true);
    protected final AtomicLong latestRobotTimeStamp = new AtomicLong();
    protected IHMCROS2Publisher<StampedPosePacket> estimatedPelvisPublisher = null;
    protected RigidBodyTransform sensorPoseToPelvisTransformer = null;
    private final DecimalFormat df = new DecimalFormat("#.####");

    public AtlasSLAMModule(ROS2Node ros2Node, Messager messager, DRCRobotModel drcRobotModel, File configurationFile) {
        super(ros2Node, messager, (RigidBodyTransformReadOnly)AtlasSensorInformation.transformPelvisToD435DepthCamera, configurationFile);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, RobotConfigurationData.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)drcRobotModel.getSimpleRobotName()), this::handleRobotConfigurationData);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)ros2Node, FootstepStatusMessage.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)drcRobotModel.getSimpleRobotName()), this::handleFootstepStatusMessage);
        this.estimatedPelvisPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)ros2Node, StampedPosePacket.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)drcRobotModel.getSimpleRobotName()));
        this.sensorPoseToPelvisTransformer = new RigidBodyTransform((RigidBodyTransformReadOnly)AtlasSensorInformation.transformPelvisToD435DepthCamera);
        this.sensorPoseToPelvisTransformer.invert();
        this.reaMessager.registerTopicListener(SLAMModuleAPI.SensorStatus, this.robotStatus::set);
        this.reaMessager.registerTopicListener(SLAMModuleAPI.VelocityLimitStatus, this.velocityStatus::set);
    }

    public AtlasSLAMModule(Messager messager, DRCRobotModel drcRobotModel) {
        super(messager);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, RobotConfigurationData.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)drcRobotModel.getSimpleRobotName()), this::handleRobotConfigurationData);
        ROS2Tools.createCallbackSubscriptionTypeNamed((ROS2NodeInterface)this.ros2Node, FootstepStatusMessage.class, (ROS2Topic)ROS2Tools.getControllerOutputTopic((String)drcRobotModel.getSimpleRobotName()), this::handleFootstepStatusMessage);
        this.estimatedPelvisPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)this.ros2Node, StampedPosePacket.class, (ROS2Topic)ROS2Tools.getControllerInputTopic((String)drcRobotModel.getSimpleRobotName()));
        this.sensorPoseToPelvisTransformer = new RigidBodyTransform((RigidBodyTransformReadOnly)AtlasSensorInformation.transformPelvisToD435DepthCamera);
        this.sensorPoseToPelvisTransformer.invert();
        this.reaMessager.registerTopicListener(SLAMModuleAPI.SensorStatus, this.robotStatus::set);
        this.reaMessager.registerTopicListener(SLAMModuleAPI.VelocityLimitStatus, this.velocityStatus::set);
    }

    public void sendCurrentState() {
        super.sendCurrentState();
        if (this.robotStatus != null) {
            this.reaMessager.submitMessage(SLAMModuleAPI.SensorStatus, (Object)this.robotStatus.get());
        }
        if (this.velocityStatus != null) {
            this.reaMessager.submitMessage(SLAMModuleAPI.VelocityLimitStatus, (Object)this.velocityStatus.get());
        }
    }

    protected boolean addFrame(StereoVisionPointCloudMessage pointCloudToCompute) {
        boolean stationaryFlag = this.stationaryFlagQueue.getFirst();
        boolean reasonableVelocityFlag = this.reasonableVelocityFlagQueue.getFirst();
        if (reasonableVelocityFlag) {
            if (stationaryFlag) {
                this.slam.addKeyFrame(pointCloudToCompute, ((SurfaceElementICPSLAMParameters)this.slamParameters.get()).getInsertMissInOcTree());
                return true;
            }
            return this.slam.addFrame(pointCloudToCompute, ((SurfaceElementICPSLAMParameters)this.slamParameters.get()).getInsertMissInOcTree());
        }
        return false;
    }

    public void queue(StereoVisionPointCloudMessage pointCloud) {
        super.queue(pointCloud);
        this.stationaryFlagQueue.add(this.robotStatus.get());
        this.reasonableVelocityFlagQueue.add(this.velocityStatus.get());
    }

    protected void dequeue() {
        super.dequeue();
        if (!this.stationaryFlagQueue.isEmpty()) {
            this.stationaryFlagQueue.removeFirst();
        }
        if (!this.reasonableVelocityFlagQueue.isEmpty()) {
            this.reasonableVelocityFlagQueue.removeFirst();
        }
    }

    protected void publishResults() {
        super.publishResults();
        if (this.estimatedPelvisPublisher != null) {
            SLAMFrame latestFrame = this.slam.getLatestFrame();
            if (latestFrame == null) {
                return;
            }
            StampedPosePacket posePacket = new StampedPosePacket();
            posePacket.setTimestamp(this.latestRobotTimeStamp.get());
            int maximumBufferOfQueue = 10;
            if (this.pointCloudQueue.size() >= maximumBufferOfQueue) {
                posePacket.setConfidenceFactor(0.0);
            } else {
                if (latestFrame.getConfidenceFactor() < 0.0) {
                    posePacket.setConfidenceFactor(0.0);
                }
                posePacket.setConfidenceFactor(latestFrame.getConfidenceFactor());
            }
            posePacket.setConfidenceFactor(0.5);
            RigidBodyTransform estimatedPelvisPose = new RigidBodyTransform((RigidBodyTransformReadOnly)this.sensorPoseToPelvisTransformer);
            estimatedPelvisPose.preMultiply(latestFrame.getCorrectedSensorPoseInWorld());
            posePacket.getPose().set((RigidBodyTransformReadOnly)estimatedPelvisPose);
            this.reaMessager.submitMessage(SLAMModuleAPI.CustomizedFrameState, (Object)posePacket);
            LogTools.debug((String)("latestFrame.getConfidenceFactor: " + latestFrame.getConfidenceFactor() + " posePacket.getConfidenceFactor: " + posePacket.getConfidenceFactor()));
            LogTools.debug((String)("publishing pose to state estimator: " + posePacket.getPose()));
            this.estimatedPelvisPublisher.publish((Object)posePacket);
        }
    }

    public void clearSLAM() {
        super.clearSLAM();
        this.stationaryFlagQueue.clear();
        this.reasonableVelocityFlagQueue.clear();
    }

    private void handleRobotConfigurationData(Subscriber<RobotConfigurationData> subscriber) {
        RobotConfigurationData robotConfigurationData = (RobotConfigurationData)subscriber.takeNextData();
        this.latestRobotTimeStamp.set(robotConfigurationData.getWallTime());
        if (this.reaMessager.isMessagerOpen()) {
            double pelvisVelocity = robotConfigurationData.getPelvisLinearVelocity().lengthSquared();
            this.reaMessager.submitMessage(SLAMModuleAPI.SensorStatus, (Object)(pelvisVelocity < ((SurfaceElementICPSLAMParameters)this.slamParameters.get()).getStationaryVelocity() ? 1 : 0));
            this.reaMessager.submitMessage(SLAMModuleAPI.VelocityLimitStatus, (Object)(pelvisVelocity < ((SurfaceElementICPSLAMParameters)this.slamParameters.get()).getMaxVelocity() ? 1 : 0));
            this.reaMessager.submitMessage(SLAMModuleAPI.SensorSpeed, (Object)this.df.format(Math.sqrt(pelvisVelocity)));
        }
    }

    private void handleFootstepStatusMessage(Subscriber<FootstepStatusMessage> subscriber) {
        FootstepStatusMessage footstepStatusMessage = (FootstepStatusMessage)subscriber.takeNextData();
        if (this.reaMessager.isMessagerOpen() && footstepStatusMessage.getFootstepStatus() == FootstepStatus.COMPLETED.toByte()) {
            this.reaMessager.submitMessage(SLAMModuleAPI.ShowFootstepDataViz, (Object)true);
            RobotSide robotSide = RobotSide.fromByte((byte)footstepStatusMessage.getRobotSide());
            Point3D footLocation = footstepStatusMessage.getActualFootPositionInWorld();
            Quaternion footOrientation = footstepStatusMessage.getActualFootOrientationInWorld();
            FootstepDataMessage footstepDataMessageToSubmit = new FootstepDataMessage();
            footstepDataMessageToSubmit.setRobotSide(robotSide.toByte());
            footstepDataMessageToSubmit.getLocation().set((Tuple3DReadOnly)footLocation);
            footstepDataMessageToSubmit.getOrientation().set((QuaternionReadOnly)footOrientation);
            this.reaMessager.submitMessage(SLAMModuleAPI.FootstepDataState, (Object)footstepDataMessageToSubmit);
        }
    }

    public static AtlasSLAMModule createIntraprocessModule(DRCRobotModel drcRobotModel, Messager messager) {
        return new AtlasSLAMModule(messager, drcRobotModel);
    }

    public static AtlasSLAMModule createIntraprocessModule(ROS2Node ros2Node, DRCRobotModel drcRobotModel, Messager messager, File configurationFile) {
        return new AtlasSLAMModule(ros2Node, messager, drcRobotModel, configurationFile);
    }
}

