/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import ihmc_common_msgs.msg.dds.StampedPosePacket;
import us.ihmc.atlas.parameters.AtlasSensorInformation;
import us.ihmc.avatar.networkProcessor.stereoPointCloudPublisher.StereoVisionPointCloudPublisher;
import us.ihmc.avatar.networkProcessor.trackingCameraPublisher.TrackingCameraBridge;
import us.ihmc.avatar.ros.RobotROSClockCalculator;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.ihmcPerception.depthData.CollisionBoxProvider;
import us.ihmc.log.LogTools;
import us.ihmc.mecano.frames.MovingReferenceFrame;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotModels.FullRobotModel;
import us.ihmc.robotModels.FullRobotModelFactory;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.utilities.ros.RosMainNode;

public class AtlasPointCloudSensorManager {
    private final StereoVisionPointCloudPublisher realsenseDepthPointCloudPublisher;
    private final TrackingCameraBridge trackingCameraPublisher;
    private static final String depthTopicNameToSubscribe = "/depthcam/depth/color/points";
    private static final String trackingTopicNameToSubscribe = "/trackingcam/odom/sample";
    private final RigidBodyTransform latestTrackingSensorPose = new RigidBodyTransform();

    public AtlasPointCloudSensorManager(FullHumanoidRobotModelFactory modelFactory, ROS2NodeInterface ros2Node, RobotROSClockCalculator rosClockCalculator, boolean useTrackingData) {
        LogTools.info((String)"Creating sensor bridges...");
        this.realsenseDepthPointCloudPublisher = new StereoVisionPointCloudPublisher((FullRobotModelFactory)modelFactory, ros2Node, ROS2Tools.D435_POINT_CLOUD);
        LogTools.info((String)"Using ROS clock calculator {}", rosClockCalculator.getClass());
        this.realsenseDepthPointCloudPublisher.setROSClockCalculator(rosClockCalculator);
        this.trackingCameraPublisher = new TrackingCameraBridge((FullRobotModelFactory)modelFactory, ros2Node);
        this.trackingCameraPublisher.setROSClockCalculator(rosClockCalculator);
        this.trackingCameraPublisher.setCustomInitializationTransformer(this.createCustomTrackingCameraWorldTransformCalculator());
        if (useTrackingData) {
            this.realsenseDepthPointCloudPublisher.setCustomStereoVisionTransformer(this.createDepthPointCloudWorldTransformCalculatorFromTrackingData());
        } else {
            this.realsenseDepthPointCloudPublisher.setCustomStereoVisionTransformer(this.createDepthPointCloudWorldTransformCalculator());
        }
    }

    public void receiveDataFromROS1(RosMainNode rosMainNode) {
        this.realsenseDepthPointCloudPublisher.receiveStereoPointCloudFromROS1(depthTopicNameToSubscribe, rosMainNode);
        this.trackingCameraPublisher.receiveTrackingCameraDataFromROS1(trackingTopicNameToSubscribe, rosMainNode);
    }

    public void start() {
        this.realsenseDepthPointCloudPublisher.start();
        this.trackingCameraPublisher.start();
    }

    public void shutdown() {
        this.realsenseDepthPointCloudPublisher.shutdown();
        this.trackingCameraPublisher.shutdown();
    }

    public void setCollisionBoxProvider(CollisionBoxProvider collisionBoxProvider) {
        this.realsenseDepthPointCloudPublisher.setSelfCollisionFilter(collisionBoxProvider);
    }

    private StereoVisionPointCloudPublisher.StereoVisionWorldTransformCalculator createDepthPointCloudWorldTransformCalculator() {
        return new StereoVisionPointCloudPublisher.StereoVisionWorldTransformCalculator(){
            private final RigidBodyTransform transformFromPelvisToRealSense = AtlasSensorInformation.transformPelvisToD435DepthCamera;

            public void computeTransformToWorld(FullRobotModel fullRobotModel, RigidBodyTransform transformToWorldToPack, Pose3DBasics sensorPoseToPack) {
                MovingReferenceFrame pelvisFrame = fullRobotModel.getRootJoint().getFrameAfterJoint();
                pelvisFrame.getTransformToDesiredFrame(transformToWorldToPack, ReferenceFrame.getWorldFrame());
                transformToWorldToPack.multiply((RigidBodyTransformReadOnly)this.transformFromPelvisToRealSense);
                sensorPoseToPack.set((RigidBodyTransformReadOnly)transformToWorldToPack);
            }
        };
    }

    private StereoVisionPointCloudPublisher.StereoVisionWorldTransformCalculator createDepthPointCloudWorldTransformCalculatorFromTrackingData() {
        return new StereoVisionPointCloudPublisher.StereoVisionWorldTransformCalculator(){
            private final RigidBodyTransform transformFromPelvisToRealSense = AtlasSensorInformation.transformTrackingCameraToDepthCamera;

            public void computeTransformToWorld(FullRobotModel fullRobotModel, RigidBodyTransform transformToWorldToPack, Pose3DBasics sensorPoseToPack) {
                StampedPosePacket newTrackingSensorPose = AtlasPointCloudSensorManager.this.trackingCameraPublisher.pollNewData();
                if (newTrackingSensorPose != null) {
                    Pose3D sensorPose = newTrackingSensorPose.getPose();
                    AtlasPointCloudSensorManager.this.latestTrackingSensorPose.set((Orientation3DReadOnly)sensorPose.getOrientation(), (Tuple3DReadOnly)sensorPose.getPosition());
                }
                transformToWorldToPack.set(AtlasPointCloudSensorManager.this.latestTrackingSensorPose);
                transformToWorldToPack.multiply((RigidBodyTransformReadOnly)this.transformFromPelvisToRealSense);
                sensorPoseToPack.set((RigidBodyTransformReadOnly)transformToWorldToPack);
            }
        };
    }

    private TrackingCameraBridge.SensorFrameInitializationTransformer createCustomTrackingCameraWorldTransformCalculator() {
        return new TrackingCameraBridge.SensorFrameInitializationTransformer(){
            private final RigidBodyTransform transformFromPelvisToRealSense = AtlasSensorInformation.transformPelvisToTrackingCamera;

            public void computeTransformToWorld(FullRobotModel fullRobotModel, RigidBodyTransform transformToWorldToPack) {
                MovingReferenceFrame pelvisFrame = fullRobotModel.getRootJoint().getFrameAfterJoint();
                pelvisFrame.getTransformToDesiredFrame(transformToWorldToPack, ReferenceFrame.getWorldFrame());
                transformToWorldToPack.multiply((RigidBodyTransformReadOnly)this.transformFromPelvisToRealSense);
            }
        };
    }
}

