/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.function.Function;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.ihmcPerception.depthData.CollisionBoxProvider;
import us.ihmc.ihmcPerception.depthData.collisionShapes.CollisionBox;
import us.ihmc.ihmcPerception.depthData.collisionShapes.CollisionCylinder;
import us.ihmc.ihmcPerception.depthData.collisionShapes.CollisionShape;
import us.ihmc.ihmcPerception.depthData.collisionShapes.CollisionSphere;
import us.ihmc.log.LogTools;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.scs2.definition.collision.CollisionShapeDefinition;
import us.ihmc.scs2.definition.geometry.Box3DDefinition;
import us.ihmc.scs2.definition.geometry.Cylinder3DDefinition;
import us.ihmc.scs2.definition.geometry.GeometryDefinition;
import us.ihmc.scs2.definition.geometry.Sphere3DDefinition;
import us.ihmc.scs2.definition.robot.JointDefinition;
import us.ihmc.scs2.definition.robot.RigidBodyDefinition;
import us.ihmc.scs2.definition.robot.RobotDefinition;

public class AtlasCollisionBoxProvider
implements CollisionBoxProvider {
    private final Function<String, List<CollisionShape>> mappingFunction = s -> new ArrayList();
    private final HashMap<String, List<CollisionShape>> collisionMeshes = new HashMap();
    protected final float extent = 0.04f;

    public AtlasCollisionBoxProvider(RobotDefinition definitionWithCollisions, AtlasJointMap jointMap) {
        for (RigidBodyDefinition rigidBodyDefinition : definitionWithCollisions.getAllRigidBodies()) {
            JointDefinition parentJoint = rigidBodyDefinition.getParentJoint();
            String jointName = parentJoint == null ? "root" : parentJoint.getName();
            for (CollisionShapeDefinition collisionShapeDefinition : rigidBodyDefinition.getCollisionShapeDefinitions()) {
                RigidBodyTransform pose = new RigidBodyTransform((RigidBodyTransformReadOnly)collisionShapeDefinition.getOriginPose());
                GeometryDefinition geometryDefinition = collisionShapeDefinition.getGeometryDefinition();
                if (geometryDefinition instanceof Box3DDefinition) {
                    float bx = (float)(((Box3DDefinition)geometryDefinition).getSizeX() / 2.0) + 0.04f;
                    float by = (float)(((Box3DDefinition)geometryDefinition).getSizeY() / 2.0) + 0.04f;
                    float bz = (float)(((Box3DDefinition)geometryDefinition).getSizeZ() / 2.0) + 0.04f;
                    this.addCollisionShape(jointName, (CollisionShape)new CollisionBox(pose, (double)bx, (double)by, (double)bz));
                    continue;
                }
                if (geometryDefinition instanceof Cylinder3DDefinition) {
                    float length = (float)((Cylinder3DDefinition)geometryDefinition).getLength() + 0.08f;
                    float radius = (float)((Cylinder3DDefinition)geometryDefinition).getRadius() + 0.08f;
                    this.addCollisionShape(jointName, (CollisionShape)new CollisionCylinder(pose, (double)radius, (double)length));
                    continue;
                }
                if (geometryDefinition instanceof Sphere3DDefinition) {
                    float radius = (float)((Sphere3DDefinition)geometryDefinition).getRadius() * 2.0f * 0.04f;
                    this.addCollisionShape(jointName, (CollisionShape)new CollisionSphere(pose, (double)radius));
                    continue;
                }
                LogTools.debug((String)("Cannot create collision box for " + rigidBodyDefinition));
            }
        }
        for (RobotSide robotSide : RobotSide.values) {
            String joint = jointMap.getJointBeforeHandName(robotSide);
            RigidBodyTransform mittenPose = new RigidBodyTransform();
            mittenPose.getTranslation().set(0.0, robotSide.negateIfRightSide(0.27), -0.005);
            CollisionSphere hand = new CollisionSphere(mittenPose, 0.15999999910593032);
            this.addCollisionShape(joint, (CollisionShape)hand);
            String kneeJoint = jointMap.getLegJointName(robotSide, LegJointName.KNEE_PITCH);
            RigidBodyTransform kneePose = new RigidBodyTransform();
            kneePose.setRotationRollAndZeroTranslation(1.5707963267948966);
            kneePose.getTranslation().set(0.05, 0.0, 0.03);
            CollisionCylinder knee = new CollisionCylinder(kneePose, 0.11, 0.22999999821186065);
            this.addCollisionShape(kneeJoint, (CollisionShape)knee);
            String elbowJoint = jointMap.getArmJointName(robotSide, ArmJointName.ELBOW_PITCH);
            RigidBodyTransform elbowBoxTransform = new RigidBodyTransform();
            elbowBoxTransform.getTranslation().set(0.0, robotSide.negateIfLeftSide(0.1), -0.2);
            CollisionBox stupidHoseBox = new CollisionBox(elbowBoxTransform, 0.15, 0.3, 0.15);
            this.addCollisionShape(elbowJoint, (CollisionShape)stupidHoseBox);
        }
        String backRollJoint = jointMap.getSpineJointName(SpineJointName.SPINE_ROLL);
        RigidBodyTransform backPackTransform = new RigidBodyTransform();
        backPackTransform.getTranslation().set(-0.2, 0.0, 0.2);
        CollisionBox backPackHoseBox = new CollisionBox(backPackTransform, 0.2, 0.5, 0.3);
        this.addCollisionShape(backRollJoint, (CollisionShape)backPackHoseBox);
        RigidBodyTransform haloTransform = new RigidBodyTransform();
        haloTransform.getTranslation().set(0.0, 0.0, 1.0);
        CollisionCylinder halo = new CollisionCylinder(haloTransform, 0.35, 1.0);
        this.addCollisionShape(backRollJoint, (CollisionShape)halo);
    }

    public void addCollisionShape(String jointName, CollisionShape mesh) {
        this.collisionMeshes.computeIfAbsent(jointName, this.mappingFunction).add(mesh);
    }

    public List<CollisionShape> getCollisionMesh(String jointName) {
        return this.collisionMeshes.get(jointName);
    }
}

