/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.commonWalkingControlModules.configurations.SwingTrajectoryParameters;

public class AtlasSwingTrajectoryParameters
extends SwingTrajectoryParameters {
    private final RobotTarget target;
    private final double modelScale;
    private final boolean runningOnRealRobot;

    public AtlasSwingTrajectoryParameters(RobotTarget target, double modelScale) {
        this.target = target;
        this.modelScale = modelScale;
        this.runningOnRealRobot = target == RobotTarget.REAL_ROBOT;
    }

    public double getDesiredTouchdownHeightOffset() {
        return 0.0;
    }

    public double getDesiredTouchdownVelocity() {
        return this.modelScale * -0.3;
    }

    public double getDesiredTouchdownAcceleration() {
        switch (this.target) {
            case SCS: {
                return this.modelScale * -2.0;
            }
        }
        return this.modelScale * -1.0;
    }

    public double getSwingFootVelocityAdjustmentDamping() {
        return this.runningOnRealRobot ? 0.8 : 0.5;
    }

    public boolean addOrientationMidpointForObstacleClearance() {
        return false;
    }

    public boolean useSingularityAvoidanceInSupport() {
        return true;
    }
}

