/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;

public class AtlasSteppingParameters
implements SteppingParameters {
    protected final AtlasJointMap jointMap;

    public AtlasSteppingParameters(AtlasJointMap jointMap) {
        this.jointMap = jointMap;
    }

    public double getMinSwingHeightFromStanceFoot() {
        return 0.1 * this.jointMap.getModelScale();
    }

    public double getDefaultSwingHeightFromStanceFoot() {
        return this.getMinSwingHeightFromStanceFoot();
    }

    public double getMaxSwingHeightFromStanceFoot() {
        return 0.4 * this.jointMap.getModelScale();
    }

    public double getFootForwardOffset() {
        return this.jointMap.getPhysicalProperties().getFootForwardForControl();
    }

    public double getFootBackwardOffset() {
        return this.jointMap.getPhysicalProperties().getFootBackForControl();
    }

    public double getInPlaceWidth() {
        return 0.25 * this.jointMap.getModelScale();
    }

    public double getMaxStepLength() {
        return 0.6 * this.jointMap.getModelScale();
    }

    public double getMinStepWidth() {
        return 0.15 * this.jointMap.getModelScale();
    }

    public double getMaxStepWidth() {
        return 0.6 * this.jointMap.getModelScale();
    }

    public double getDefaultStepLength() {
        return 0.6 * this.jointMap.getModelScale();
    }

    public double getMaxStepUp() {
        return 0.25 * this.jointMap.getModelScale();
    }

    public double getMaxStepDown() {
        return 0.2 * this.jointMap.getModelScale();
    }

    public double getMaxAngleTurnOutwards() {
        return 0.6;
    }

    public double getMaxAngleTurnInwards() {
        return -0.1;
    }

    public double getTurningStepWidth() {
        return 0.25;
    }

    public double getFootWidth() {
        return this.jointMap.getPhysicalProperties().getFootWidthForControl();
    }

    public double getToeWidth() {
        return this.jointMap.getPhysicalProperties().getToeWidthForControl();
    }

    public double getFootLength() {
        return this.jointMap.getPhysicalProperties().getFootLengthForControl();
    }

    public double getActualFootWidth() {
        return this.jointMap.getPhysicalProperties().getActualFootWidth();
    }

    public double getActualFootLength() {
        return this.jointMap.getPhysicalProperties().getActualFootLength();
    }
}

