/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import java.util.ArrayList;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.sensorProcessing.frames.CommonHumanoidReferenceFrames;
import us.ihmc.sensorProcessing.parameters.AvatarRobotCameraParameters;
import us.ihmc.sensorProcessing.parameters.AvatarRobotLidarParameters;
import us.ihmc.sensorProcessing.parameters.AvatarRobotPointCloudParameters;
import us.ihmc.sensorProcessing.parameters.AvatarRobotSensorParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;

public class AtlasSensorInformation
implements HumanoidRobotSensorInformation {
    public static final long HEAD_MICROSTRAIN_SERIAL_NUMBER = 625476543L;
    private static final String multisense_namespace = "/multisense";
    private static final String realsense_namespace = "/realsense";
    private static final String depth_camera_namespace = "/depthcam";
    private static final String tracking_camera_namespace = "/trackingcam";
    private static final String baseTfName = "/multisense/head";
    private static final String multisenseHandoffFrame = "head";
    private final ArrayList<ImmutableTriple<String, String, RigidBodyTransform>> staticTranformsForRos = new ArrayList();
    private final String[] forceSensorNames;
    private final SideDependentList<String> feetForceSensorNames = new SideDependentList((Object)"l_leg_akx", (Object)"r_leg_akx");
    private final SideDependentList<String> handForceSensorNames;
    private static final String MULTISENSE_SL_PPS_TOPIC = "/multisense/stamped_pps";
    public static final boolean SEND_ROBOT_DATA_TO_ROS = false;
    private final AvatarRobotCameraParameters[] cameraParameters = new AvatarRobotCameraParameters[4];
    public static final int MULTISENSE_SL_LEFT_CAMERA_ID = 0;
    public static final int MULTISENSE_SL_RIGHT_CAMERA_ID = 1;
    public static final int BLACKFLY_LEFT_CAMERA_ID = 2;
    public static final int BLACKFLY_RIGHT_CAMERA_ID = 3;
    private static final String left_camera_name = "stereo_camera_left";
    private static final String left_camera_topic = "/multisense/left/image_rect_color/compressed";
    private static final String left_info_camera_topic = "/multisense/left/image_rect_color/camera_info";
    private static final String left_frame_name = "/multisense/left_camera_frame";
    private static final String right_camera_name = "stereo_camera_right";
    private static final String right_camera_topic = "/multisense/right/image_rect/compressed";
    private static final String right_info_camera_topic = "/multisense/right/camera_info";
    private static final String right_frame_name = "/multisense/right_camera_frame";
    private static final String fisheye_pose_source = "utorso";
    private static final String fisheye_left_camera_topic = "/left/camera/image_color/compressed";
    private static final String fisheye_left_camera_info = "/left/camera/camera_info";
    private static final String leftFisheyeCameraName = "l_situational_awareness_camera_sensor_l_situational_awareness_camera";
    private static final String fisheye_right_camera_topic = "/right/camera/image_color/compressed";
    private static final String right_fisheye_camera_name = "r_situational_awareness_camera_sensor_r_situational_awareness_camera";
    private static final String fisheye_right_camera_info = "/right/camera/camera_info";
    public static final String head_imu_acceleration_topic = "/multisense/imu/accelerometer";
    public static final String head_imu_data_topic = "/multisense/imu/imu_data";
    private static final double lidar_spindle_velocity = 2.183;
    private final AvatarRobotLidarParameters[] lidarParameters = new AvatarRobotLidarParameters[1];
    public static final int MULTISENSE_LIDAR_ID = 0;
    private static final String lidarPoseLink = "hokuyo_link";
    private static final String lidarJointName = "hokuyo_joint";
    private static final String lidarEndFrameInSdf = "/head_hokuyo_frame";
    private static final String lidarBaseFrame = "/multisense/head_root";
    private static final String lidarEndFrame = "/multisense/head_hokuyo_frame";
    private static final String lidarSensorName = "head_hokuyo_sensor";
    private static final String lidarJointTopic = "/multisense/joint_states";
    private static final String multisense_laser_topic_string = "/multisense/lidar_scan";
    private static final String multisense_laser_scan_topic_string = "/singleScanAsCloudWithSource";
    private static final String multisense_laser_topic__as_string = "/multisense/lidar_points2";
    private static final String multisense_filtered_laser_as_point_cloud_topic_string = "/multisense/filtered_cloud";
    private static final String multisense_ground_point_cloud_topic_string = "/multisense/highly_filtered_cloud";
    private static final String bodyIMUSensor = "imu_sensor_at_pelvis_frame";
    private static final String chestIMUSensor = "imu_sensor_chest";
    private static final String[] imuSensorsToUseInStateEstimator = new String[]{"imu_sensor_at_pelvis_frame"};
    private final AvatarRobotPointCloudParameters[] pointCloudParameters = new AvatarRobotPointCloudParameters[1];
    public static final int MULTISENSE_STEREO_ID = 0;
    private static final String stereoSensorName = "stereo_camera";
    private static final String stereoColorTopic = "/multisense/image_points2_color_world";
    private static final String stereoBaseFrame = "/multisense/head";
    private static final String stereoEndFrame = "/multisense/left_camera_frame";
    private final boolean isMultisenseHead;
    private final boolean setupROSLocationService;
    private final boolean setupROSParameterSetters;
    private final RobotTarget target;
    public static final double linearVelocityThreshold = 0.2;
    public static final double angularVelocityThreshold = 0.20943951023931953;
    public static final String depthCameraTopic = "/depthcam/depth/color/points";
    public static final String trackingCameraTopic = "/trackingcam/odom/sample";
    private static final double d435DepthOffsetX = 0.058611;
    private static final double d435DepthOffsetZ = 0.01;
    private static final double d435DepthPitchingAngle = 1.2217304763960306;
    private static final double d435DepthRollOffset = Math.toRadians(-0.5);
    private static final double d435DepthThickness = 0.0245;
    private static final double trackingOffsetX = 0.0358;
    private static final double trackingOffsetZ = 0.0994;
    private static final double trackingPitchingAngle = 0.0;
    private static final double trackingThickness = 0.0125;
    private static final double pelvisToMountD435Origin = 0.19;
    public static final RigidBodyTransform transformPelvisToD435DepthCamera = new RigidBodyTransform();
    public static final RigidBodyTransform transformDepthCameraToTrackingCamera;
    public static final RigidBodyTransform transformPelvisToTrackingCamera;
    public static final RigidBodyTransform transformTrackingCameraToDepthCamera;
    private static final RigidBodyTransform transformChestToL515DepthCamera;
    private static final RigidBodyTransform transformChestToD435DepthCamera;
    private static final RigidBodyTransform transformChestToOuster;
    private static final RigidBodyTransform transformChestToZED2;
    private static final RigidBodyTransform transformChestToRightBlackfly;

    public AtlasSensorInformation(AtlasRobotVersion atlasRobotVersion, RobotTarget target) {
        this.target = target;
        if (atlasRobotVersion != AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_FOREARMS) {
            this.forceSensorNames = new String[]{"l_leg_akx", "r_leg_akx", "l_arm_wry2", "r_arm_wry2"};
            this.handForceSensorNames = new SideDependentList((Object)"l_arm_wry2", (Object)"r_arm_wry2");
        } else {
            this.forceSensorNames = new String[]{"l_leg_akx", "r_leg_akx"};
            this.handForceSensorNames = null;
        }
        if (target == RobotTarget.REAL_ROBOT) {
            this.cameraParameters[0] = new AvatarRobotCameraParameters(RobotSide.LEFT, left_camera_name, left_camera_topic, left_info_camera_topic, multisenseHandoffFrame, "/multisense/head", "/multisense/left_camera_frame", 0);
            this.cameraParameters[1] = new AvatarRobotCameraParameters(RobotSide.RIGHT, right_camera_name, right_camera_topic, right_info_camera_topic, multisenseHandoffFrame, "/multisense/head", right_frame_name, 1);
            this.lidarParameters[0] = new AvatarRobotLidarParameters(true, lidarSensorName, multisense_laser_scan_topic_string, multisense_laser_scan_topic_string, lidarJointName, lidarJointTopic, multisenseHandoffFrame, lidarBaseFrame, lidarEndFrame, 2.183, 0);
            this.pointCloudParameters[0] = new AvatarRobotPointCloudParameters(stereoSensorName, stereoColorTopic, multisenseHandoffFrame, "/multisense/head", "/multisense/left_camera_frame", 0);
        } else if (target == RobotTarget.HEAD_ON_A_STICK) {
            this.cameraParameters[0] = new AvatarRobotCameraParameters(RobotSide.LEFT, left_camera_name, left_camera_topic, left_info_camera_topic, multisenseHandoffFrame, "/multisense/head", "/multisense/left_camera_frame", 0);
            this.cameraParameters[1] = new AvatarRobotCameraParameters(RobotSide.RIGHT, right_camera_name, right_camera_topic, right_info_camera_topic, multisenseHandoffFrame, "/multisense/head", right_frame_name, 1);
            this.lidarParameters[0] = new AvatarRobotLidarParameters(true, lidarSensorName, multisense_filtered_laser_as_point_cloud_topic_string, multisense_ground_point_cloud_topic_string, lidarJointName, lidarJointTopic, multisenseHandoffFrame, lidarBaseFrame, lidarEndFrame, 2.183, 0);
            this.pointCloudParameters[0] = new AvatarRobotPointCloudParameters(stereoSensorName, stereoColorTopic, multisenseHandoffFrame, "/multisense/head", "/multisense/left_camera_frame", 0);
        } else if (target == RobotTarget.GAZEBO) {
            String baseTfName = multisenseHandoffFrame;
            String left_frame_name = "left_camera_frame";
            String right_frame_name = "right_camera_frame";
            String lidarBaseFrame = multisenseHandoffFrame;
            String lidarEndFrame = "head_hokuyo_frame";
            this.cameraParameters[0] = new AvatarRobotCameraParameters(RobotSide.LEFT, left_camera_name, left_camera_topic, left_info_camera_topic, multisenseHandoffFrame, baseTfName, left_frame_name, 0);
            this.cameraParameters[1] = new AvatarRobotCameraParameters(RobotSide.RIGHT, right_camera_name, right_camera_topic, right_info_camera_topic, multisenseHandoffFrame, baseTfName, right_frame_name, 1);
            this.lidarParameters[0] = new AvatarRobotLidarParameters(true, lidarSensorName, multisense_laser_topic_string, multisense_laser_topic_string, lidarJointName, lidarJointTopic, multisenseHandoffFrame, lidarBaseFrame, lidarEndFrame, 2.183, 0);
            this.pointCloudParameters[0] = new AvatarRobotPointCloudParameters(stereoSensorName, stereoColorTopic, multisenseHandoffFrame, "/multisense/head", "/multisense/left_camera_frame", 0);
        } else {
            this.cameraParameters[0] = new AvatarRobotCameraParameters(RobotSide.LEFT, left_camera_name, left_camera_topic, multisenseHandoffFrame, left_info_camera_topic, 0);
            this.cameraParameters[1] = new AvatarRobotCameraParameters(RobotSide.RIGHT, right_camera_name, right_camera_topic, multisenseHandoffFrame, right_info_camera_topic, 1);
            this.lidarParameters[0] = new AvatarRobotLidarParameters(false, lidarSensorName, multisense_laser_topic_string, multisense_laser_topic_string, lidarJointName, lidarJointTopic, lidarPoseLink, multisenseHandoffFrame, lidarEndFrameInSdf, 2.183, 0);
            this.pointCloudParameters[0] = new AvatarRobotPointCloudParameters(stereoSensorName, stereoColorTopic, multisenseHandoffFrame, 0);
        }
        this.cameraParameters[2] = new AvatarRobotCameraParameters(RobotSide.LEFT, leftFisheyeCameraName, fisheye_left_camera_topic, fisheye_pose_source, fisheye_left_camera_info, 2);
        this.cameraParameters[3] = new AvatarRobotCameraParameters(RobotSide.RIGHT, right_fisheye_camera_name, fisheye_right_camera_topic, fisheye_pose_source, fisheye_right_camera_info, 3);
        this.setupROSLocationService = false;
        this.setupROSParameterSetters = false;
        this.isMultisenseHead = false;
        this.setupStaticTransformsForRos();
    }

    private void setupStaticTransformsForRos() {
        ImmutableTriple headToHeadRootStaticTransform = new ImmutableTriple((Object)multisenseHandoffFrame, (Object)"multisense/head_root", (Object)new RigidBodyTransform());
        this.staticTranformsForRos.add((ImmutableTriple<String, String, RigidBodyTransform>)headToHeadRootStaticTransform);
    }

    public AvatarRobotLidarParameters[] getLidarParameters() {
        return this.lidarParameters;
    }

    public AvatarRobotLidarParameters getLidarParameters(int sensorId) {
        return this.lidarParameters[sensorId];
    }

    public String[] getIMUSensorsToUseInStateEstimator() {
        return imuSensorsToUseInStateEstimator;
    }

    public String getPrimaryBodyImu() {
        return bodyIMUSensor;
    }

    public String getChestImu() {
        return chestIMUSensor;
    }

    public String[] getForceSensorNames() {
        return this.forceSensorNames;
    }

    public SideDependentList<String> getFeetForceSensorNames() {
        return this.feetForceSensorNames;
    }

    public SideDependentList<String> getWristForceSensorNames() {
        return this.handForceSensorNames;
    }

    public AvatarRobotCameraParameters[] getCameraParameters() {
        return this.cameraParameters;
    }

    public AvatarRobotCameraParameters getCameraParameters(int sensorId) {
        return this.cameraParameters[sensorId];
    }

    public String getCameraStringBase() {
        return multisense_namespace;
    }

    public String getPPSRosTopic() {
        return MULTISENSE_SL_PPS_TOPIC;
    }

    public AvatarRobotPointCloudParameters[] getPointCloudParameters() {
        return this.pointCloudParameters;
    }

    public AvatarRobotPointCloudParameters getPointCloudParameters(int sensorId) {
        return this.pointCloudParameters[sensorId];
    }

    private void sensorFramesToTrack(AvatarRobotSensorParameters[] sensorParams, ArrayList<String> holder) {
        for (int i = 0; i < sensorParams.length; ++i) {
            if (sensorParams[i].getPoseFrameForSdf() == null) continue;
            holder.add(sensorParams[i].getPoseFrameForSdf());
        }
    }

    public String[] getSensorFramesToTrack() {
        ArrayList<String> sensorFramesToTrack = new ArrayList<String>();
        this.sensorFramesToTrack((AvatarRobotSensorParameters[])this.cameraParameters, sensorFramesToTrack);
        this.sensorFramesToTrack((AvatarRobotSensorParameters[])this.lidarParameters, sensorFramesToTrack);
        this.sensorFramesToTrack((AvatarRobotSensorParameters[])this.pointCloudParameters, sensorFramesToTrack);
        String[] sensorFramesToTrackAsPrimitive = new String[sensorFramesToTrack.size()];
        sensorFramesToTrack.toArray(sensorFramesToTrackAsPrimitive);
        return sensorFramesToTrackAsPrimitive;
    }

    public boolean setupROSLocationService() {
        return this.setupROSLocationService;
    }

    public boolean setupROSParameterSetters() {
        return this.setupROSParameterSetters;
    }

    public boolean isMultisenseHead() {
        return this.isMultisenseHead;
    }

    public ArrayList<ImmutableTriple<String, String, RigidBodyTransform>> getStaticTransformsForRos() {
        return this.staticTranformsForRos;
    }

    public RigidBodyTransform getSteppingCameraTransform() {
        return transformChestToL515DepthCamera;
    }

    public ReferenceFrame getSteppingCameraParentFrame(CommonHumanoidReferenceFrames referenceFrames) {
        return referenceFrames.getChestFrame();
    }

    public RigidBodyTransform getObjectDetectionCameraTransform() {
        return transformChestToRightBlackfly;
    }

    public String getHeadCameraName() {
        return left_camera_name;
    }

    public RigidBodyTransform getExperimentalCameraTransform() {
        return transformChestToZED2;
    }

    public RigidBodyTransform getOusterLidarTransform() {
        return transformChestToOuster;
    }

    static {
        transformPelvisToD435DepthCamera.appendTranslation(0.19, 0.0, 0.0);
        transformPelvisToD435DepthCamera.appendTranslation(0.058611, 0.0, 0.01);
        transformPelvisToD435DepthCamera.appendRollRotation(d435DepthRollOffset);
        transformPelvisToD435DepthCamera.appendPitchRotation(1.2217304763960306);
        transformPelvisToD435DepthCamera.appendTranslation(0.0245, 0.0, 0.0);
        transformPelvisToD435DepthCamera.appendYawRotation(-1.5707963267948966);
        transformPelvisToD435DepthCamera.appendRollRotation(-1.5707963267948966);
        transformDepthCameraToTrackingCamera = new RigidBodyTransform();
        transformDepthCameraToTrackingCamera.appendRollRotation(1.5707963267948966);
        transformDepthCameraToTrackingCamera.appendYawRotation(1.5707963267948966);
        transformDepthCameraToTrackingCamera.appendTranslation(-0.0245, 0.0, 0.0);
        transformDepthCameraToTrackingCamera.appendPitchRotation(-1.2217304763960306);
        transformDepthCameraToTrackingCamera.appendTranslation(-0.058611, 0.0, -0.01);
        transformDepthCameraToTrackingCamera.appendTranslation(0.0358, 0.0, 0.0994);
        transformDepthCameraToTrackingCamera.appendPitchRotation(0.0);
        transformDepthCameraToTrackingCamera.appendRollRotation(-d435DepthRollOffset);
        transformDepthCameraToTrackingCamera.appendTranslation(0.0125, 0.0, 0.0);
        transformPelvisToTrackingCamera = new RigidBodyTransform();
        transformPelvisToTrackingCamera.multiply((RigidBodyTransformReadOnly)transformPelvisToD435DepthCamera);
        transformPelvisToTrackingCamera.multiply((RigidBodyTransformReadOnly)transformDepthCameraToTrackingCamera);
        transformTrackingCameraToDepthCamera = new RigidBodyTransform();
        transformTrackingCameraToDepthCamera.multiply((RigidBodyTransformReadOnly)transformDepthCameraToTrackingCamera);
        transformTrackingCameraToDepthCamera.invert();
        transformChestToL515DepthCamera = new RigidBodyTransform();
        transformChestToL515DepthCamera.setIdentity();
        transformChestToL515DepthCamera.getTranslation().set(0.275, 0.052, 0.14);
        transformChestToL515DepthCamera.getRotation().setYawPitchRoll(0.01, 1.1519, 0.045);
        transformChestToD435DepthCamera = new RigidBodyTransform();
        transformChestToD435DepthCamera.setIdentity();
        transformChestToD435DepthCamera.getTranslation().set(0.3, 0.02, 0.58);
        transformChestToD435DepthCamera.getRotation().setYawPitchRoll(0.0, 0.0, 0.0);
        transformChestToOuster = new RigidBodyTransform();
        transformChestToOuster.setIdentity();
        transformChestToOuster.getTranslation().set(0.265, -0.02, 0.72);
        transformChestToOuster.getRotation().setYawPitchRoll(0.0, 0.524, 0.0);
        transformChestToZED2 = new RigidBodyTransform();
        Point3D chestToSensor = new Point3D(0.275, 0.052, 0.4);
        transformChestToZED2.appendTranslation((Tuple3DReadOnly)chestToSensor);
        double pitch = Math.toRadians(66.0);
        transformChestToZED2.appendOrientation((Orientation3DReadOnly)new YawPitchRoll(0.01, pitch, -0.045));
        transformChestToRightBlackfly = new RigidBodyTransform();
        transformChestToRightBlackfly.setIdentity();
        transformChestToRightBlackfly.getTranslation().set((Tuple3DReadOnly)transformChestToOuster.getTranslation());
        transformChestToRightBlackfly.getTranslation().add(0.02, -0.12, -0.15);
        transformChestToRightBlackfly.getRotation().setYawPitchRoll(Math.toRadians(0.0), Math.toRadians(35.0), Math.toRadians(-5.0));
    }
}

