/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.multisenseTestbench;

import controller_msgs.msg.dds.RobotConfigurationData;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.ArrayBlockingQueue;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import org.ros.message.Time;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.HumanoidNetworkProcessor;
import us.ihmc.avatar.ros.RosTfPublisher;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.net.PacketConsumer;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;
import us.ihmc.humanoidRobotics.kryo.PPSTimestampOffsetProvider;
import us.ihmc.ihmcPerception.time.AlwaysZeroOffsetPPSTimestampOffsetProvider;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosJointStatePublisher;
import us.ihmc.utilities.ros.publisher.RosOdometryPublisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;

public class MultisenseTestBenchWithZeroPoseModuleNetworkProcessor
implements PacketConsumer<RobotConfigurationData>,
Runnable {
    private static final String DEFAULT_ROS_NAMESPACE = "/ihmc_ros/atlas";
    private static final String NODE_NAME = "/multisense_testbench";
    public static final String WORLD_FRAME_NAME = "world";
    private final String rosNamespace;
    private final RosMainNode rosMainNode;
    private final RosJointStatePublisher rosJointStatePublisher;
    private final RosOdometryPublisher pelvisOdometryPublisher;
    private final RosTfPublisher tfPublisher;
    private final ArrayList<String> jointNamesList;
    private final FullHumanoidRobotModel fullRobotModel;
    private final DRCRobotModel robotModel;
    private final int jointNameHash;
    private final ArrayBlockingQueue<RobotConfigurationData> availableRobotConfigurationData = new ArrayBlockingQueue(30);
    private final PPSTimestampOffsetProvider ppsTimestampOffsetProvider = new AlwaysZeroOffsetPPSTimestampOffsetProvider();
    private final HumanoidJointNameMap jointMap;
    private final ArrayList<ImmutableTriple<String, String, RigidBodyTransform>> staticTransforms;

    public MultisenseTestBenchWithZeroPoseModuleNetworkProcessor(DRCRobotModel robotModel, String rosNamespace) {
        this.robotModel = robotModel;
        URI rosUri = NetworkParameters.getROSURI();
        HumanoidNetworkProcessor networkProcessor = new HumanoidNetworkProcessor(robotModel, DomainFactory.PubSubImplementation.FAST_RTPS);
        networkProcessor.setupRosModule();
        networkProcessor.setupSensorModule();
        networkProcessor.setupZeroPoseRobotConfigurationPublisherModule();
        networkProcessor.setupShutdownHook();
        networkProcessor.start();
        this.rosNamespace = rosNamespace == null || rosNamespace.isEmpty() ? DEFAULT_ROS_NAMESPACE : rosNamespace;
        PacketCommunicator rosAPICommunicator = PacketCommunicator.createIntraprocessPacketCommunicator((NetworkPorts)NetworkPorts.ROS_API_COMMUNICATOR, (NetClassList)new IHMCCommunicationKryoNetClassList());
        this.staticTransforms = robotModel.getSensorInformation().getStaticTransformsForRos();
        this.rosMainNode = new RosMainNode(rosUri, this.rosNamespace + NODE_NAME);
        this.rosJointStatePublisher = new RosJointStatePublisher(false);
        this.fullRobotModel = robotModel.createFullRobotModel();
        OneDoFJointBasics[] controllableOneDoFJoints = this.fullRobotModel.getControllableOneDoFJoints();
        this.jointNamesList = new ArrayList(controllableOneDoFJoints.length);
        for (int i = 0; i < controllableOneDoFJoints.length; ++i) {
            this.jointNamesList.add(controllableOneDoFJoints[i].getName());
        }
        this.jointNameHash = RobotConfigurationDataFactory.calculateJointNameHash((OneDoFJointReadOnly[])controllableOneDoFJoints, (ForceSensorDefinition[])this.fullRobotModel.getForceSensorDefinitions(), (IMUDefinition[])this.fullRobotModel.getIMUDefinitions());
        rosAPICommunicator.attachListener(RobotConfigurationData.class, (PacketConsumer)this);
        this.pelvisOdometryPublisher = new RosOdometryPublisher(false);
        this.tfPublisher = new RosTfPublisher(this.rosMainNode, null);
        this.rosMainNode.attachPublisher(rosNamespace + "/output/joint_states", (RosTopicPublisher)this.rosJointStatePublisher);
        this.rosMainNode.attachPublisher(rosNamespace + "/output/robot_pose", (RosTopicPublisher)this.pelvisOdometryPublisher);
        this.rosMainNode.execute();
        this.jointMap = robotModel.getJointMap();
    }

    public MultisenseTestBenchWithZeroPoseModuleNetworkProcessor(DRCRobotModel robotModel) {
        this(robotModel, DEFAULT_ROS_NAMESPACE);
    }

    public static void main(String[] args) throws InterruptedException {
        AtlasRobotModel robotModel = AtlasRobotModelFactory.createDRCRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS.name(), RobotTarget.REAL_ROBOT, false);
        Thread t = new Thread(new MultisenseTestBenchWithZeroPoseModuleNetworkProcessor(robotModel));
        t.start();
        t.join();
    }

    public void receivedPacket(RobotConfigurationData robotConfigurationData) {
        if (!this.availableRobotConfigurationData.offer(robotConfigurationData)) {
            this.availableRobotConfigurationData.clear();
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        block2: while (true) {
            try {
                robotConfigurationData = this.availableRobotConfigurationData.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (!this.rosMainNode.isStarted()) continue;
            jointAngles = robotConfigurationData.getJointAngles().toArray();
            jointVelocities = robotConfigurationData.getJointVelocities().toArray();
            jointTorques = robotConfigurationData.getJointTorques().toArray();
            timeStamp = this.ppsTimestampOffsetProvider.adjustRobotTimeStampToRosClock(robotConfigurationData.getMonotonicTime());
            t = Time.fromNano((long)timeStamp);
            if (robotConfigurationData.getJointNameHash() != this.jointNameHash) {
                throw new RuntimeException("Joint names do not match for RobotConfigurationData");
            }
            this.rosJointStatePublisher.publish(this.jointNamesList, jointAngles, jointVelocities, jointTorques, t);
            pelvisTransform = new RigidBodyTransform((Orientation3DReadOnly)robotConfigurationData.getRootOrientation(), (Tuple3DReadOnly)robotConfigurationData.getRootPosition());
            this.pelvisOdometryPublisher.publish(timeStamp, pelvisTransform, (Vector3DReadOnly)robotConfigurationData.getPelvisLinearVelocity(), (Vector3DReadOnly)robotConfigurationData.getPelvisAngularVelocity(), this.jointMap.getUnsanitizedRootJointInSdf(), "world");
            this.tfPublisher.publish(pelvisTransform, timeStamp, "world", this.jointMap.getUnsanitizedRootJointInSdf());
            if (this.staticTransforms == null) continue;
            i = 0;
            while (true) {
                if (i < this.staticTransforms.size()) ** break;
                continue block2;
                staticTransformTriplet = this.staticTransforms.get(i);
                from = (String)staticTransformTriplet.getLeft();
                to = (String)staticTransformTriplet.getMiddle();
                staticTransform = (RigidBodyTransform)staticTransformTriplet.getRight();
                this.tfPublisher.publish(staticTransform, timeStamp, from, to);
                ++i;
            }
            break;
        }
    }
}

