/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.multisenseBlobExperiments;

import boofcv.gui.image.ImagePanel;
import boofcv.gui.image.ShowImages;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.swing.JFrame;
import javax.swing.SwingUtilities;
import org.opencv.core.Mat;
import org.opencv.core.Point;
import org.opencv.core.Scalar;
import org.opencv.imgproc.Imgproc;
import us.ihmc.atlas.multisenseBlobExperiments.MultisenseBlobDetectionPointCloudReceiver;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.graphicsDescription.color.HSVValue;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;
import us.ihmc.ihmcPerception.OpenCVTools;
import us.ihmc.ihmcPerception.vision.shapes.HSVRange;
import us.ihmc.ihmcPerception.vision.shapes.HoughCircleResult;
import us.ihmc.ihmcPerception.vision.shapes.OpenCVColoredCircularBlobDetector;
import us.ihmc.ihmcPerception.vision.shapes.OpenCVColoredCircularBlobDetectorFactory;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.subscriber.RosCompressedImageSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class MultiSenseBlobDetectionTestModule {
    private final PacketCommunicator packetCommunicator = PacketCommunicator.createTCPPacketCommunicatorServer((NetworkPorts)NetworkPorts.BEHAVIOR_MODULE_MESSAGER_PORT, (NetClassList)new IHMCCommunicationKryoNetClassList());
    private final String stereoTopic = "/multisense/image_points2_color";
    private final String lidarTopic = "/assembled_cloud";
    private final String leftImageColorTopic = "/multisense/left/image_rect_color/compressed";
    private BufferedImage latestBufferedImage;
    private BufferedImage convertedImageToDisplay;

    public MultiSenseBlobDetectionTestModule(URI rosMasterURI) {
        RosMainNode rosMainNode = new RosMainNode(rosMasterURI, "multiSenseBlobDetectionTestModule", true);
        MultisenseBlobDetectionPointCloudReceiver stereoReceiver = new MultisenseBlobDetectionPointCloudReceiver(this.packetCommunicator);
        MultisenseBlobDetectionPointCloudReceiver lidarReceiver = new MultisenseBlobDetectionPointCloudReceiver(this.packetCommunicator);
        rosMainNode.attachSubscriber("/assembled_cloud", (RosTopicSubscriberInterface)lidarReceiver);
        new BlobDetectionCompressedImageSubscriber(rosMainNode);
        rosMainNode.execute();
        this.connect();
        Thread blobDetectionThread = new Thread(){

            @Override
            public void run() {
                OpenCVColoredCircularBlobDetectorFactory factory = new OpenCVColoredCircularBlobDetectorFactory();
                factory.setCaptureSource(OpenCVColoredCircularBlobDetector.CaptureSource.JAVA_BUFFERED_IMAGES);
                OpenCVColoredCircularBlobDetector openCVColoredCircularBlobDetector = factory.buildBlobDetector();
                HSVRange greenRange = new HSVRange(new HSVValue(55.0, 80.0, 80.0), new HSVValue(139.0, 255.0, 255.0));
                HSVRange yellowRange = new HSVRange(new HSVValue(25.0, 100.0, 100.0), new HSVValue(40.0, 255.0, 255.0));
                openCVColoredCircularBlobDetector.addHSVRange(greenRange);
                openCVColoredCircularBlobDetector.addHSVRange(yellowRange);
                while (MultiSenseBlobDetectionTestModule.this.latestBufferedImage == null) {
                    ThreadTools.sleep((long)10L);
                }
                ImagePanel imagePanel = ShowImages.showWindow((BufferedImage)MultiSenseBlobDetectionTestModule.this.latestBufferedImage, (String)"Circle Detector");
                JFrame frame = (JFrame)SwingUtilities.getWindowAncestor((Component)imagePanel);
                Scalar circleColor = new Scalar(160.0, 0.0, 0.0);
                while (frame.isVisible()) {
                    openCVColoredCircularBlobDetector.updateFromBufferedImage(MultiSenseBlobDetectionTestModule.this.latestBufferedImage);
                    ArrayList circles = openCVColoredCircularBlobDetector.getCircles();
                    for (HoughCircleResult circle : circles) {
                        Point openCVPoint = new Point(circle.getCenter().getX(), circle.getCenter().getY());
                        Imgproc.circle((Mat)openCVColoredCircularBlobDetector.getCurrentCameraFrameMatInBGR(), (Point)openCVPoint, (int)((int)circle.getRadius()), (Scalar)circleColor, (int)1);
                    }
                    BufferedImage unconvertedImageToDisplay = OpenCVTools.convertMatToBufferedImage((Mat)openCVColoredCircularBlobDetector.getCurrentCameraFrameMatInBGR());
                    MultiSenseBlobDetectionTestModule.this.convertedImageToDisplay.getGraphics().drawImage(unconvertedImageToDisplay, 0, 0, null);
                    imagePanel.setImageUI(MultiSenseBlobDetectionTestModule.this.convertedImageToDisplay);
                }
            }
        };
        blobDetectionThread.run();
    }

    private void connect() {
        try {
            this.packetCommunicator.connect();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) throws URISyntaxException {
        new MultiSenseBlobDetectionTestModule(new URI("http://localhost:11311"));
    }

    private class BlobDetectionCompressedImageSubscriber
    extends RosCompressedImageSubscriber {
        public BlobDetectionCompressedImageSubscriber(RosMainNode rosNode) {
            rosNode.attachSubscriber("/multisense/left/image_rect_color/compressed", (RosTopicSubscriberInterface)this);
        }

        protected void imageReceived(long timeStamp, BufferedImage image) {
            if (MultiSenseBlobDetectionTestModule.this.latestBufferedImage == null) {
                MultiSenseBlobDetectionTestModule.this.latestBufferedImage = new BufferedImage(image.getWidth(), image.getHeight(), 5);
                MultiSenseBlobDetectionTestModule.this.convertedImageToDisplay = new BufferedImage(image.getWidth(), image.getHeight(), 1);
            }
            MultiSenseBlobDetectionTestModule.this.latestBufferedImage.getGraphics().drawImage(image, 0, 0, null);
        }
    }
}

