/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.joystickBasedStepping;

import atlas_msgs.msg.dds.BDIBehaviorCommandPacket;
import javafx.application.Platform;
import javafx.stage.Stage;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.joystickBasedStepping.AtlasKickAndPunchMessenger;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotKickMessenger;
import us.ihmc.avatar.joystickBasedJavaFXController.HumanoidRobotPunchMessenger;
import us.ihmc.avatar.joystickBasedJavaFXController.JoystickBasedSteppingMainUI;
import us.ihmc.commonWalkingControlModules.configurations.SteppingParameters;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.commons.PrintTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.euclid.geometry.ConvexPolygon2D;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.javafx.ApplicationNoModule;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.ros2.ROS2Topic;

public class AtlasJoystickBasedSteppingApplication
extends ApplicationNoModule {
    private JoystickBasedSteppingMainUI ui;
    private final ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"ihmc_atlas_xbox_joystick_control");
    private IHMCROS2Publisher<BDIBehaviorCommandPacket> bdiBehaviorcommandPublisher;

    public void start(Stage primaryStage) throws Exception {
        String robotTargetString = this.getParameters().getNamed().getOrDefault("robotTarget", "REAL_ROBOT");
        RobotTarget robotTarget = RobotTarget.valueOf((String)robotTargetString);
        PrintTools.info((String)"-------------------------------------------------------------------");
        PrintTools.info((String)("  -------- Loading parameters for RobotTarget: " + robotTarget + "  -------"));
        PrintTools.info((String)"-------------------------------------------------------------------");
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_LEFT_NUB_RIGHT_ROBOTIQ, robotTarget, false);
        String robotName = robotModel.getSimpleRobotName();
        this.bdiBehaviorcommandPublisher = ROS2Tools.createPublisherTypeNamed((ROS2NodeInterface)this.ros2Node, BDIBehaviorCommandPacket.class, (ROS2Topic)ROS2Tools.getControllerInputTopic((String)robotName));
        AtlasKickAndPunchMessenger atlasKickAndPunchMessenger = new AtlasKickAndPunchMessenger(this.ros2Node, robotName);
        WalkingControllerParameters walkingControllerParameters = robotModel.getWalkingControllerParameters();
        SteppingParameters steppingParameters = walkingControllerParameters.getSteppingParameters();
        double footLength = steppingParameters.getFootLength();
        double toeWidth = steppingParameters.getToeWidth();
        double footWidth = steppingParameters.getFootWidth();
        ConvexPolygon2D footPolygon = new ConvexPolygon2D();
        footPolygon.addVertex(footLength / 2.0, toeWidth / 2.0);
        footPolygon.addVertex(footLength / 2.0, -toeWidth / 2.0);
        footPolygon.addVertex(-footLength / 2.0, -footWidth / 2.0);
        footPolygon.addVertex(-footLength / 2.0, footWidth / 2.0);
        footPolygon.update();
        this.ui = new JoystickBasedSteppingMainUI(robotName, primaryStage, this.ros2Node, (FullHumanoidRobotModelFactory)robotModel, robotModel.getWalkingControllerParameters(), (HumanoidRobotKickMessenger)atlasKickAndPunchMessenger, (HumanoidRobotPunchMessenger)atlasKickAndPunchMessenger, (RobotLowLevelMessenger)atlasKickAndPunchMessenger, new SideDependentList((Object)footPolygon, (Object)footPolygon));
    }

    public void stop() throws Exception {
        super.stop();
        this.ui.stop();
        this.ros2Node.destroy();
        if (this.bdiBehaviorcommandPublisher != null) {
            this.bdiBehaviorcommandPublisher.publish((Object)HumanoidMessageTools.createBDIBehaviorCommandPacket((boolean)true));
        }
        Platform.exit();
    }

    public static void main(String[] args) {
        AtlasJoystickBasedSteppingApplication.launch((String[])args);
    }
}

