/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors.tools;

import java.util.ArrayList;
import java.util.Random;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.behaviors.AtlasKinematicSimulation;
import us.ihmc.atlas.behaviors.scsSensorSimulation.SCSLidarAndCameraSimulator;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.dynamicsSimulation.HumanoidDynamicsSimulation;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulation;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationParameters;
import us.ihmc.behaviors.simulation.EnvironmentInitialSetup;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.communication.CommunicationMode;
import us.ihmc.graphicsDescription.appearance.AppearanceDefinition;
import us.ihmc.graphicsDescription.appearance.YoAppearanceTexture;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.PlanarRegionsListDefinedEnvironment;
import us.ihmc.tools.processManagement.JavaProcessManager;
import us.ihmc.wholeBodyController.AdditionalSimulationContactPoints;
import us.ihmc.wholeBodyController.FootContactPoints;

public class AtlasSimulationBasics {
    protected static final RobotTarget ATLAS_TARGET = RobotTarget.SCS;
    protected static AtlasRobotVersion ATLAS_VERSION = AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS;
    protected static boolean LOG_TO_FILE = Boolean.parseBoolean(System.getProperty("log.to.file"));
    protected static boolean CREATE_YOVARIABLE_SERVER = Boolean.parseBoolean(System.getProperty("create.yovariable.server"));
    protected static boolean USE_DYNAMICS_SIMULATION = Boolean.parseBoolean(System.getProperty("use.dynamics.simulation"));
    protected static boolean RUN_LIDAR_AND_CAMERA_SIMULATION = Boolean.parseBoolean(System.getProperty("run.lidar.and.camera.simulation"));
    protected boolean CREATE_MORE_FOOT_CONTACT_POINTS = Boolean.parseBoolean(System.getProperty("create.more.foot.contact.points"));
    protected boolean CREATE_HAND_CONTACT_POINTS = Boolean.parseBoolean(System.getProperty("create.hand.contact.points"));
    protected int numberOfContactPointsX = 8;
    protected int numberOfContactPointsY = 3;
    private static boolean USE_INTERPROCESS_ROS2 = Boolean.parseBoolean(System.getProperty("use.interprocess.ros2"));
    private static boolean USE_INTERPROCESS_MESSAGER = Boolean.parseBoolean(System.getProperty("use.interprocess.messager"));
    protected static final CommunicationMode COMMUNICATION_MODE_ROS2 = USE_INTERPROCESS_ROS2 ? CommunicationMode.INTERPROCESS : CommunicationMode.INTRAPROCESS;
    protected static final CommunicationMode COMMUNICATION_MODE_MESSAGER = USE_INTERPROCESS_MESSAGER ? CommunicationMode.INTERPROCESS : CommunicationMode.INTRAPROCESS;
    protected final Runnable simulation = USE_DYNAMICS_SIMULATION ? this::dynamicsSimulation : this::kinematicSimulation;
    private static int ENVIRONMENT = Integer.parseInt(System.getProperty("environment", "-1"));
    protected final ArrayList<EnvironmentInitialSetup> environmentInitialSetups = new ArrayList();
    protected EnvironmentInitialSetup environmentInitialSetup;
    protected HumanoidDynamicsSimulation dynamicSimulation;
    protected HumanoidKinematicsSimulation kinematicsSimulation;
    protected boolean destroyed = false;
    protected SCSLidarAndCameraSimulator lidarAndCameraSimulator;

    protected void selectEnvironment() {
        Random random = new Random();
        this.environmentInitialSetup = this.environmentInitialSetups.get(ENVIRONMENT >= 0 ? ENVIRONMENT : random.nextInt(this.environmentInitialSetups.size()));
    }

    protected void dynamicsSimulation() {
        LogTools.info((String)"Creating dynamics simulation");
        int recordFrequencySpeedup = 50;
        int dataBufferSize = 10;
        this.dynamicSimulation = HumanoidDynamicsSimulation.create((DRCRobotModel)this.createRobotModel(), (CommonAvatarEnvironmentInterface)this.createCommonAvatarEnvironment(), (double)this.environmentInitialSetup.getGroundZ(), (double)this.environmentInitialSetup.getInitialX(), (double)this.environmentInitialSetup.getInitialY(), (double)this.environmentInitialSetup.getInitialYaw(), (DomainFactory.PubSubImplementation)COMMUNICATION_MODE_ROS2.getPubSubImplementation(), (int)recordFrequencySpeedup, (int)dataBufferSize, (boolean)LOG_TO_FILE);
        this.dynamicSimulation.simulate();
    }

    protected void kinematicSimulation() {
        LogTools.info((String)"Creating kinematics simulation");
        HumanoidKinematicsSimulationParameters kinematicsSimulationParameters = new HumanoidKinematicsSimulationParameters();
        kinematicsSimulationParameters.setPubSubImplementation(COMMUNICATION_MODE_ROS2.getPubSubImplementation());
        kinematicsSimulationParameters.setLogToFile(LOG_TO_FILE);
        kinematicsSimulationParameters.setCreateYoVariableServer(CREATE_YOVARIABLE_SERVER);
        kinematicsSimulationParameters.setInitialGroundHeight(this.environmentInitialSetup.getGroundZ());
        kinematicsSimulationParameters.setInitialRobotYaw(this.environmentInitialSetup.getInitialYaw());
        kinematicsSimulationParameters.setInitialRobotX(this.environmentInitialSetup.getInitialX());
        kinematicsSimulationParameters.setInitialRobotY(this.environmentInitialSetup.getInitialY());
        this.kinematicsSimulation = AtlasKinematicSimulation.create(this.createRobotModel(), kinematicsSimulationParameters);
    }

    protected CommonAvatarEnvironmentInterface createCommonAvatarEnvironment() {
        if (this.environmentInitialSetup.hasCommonAvatarEnvironmentInterface()) {
            return this.environmentInitialSetup.getCommonAvatarEnvironmentInterface();
        }
        String environmentName = PlanarRegionsListDefinedEnvironment.class.getSimpleName();
        YoAppearanceTexture cinderBlockTexture = new YoAppearanceTexture("sampleMeshes/cinderblock.png");
        return new PlanarRegionsListDefinedEnvironment(environmentName, (PlanarRegionsList)this.environmentInitialSetup.getPlanarRegionsSupplier().get(), (AppearanceDefinition)cinderBlockTexture, 0.02, false);
    }

    protected AtlasRobotModel createRobotModel() {
        if (this.CREATE_MORE_FOOT_CONTACT_POINTS) {
            AdditionalSimulationContactPoints simulationContactPoints = new AdditionalSimulationContactPoints((Enum[])RobotSide.values, this.numberOfContactPointsX, this.numberOfContactPointsY, true, true);
            return new AtlasRobotModel(ATLAS_VERSION, ATLAS_TARGET, false, (FootContactPoints<RobotSide>)simulationContactPoints, this.CREATE_HAND_CONTACT_POINTS);
        }
        return new AtlasRobotModel(ATLAS_VERSION, ATLAS_TARGET, false, this.CREATE_HAND_CONTACT_POINTS);
    }

    protected void lidarAndCameraSimulator() {
        this.lidarAndCameraSimulator = new SCSLidarAndCameraSimulator(COMMUNICATION_MODE_ROS2.getPubSubImplementation(), this.createCommonAvatarEnvironment(), (DRCRobotModel)this.createRobotModel());
    }

    protected boolean destroy() {
        if (!this.destroyed) {
            LogTools.info((String)"Shutting down");
            if (USE_DYNAMICS_SIMULATION && this.dynamicSimulation != null) {
                this.dynamicSimulation.destroy();
            } else if (this.kinematicsSimulation != null) {
                this.kinematicsSimulation.destroy();
            }
            if (this.lidarAndCameraSimulator != null) {
                this.lidarAndCameraSimulator.destroy();
            }
            DomainFactory.getDomain((DomainFactory.PubSubImplementation)COMMUNICATION_MODE_ROS2.getPubSubImplementation()).stopAll();
            this.destroyed = true;
            return true;
        }
        return false;
    }

    public static void runOrLogToFile(Class<?> clazz) {
        if (LOG_TO_FILE) {
            JavaProcessManager.teeToLogFile(clazz);
        } else {
            ExceptionTools.handle(clazz::newInstance, (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        }
    }
}

