/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import perception_msgs.msg.dds.VideoPacket;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.behaviors.AtlasBehaviorModule;
import us.ihmc.atlas.behaviors.SCSVideoDataROS2Bridge;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.drcRobot.SimulatedDRCRobotTimeProvider;
import us.ihmc.avatar.factory.AvatarSimulation;
import us.ihmc.avatar.factory.AvatarSimulationFactory;
import us.ihmc.avatar.initialSetup.DRCGuiInitialSetup;
import us.ihmc.avatar.initialSetup.DRCSCSInitialSetup;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.ContactableBodiesFactory;
import us.ihmc.commonWalkingControlModules.highLevelHumanoidControl.factories.HighLevelHumanoidControllerFactory;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.producers.VideoDataServer;
import us.ihmc.communication.producers.VideoDataServerImageCallback;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.graphicsDescription.image.ImageCallback;
import us.ihmc.humanoidRobotics.communication.packets.dataobjects.HighLevelControllerName;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.sensorProcessing.parameters.AvatarRobotCameraParameters;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.FlatGroundEnvironment;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.util.simulationTesting.SimulationTestingParameters;
import us.ihmc.tools.TimestampProvider;
import us.ihmc.wholeBodyController.RobotContactPointParameters;

public class AtlasSimulationWithCamera {
    private IHMCRealtimeROS2Publisher<VideoPacket> scsCameraPublisher;

    public SimulationConstructionSet createForManualTest(DRCRobotModel robotModel, CommonAvatarEnvironmentInterface environment) {
        return this.create(robotModel, environment, DomainFactory.PubSubImplementation.FAST_RTPS);
    }

    public SimulationConstructionSet createForAutomatedTest(DRCRobotModel robotModel, CommonAvatarEnvironmentInterface environment) {
        return this.create(robotModel, environment, DomainFactory.PubSubImplementation.INTRAPROCESS);
    }

    private SimulationConstructionSet create(DRCRobotModel robotModel, CommonAvatarEnvironmentInterface environment, DomainFactory.PubSubImplementation pubSubImplementation) {
        SimulationTestingParameters simulationTestingParameters = SimulationTestingParameters.createFromSystemProperties();
        DRCGuiInitialSetup guiInitialSetup = new DRCGuiInitialSetup(false, false, (SimulationConstructionSetParameters)simulationTestingParameters);
        DRCSCSInitialSetup scsInitialSetup = new DRCSCSInitialSetup(environment, robotModel.getSimulateDT());
        scsInitialSetup.setInitializeEstimatorToActual(true);
        scsInitialSetup.setTimePerRecordTick(robotModel.getControllerDT());
        scsInitialSetup.setUsePerfectSensors(true);
        RobotContactPointParameters contactPointParameters = robotModel.getContactPointParameters();
        ContactableBodiesFactory contactableBodiesFactory = new ContactableBodiesFactory();
        contactableBodiesFactory.setFootContactPoints(contactPointParameters.getFootContactPoints());
        contactableBodiesFactory.setToeContactParameters(contactPointParameters.getControllerToeContactPoints(), contactPointParameters.getControllerToeContactLines());
        for (int i = 0; i < contactPointParameters.getAdditionalContactNames().size(); ++i) {
            contactableBodiesFactory.addAdditionalContactPoint((String)contactPointParameters.getAdditionalContactRigidBodyNames().get(i), (String)contactPointParameters.getAdditionalContactNames().get(i), (RigidBodyTransform)contactPointParameters.getAdditionalContactTransforms().get(i));
        }
        RealtimeROS2Node realtimeROS2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)pubSubImplementation, (String)"humanoid_simulation_controller");
        this.scsCameraPublisher = ROS2Tools.createPublisher((RealtimeROS2Node)realtimeROS2Node, VideoPacket.class, (String)"/ihmc/video");
        HighLevelHumanoidControllerFactory controllerFactory = new HighLevelHumanoidControllerFactory(contactableBodiesFactory, robotModel.getSensorInformation().getFeetForceSensorNames(), robotModel.getSensorInformation().getWristForceSensorNames(), robotModel.getHighLevelControllerParameters(), robotModel.getWalkingControllerParameters(), robotModel.getPushRecoveryControllerParameters(), robotModel.getCoPTrajectoryParameters(), robotModel.getSplitFractionCalculatorParameters());
        controllerFactory.useDefaultDoNothingControlState();
        controllerFactory.useDefaultWalkingControlState();
        controllerFactory.addRequestableTransition(HighLevelControllerName.DO_NOTHING_BEHAVIOR, HighLevelControllerName.WALKING);
        controllerFactory.addRequestableTransition(HighLevelControllerName.WALKING, HighLevelControllerName.DO_NOTHING_BEHAVIOR);
        controllerFactory.addControllerFailureTransition(HighLevelControllerName.DO_NOTHING_BEHAVIOR, HighLevelControllerName.DO_NOTHING_BEHAVIOR);
        controllerFactory.addControllerFailureTransition(HighLevelControllerName.WALKING, HighLevelControllerName.DO_NOTHING_BEHAVIOR);
        controllerFactory.setInitialState(HighLevelControllerName.WALKING);
        controllerFactory.createControllerNetworkSubscriber(robotModel.getSimpleRobotName(), realtimeROS2Node);
        AvatarSimulationFactory avatarSimulationFactory = new AvatarSimulationFactory();
        avatarSimulationFactory.setRobotModel(robotModel);
        avatarSimulationFactory.setShapeCollisionSettings(robotModel.getShapeCollisionSettings());
        avatarSimulationFactory.setHighLevelHumanoidControllerFactory(controllerFactory);
        avatarSimulationFactory.setCommonAvatarEnvironment(environment);
        avatarSimulationFactory.setRobotInitialSetup(robotModel.getDefaultRobotInitialSetup(0.0, 0.0));
        avatarSimulationFactory.setSCSInitialSetup(scsInitialSetup);
        avatarSimulationFactory.setGuiInitialSetup(guiInitialSetup);
        avatarSimulationFactory.setRealtimeROS2Node(realtimeROS2Node);
        avatarSimulationFactory.setCreateYoVariableServer(false);
        AvatarSimulation avatarSimulation = avatarSimulationFactory.createAvatarSimulation();
        avatarSimulation.start();
        realtimeROS2Node.spin();
        SimulationConstructionSet scs = avatarSimulation.getSimulationConstructionSet();
        HumanoidRobotSensorInformation sensorInformation = robotModel.getSensorInformation();
        SimulatedDRCRobotTimeProvider timeStampProvider = avatarSimulation.getSimulatedRobotTimeProvider();
        HumanoidFloatingRootJointRobot robot = avatarSimulation.getHumanoidFloatingRootJointRobot();
        AvatarRobotCameraParameters cameraParameters = sensorInformation.getCameraParameters(0);
        String cameraName = cameraParameters.getSensorNameInSdf();
        int width = robot.getCameraMount(cameraName).getImageWidth();
        int height = robot.getCameraMount(cameraName).getImageHeight();
        CameraConfiguration cameraConfiguration = new CameraConfiguration(cameraName);
        cameraConfiguration.setCameraMount(cameraName);
        LogTools.info((String)"w: {}, h: {}", (Object)width, (Object)height);
        int framesPerSecond = 25;
        scs.startStreamingVideoData(cameraConfiguration, width, height, (ImageCallback)new VideoDataServerImageCallback((VideoDataServer)new SCSVideoDataROS2Bridge(arg_0 -> this.scsCameraPublisher.publish(arg_0))), (TimestampProvider)timeStampProvider, framesPerSecond);
        scs.setupGraph("root.atlas.t");
        scs.setupGraph("root.atlas.DRCSimulation.DRCControllerThread.DRCMomentumBasedController.HumanoidHighLevelControllerManager.highLevelControllerNameCurrentState");
        return scs;
    }

    public static void main(String[] args) {
        SimulationConstructionSet scs = new AtlasSimulationWithCamera().createForManualTest(new AtlasRobotModel(AtlasBehaviorModule.ATLAS_VERSION, RobotTarget.SCS, false), (CommonAvatarEnvironmentInterface)new FlatGroundEnvironment());
        scs.simulate();
    }
}

