/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import java.util.function.Supplier;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.behaviors.AtlasKinematicSimulation;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationParameters;
import us.ihmc.behaviors.BehaviorDefinition;
import us.ihmc.behaviors.BehaviorModule;
import us.ihmc.behaviors.BehaviorRegistry;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUI;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUIDefinition;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUIRegistry;
import us.ihmc.behaviors.javafx.behaviors.NavigationBehaviorUI;
import us.ihmc.behaviors.tools.PlanarRegionsMappingModule;
import us.ihmc.behaviors.tools.perception.SimulatedREAModule;
import us.ihmc.commons.thread.Notification;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.javafx.applicationCreator.JavaFXApplicationCreator;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.pathPlanning.PlannerTestEnvironments;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.wholeBodyController.AdditionalSimulationContactPoints;
import us.ihmc.wholeBodyController.FootContactPoints;

public class AtlasNavigationBehaviorDemo {
    private static final AtlasRobotVersion ATLAS_VERSION = AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS;
    private static final RobotTarget ATLAS_TARGET = RobotTarget.SCS;
    private DomainFactory.PubSubImplementation pubSubMode = DomainFactory.PubSubImplementation.INTRAPROCESS;
    private static boolean LOG_TO_FILE = Boolean.parseBoolean(System.getProperty("log.to.file"));
    private static boolean CREATE_YOVARIABLE_SERVER = Boolean.parseBoolean(System.getProperty("create.yovariable.server"));
    private static final Supplier<PlanarRegionsList> TRICKY_CORRIDOR = PlannerTestEnvironments::getTrickCorridorWidened;
    private static final Supplier<PlanarRegionsList> MAZE_CORRIDOR = PlannerTestEnvironments::getMazeCorridor;
    private static final Supplier<PlanarRegionsList> ENVIRONMENT = MAZE_CORRIDOR;
    private Notification slamUpdated;

    public AtlasNavigationBehaviorDemo() {
        JavaFXApplicationCreator.createAJavaFXApplication();
        ThreadTools.startAThread(this::simulatedREAModule, (String)"SimulatedREAModule");
        ThreadTools.startAThread(this::planarRegionsMappingModule, (String)"PlanarRegionsMappingModule");
        ThreadTools.startAThread(this::kinematicsSimulation, (String)"KinematicsSimulation");
        JavaFXBehaviorUIRegistry behaviorRegistry = JavaFXBehaviorUIRegistry.of((BehaviorDefinition)NavigationBehaviorUI.DEFINITION, (JavaFXBehaviorUIDefinition[])new JavaFXBehaviorUIDefinition[0]);
        BehaviorModule behaviorModule = BehaviorModule.createIntraprocess((BehaviorRegistry)behaviorRegistry, (DRCRobotModel)this.createRobotModel());
        LogTools.info((String)"Creating behavior user interface");
        JavaFXBehaviorUI.createIntraprocess((JavaFXBehaviorUIRegistry)behaviorRegistry, (DRCRobotModel)this.createRobotModel(), (Messager)behaviorModule.getMessager());
    }

    private void simulatedREAModule() {
        LogTools.info((String)"Creating simulated REA module");
        SimulatedREAModule simulatedREAModule = new SimulatedREAModule(ENVIRONMENT.get(), (DRCRobotModel)this.createRobotModel(), this.pubSubMode);
        simulatedREAModule.start();
    }

    private void planarRegionsMappingModule() {
        LogTools.info((String)"Creating planar regions mapping module");
        PlanarRegionsMappingModule planarRegionsMappingModule = new PlanarRegionsMappingModule(this.pubSubMode);
        this.slamUpdated = planarRegionsMappingModule.getSlamUpdated();
    }

    private void kinematicsSimulation() {
        LogTools.info((String)"Creating simulation");
        HumanoidKinematicsSimulationParameters kinematicsSimulationParameters = new HumanoidKinematicsSimulationParameters();
        kinematicsSimulationParameters.setPubSubImplementation(this.pubSubMode);
        kinematicsSimulationParameters.setLogToFile(LOG_TO_FILE);
        kinematicsSimulationParameters.setCreateYoVariableServer(CREATE_YOVARIABLE_SERVER);
        AtlasKinematicSimulation.create(this.createRobotModel(), kinematicsSimulationParameters);
    }

    private AtlasRobotModel createRobotModel() {
        AdditionalSimulationContactPoints simulationContactPoints = new AdditionalSimulationContactPoints((Enum[])RobotSide.values, 8, 3, true, true);
        return new AtlasRobotModel(ATLAS_VERSION, ATLAS_TARGET, false, (FootContactPoints<RobotSide>)simulationContactPoints);
    }

    public static void main(String[] args) {
        new AtlasNavigationBehaviorDemo();
    }
}

