/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import controller_msgs.msg.dds.RobotConfigurationData;
import perception_msgs.msg.dds.VideoPacket;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.behaviors.AtlasKinematicSimulation;
import us.ihmc.atlas.behaviors.SCSVideoDataROS2Bridge;
import us.ihmc.atlas.behaviors.scsSensorSimulation.SensorOnlySimulation;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.ROS2SyncedRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationParameters;
import us.ihmc.behaviors.javafx.simulation.RobotAndMapViewer;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.producers.VideoDataServer;
import us.ihmc.communication.producers.VideoDataServerImageCallback;
import us.ihmc.graphicsDescription.image.ImageCallback;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.partNames.NeckJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.ROS2Input;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.ros2.ROS2NodeInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.FlatGroundEnvironment;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.wholeBodyController.AdditionalSimulationContactPoints;
import us.ihmc.wholeBodyController.FootContactPoints;

public class AtlasKinematicSimWithCamera {
    private static boolean SHOW_ROBOT_VIEWER = false;
    private static boolean LOG_TO_FILE = Boolean.parseBoolean(System.getProperty("log.to.file"));
    private static boolean CREATE_YOVARIABLE_SERVER = Boolean.parseBoolean(System.getProperty("create.yovariable.server"));
    private IHMCROS2Publisher<VideoPacket> scsCameraPublisher;
    private final ROS2Node ros2Node;

    public AtlasKinematicSimWithCamera(CommonAvatarEnvironmentInterface environment) {
        AtlasRobotModel robotModel = this.createRobotModel();
        HumanoidKinematicsSimulationParameters kinematicsSimulationParameters = new HumanoidKinematicsSimulationParameters();
        kinematicsSimulationParameters.setPubSubImplementation(DomainFactory.PubSubImplementation.FAST_RTPS);
        kinematicsSimulationParameters.setLogToFile(LOG_TO_FILE);
        kinematicsSimulationParameters.setCreateYoVariableServer(CREATE_YOVARIABLE_SERVER);
        AtlasKinematicSimulation.create(robotModel, kinematicsSimulationParameters);
        this.ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"kinematic_camera");
        if (SHOW_ROBOT_VIEWER) {
            ThreadTools.startAThread(this::robotViewer, (String)"RobotViewer");
        }
        this.scsCameraPublisher = new IHMCROS2Publisher((ROS2NodeInterface)this.ros2Node, VideoPacket.class, ROS2Tools.IHMC_ROOT);
        ROS2SyncedRobotModel syncedRobot = new ROS2SyncedRobotModel((DRCRobotModel)robotModel, (ROS2NodeInterface)this.ros2Node);
        syncedRobot.update();
        syncedRobot.getReferenceFrames().getNeckFrame(NeckJointName.PROXIMAL_NECK_PITCH);
        SensorOnlySimulation sensorOnlySimulation = new SensorOnlySimulation();
        SimulationConstructionSet scs = sensorOnlySimulation.getSCS();
        ROS2Input robotConfigurationData = new ROS2Input((ROS2NodeInterface)this.ros2Node, RobotConfigurationData.class, ROS2Tools.HUMANOID_CONTROLLER.withRobot(robotModel.getSimpleRobotName()).withOutput());
        String cameraName = "camera";
        CameraConfiguration cameraConfiguration = new CameraConfiguration(cameraName);
        cameraConfiguration.setCameraMount(cameraName);
        int width = 1024;
        int height = 544;
        int framesPerSecond = 25;
        scs.startStreamingVideoData(cameraConfiguration, width, height, (ImageCallback)new VideoDataServerImageCallback((VideoDataServer)new SCSVideoDataROS2Bridge(arg_0 -> this.scsCameraPublisher.publish(arg_0))), () -> ((RobotConfigurationData)robotConfigurationData.getLatest()).getSyncTimestamp(), framesPerSecond);
        scs.simulate();
    }

    private void robotViewer() {
        LogTools.info((String)"Creating robot and map viewer");
        new RobotAndMapViewer((DRCRobotModel)this.createRobotModel(), this.ros2Node);
    }

    private AtlasRobotModel createRobotModel() {
        AdditionalSimulationContactPoints simulationContactPoints = new AdditionalSimulationContactPoints((Enum[])RobotSide.values, 8, 3, true, true);
        return new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.SCS, false, (FootContactPoints<RobotSide>)simulationContactPoints);
    }

    public static void main(String[] args) {
        new AtlasKinematicSimWithCamera((CommonAvatarEnvironmentInterface)new FlatGroundEnvironment());
    }
}

