/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import java.util.function.Supplier;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.behaviors.AtlasKinematicSimulation;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.environments.BehaviorPlanarRegionEnvironments;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationParameters;
import us.ihmc.avatar.networkProcessor.footstepPlanningModule.FootstepPlanningModuleLauncher;
import us.ihmc.behaviors.tools.perception.SimulatedREAModule;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.wholeBodyController.AdditionalSimulationContactPoints;
import us.ihmc.wholeBodyController.FootContactPoints;

public class AtlasEnvironmentSimulatorForBehaviors {
    private static final AtlasRobotVersion ATLAS_VERSION = AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ;
    private static final RobotTarget ATLAS_TARGET = RobotTarget.SCS;
    private DomainFactory.PubSubImplementation pubSubMode = DomainFactory.PubSubImplementation.FAST_RTPS;
    private static boolean LOG_TO_FILE = Boolean.parseBoolean(System.getProperty("log.to.file"));
    private static boolean CREATE_YOVARIABLE_SERVER = Boolean.parseBoolean(System.getProperty("create.yovariable.server"));
    private static final Supplier<PlanarRegionsList> ENVIRONMENT = BehaviorPlanarRegionEnvironments::createUpDownTwoHighWithFlatBetween;

    public AtlasEnvironmentSimulatorForBehaviors() {
        ThreadTools.startAThread(this::reaModule, (String)"REAModule");
        ThreadTools.startAThread(this::kinematicSimulation, (String)"KinematicsSimulation");
        ThreadTools.startAThread(this::footstepPlanningToolbox, (String)"FootstepPlanningToolbox");
    }

    private void footstepPlanningToolbox() {
        LogTools.info((String)"Starting footstep toolbox");
        FootstepPlanningModuleLauncher.createModule((DRCRobotModel)this.createRobotModel(), (DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
    }

    private void reaModule() {
        LogTools.info((String)"Creating simulated REA module");
        SimulatedREAModule simulatedREAModule = new SimulatedREAModule(ENVIRONMENT.get(), (DRCRobotModel)this.createRobotModel(), this.pubSubMode);
        simulatedREAModule.start();
    }

    private void kinematicSimulation() {
        LogTools.info((String)"Creating simulation");
        HumanoidKinematicsSimulationParameters kinematicsSimulationParameters = new HumanoidKinematicsSimulationParameters();
        kinematicsSimulationParameters.setPubSubImplementation(this.pubSubMode);
        kinematicsSimulationParameters.setLogToFile(LOG_TO_FILE);
        kinematicsSimulationParameters.setCreateYoVariableServer(CREATE_YOVARIABLE_SERVER);
        AtlasKinematicSimulation.create(this.createRobotModel(), kinematicsSimulationParameters);
    }

    private AtlasRobotModel createRobotModel() {
        AdditionalSimulationContactPoints simulationContactPoints = new AdditionalSimulationContactPoints((Enum[])RobotSide.values, 8, 3, true, true);
        return new AtlasRobotModel(ATLAS_VERSION, ATLAS_TARGET, false, (FootContactPoints<RobotSide>)simulationContactPoints);
    }

    public static void main(String[] args) {
        new AtlasEnvironmentSimulatorForBehaviors();
    }
}

