/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.behaviors.BehaviorModule;
import us.ihmc.behaviors.BehaviorRegistry;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUI;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUIRegistry;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.communication.CommunicationMode;
import us.ihmc.humanoidBehaviors.IHMCHumanoidBehaviorManager;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;

public class AtlasBehaviorUIAndModule {
    private JavaFXBehaviorUIRegistry behaviorRegistry;

    public AtlasBehaviorUIAndModule(JavaFXBehaviorUIRegistry behaviorRegistry) {
        this.behaviorRegistry = behaviorRegistry;
        CommunicationMode ros2CommunicationMode = CommunicationMode.INTERPROCESS;
        CommunicationMode behaviorMessagerCommunicationMode = CommunicationMode.INTRAPROCESS;
        this.start(this.createRobotModel(), ros2CommunicationMode, behaviorMessagerCommunicationMode);
    }

    public void start(DRCRobotModel robotModel, CommunicationMode ros2CommunicationMode, CommunicationMode behaviorMessagerCommunicationMode) {
        LogTools.info((String)"Starting humanoid behavior manager");
        ExceptionTools.handle(() -> {
            HumanoidRobotSensorInformation sensorInformation = robotModel.getSensorInformation();
            LogModelProvider logModelProvider = robotModel.getLogModelProvider();
            new IHMCHumanoidBehaviorManager(robotModel.getSimpleRobotName(), robotModel.getFootstepPlannerParameters(), (WholeBodyControllerParameters)robotModel, (FullHumanoidRobotModelFactory)robotModel, logModelProvider, false, sensorInformation);
        }, (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        LogTools.info((String)"Starting behavior module");
        boolean enableROS1 = true;
        BehaviorModule behaviorModule = new BehaviorModule((BehaviorRegistry)this.behaviorRegistry, robotModel, ros2CommunicationMode, behaviorMessagerCommunicationMode, enableROS1);
        LogTools.info((String)"Starting behavior UI");
        JavaFXBehaviorUI behaviorUI = JavaFXBehaviorUI.create((JavaFXBehaviorUIRegistry)this.behaviorRegistry, (DRCRobotModel)robotModel, (CommunicationMode)ros2CommunicationMode, (CommunicationMode)behaviorMessagerCommunicationMode, (String)"localhost", (Messager)behaviorModule.getMessager());
    }

    private DRCRobotModel createRobotModel() {
        return new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.REAL_ROBOT, false);
    }

    public static void main(String[] args) {
        new AtlasBehaviorUIAndModule(JavaFXBehaviorUIRegistry.DEFAULT_BEHAVIORS);
    }
}

