/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.avatar.drcRobot.collisions.SDFCollisionBoxProvider;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.ihmcPerception.depthData.collisionShapes.CollisionBox;
import us.ihmc.ihmcPerception.depthData.collisionShapes.CollisionCylinder;
import us.ihmc.ihmcPerception.depthData.collisionShapes.CollisionShape;
import us.ihmc.ihmcPerception.depthData.collisionShapes.CollisionSphere;
import us.ihmc.modelFileLoaders.SdfLoader.JaxbSDFLoader;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;

public class AtlasCollisionBoxProvider
extends SDFCollisionBoxProvider {
    public AtlasCollisionBoxProvider(JaxbSDFLoader loader, AtlasJointMap jointMap) {
        super(loader, jointMap.getModelName());
        for (RobotSide robotSide : RobotSide.values) {
            String joint = jointMap.getJointBeforeHandName(robotSide);
            RigidBodyTransform mittenPose = new RigidBodyTransform();
            mittenPose.getTranslation().set(0.0, robotSide.negateIfRightSide(0.27), -0.005);
            CollisionSphere hand = new CollisionSphere(mittenPose, 0.15999999910593032);
            this.addCollisionShape(joint, (CollisionShape)hand);
            String kneeJoint = jointMap.getLegJointName(robotSide, LegJointName.KNEE_PITCH);
            RigidBodyTransform kneePose = new RigidBodyTransform();
            kneePose.setRotationRollAndZeroTranslation(1.5707963267948966);
            kneePose.getTranslation().set(0.05, 0.0, 0.03);
            CollisionCylinder knee = new CollisionCylinder(kneePose, 0.11, 0.22999999821186065);
            this.addCollisionShape(kneeJoint, (CollisionShape)knee);
            String elbowJoint = jointMap.getArmJointName(robotSide, ArmJointName.ELBOW_PITCH);
            RigidBodyTransform elbowBoxTransform = new RigidBodyTransform();
            elbowBoxTransform.getTranslation().set(0.0, robotSide.negateIfLeftSide(0.1), -0.2);
            CollisionBox stupidHoseBox = new CollisionBox(elbowBoxTransform, 0.15, 0.3, 0.15);
            this.addCollisionShape(elbowJoint, (CollisionShape)stupidHoseBox);
        }
        String backRollJoint = jointMap.getSpineJointName(SpineJointName.SPINE_ROLL);
        RigidBodyTransform backPackTransform = new RigidBodyTransform();
        backPackTransform.getTranslation().set(-0.2, 0.0, 0.2);
        CollisionBox backPackHoseBox = new CollisionBox(backPackTransform, 0.2, 0.5, 0.3);
        this.addCollisionShape(backRollJoint, (CollisionShape)backPackHoseBox);
        RigidBodyTransform haloTransform = new RigidBodyTransform();
        haloTransform.getTranslation().set(0.0, 0.0, 1.0);
        CollisionCylinder halo = new CollisionCylinder(haloTransform, 0.35, 1.0);
        this.addCollisionShape(backRollJoint, (CollisionShape)halo);
    }
}

