/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.sensors;

import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.parameters.AtlasSensorInformation;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.commons.exception.DefaultExceptionHandler;
import us.ihmc.commons.exception.ExceptionHandler;
import us.ihmc.commons.exception.ExceptionTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.humanoidBehaviors.IHMCHumanoidBehaviorManager;
import us.ihmc.log.LogTools;
import us.ihmc.multicastLogDataProtocol.modelLoaders.LogModelProvider;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.sensorProcessing.parameters.HumanoidRobotSensorInformation;
import us.ihmc.wholeBodyController.WholeBodyControllerParameters;

public class AtlasBehaviorManager {
    private IHMCHumanoidBehaviorManager behaviorManager;

    public AtlasBehaviorManager() {
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT);
        AtlasSensorInformation sensorInformation = (AtlasSensorInformation)robotModel.getSensorInformation();
        ExceptionTools.handle(() -> {
            LogModelProvider logModelProvider = robotModel.getLogModelProvider();
            boolean startYoVariableServer = false;
            this.behaviorManager = new IHMCHumanoidBehaviorManager(robotModel.getSimpleRobotName(), robotModel.getFootstepPlannerParameters(), (WholeBodyControllerParameters)robotModel, (FullHumanoidRobotModelFactory)robotModel, logModelProvider, startYoVariableServer, (HumanoidRobotSensorInformation)sensorInformation);
        }, (ExceptionHandler)DefaultExceptionHandler.RUNTIME_EXCEPTION);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            LogTools.info((String)"Shutting down network processor modules.");
            if (this.behaviorManager != null) {
                this.behaviorManager.closeAndDispose();
            }
            ThreadTools.sleep((long)10L);
        }, this.getClass().getSimpleName() + "Shutdown"));
    }

    public static void main(String[] args) {
        new AtlasBehaviorManager();
    }
}

