/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.ros;

import controller_msgs.msg.dds.AtlasAuxiliaryRobotData;
import java.net.URI;
import java.util.LinkedHashMap;
import java.util.concurrent.ArrayBlockingQueue;
import us.ihmc.humanoidRobotics.communication.packets.manipulation.AtlasElectricMotorPacketEnum;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.publisher.RosBoolPublisher;
import us.ihmc.utilities.ros.publisher.RosDoublePublisher;
import us.ihmc.utilities.ros.publisher.RosInt64Publisher;
import us.ihmc.utilities.ros.publisher.RosTopicPublisher;

public class RosAtlasAuxiliaryRobotDataPublisher
implements Runnable {
    private final ArrayBlockingQueue<AtlasAuxiliaryRobotData> availableAtlasAuxiliaryData = new ArrayBlockingQueue(30);
    private final RosMainNode rosMainNode;
    private final LinkedHashMap<AtlasElectricMotorPacketEnum, RosBoolPublisher> electricForearmEnabledPublishers = new LinkedHashMap();
    private final LinkedHashMap<AtlasElectricMotorPacketEnum, RosDoublePublisher> electricForearmTemperaturePublishers = new LinkedHashMap();
    private final LinkedHashMap<AtlasElectricMotorPacketEnum, RosDoublePublisher> electricForearmCurrentPublishers = new LinkedHashMap();
    private final RosDoublePublisher pumpInletPressurePublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher pumpSupplyPressurePublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher airSumpPressurePublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher pumpSupplyTemperaturePublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher pumpRPMPublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher motorTemperaturePublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher motorDriverTemperaturePublisher = new RosDoublePublisher(false);
    private final RosBoolPublisher batteryChargingPublisher = new RosBoolPublisher(false);
    private final RosDoublePublisher batteryVoltagePublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher batteryCurrentPublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher remainingBatteryTimePublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher remainingAmpHoursPublisher = new RosDoublePublisher(false);
    private final RosDoublePublisher remainingChargePercentagePublisher = new RosDoublePublisher(false);
    private final RosInt64Publisher cycleCountPublisher = new RosInt64Publisher(false);

    public RosAtlasAuxiliaryRobotDataPublisher(RosMainNode rosMainNode, String rosNameSpace) {
        this.rosMainNode = rosMainNode;
        this.initialize(rosMainNode, rosNameSpace);
    }

    public RosAtlasAuxiliaryRobotDataPublisher(URI rosuri, String nameSpace) {
        this.rosMainNode = new RosMainNode(rosuri, nameSpace + this.getClass().getName());
        this.initialize(this.rosMainNode, nameSpace);
    }

    private void initialize(RosMainNode rosMainNode, String rosNameSpace) {
        this.setupElectricForearmPublishers(rosNameSpace);
        this.setupPumpPublishers(rosNameSpace);
        this.setupBatteryPublishers(rosMainNode, rosNameSpace);
        Thread thread = new Thread((Runnable)this, this.getClass().getName());
        thread.start();
    }

    private void setupBatteryPublishers(RosMainNode rosMainNode, String rosNameSpace) {
        rosMainNode.attachPublisher(rosNameSpace + "/output/battery/charging", (RosTopicPublisher)this.batteryChargingPublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/battery/voltage", (RosTopicPublisher)this.batteryVoltagePublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/battery/current", (RosTopicPublisher)this.batteryCurrentPublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/battery/time_remaining", (RosTopicPublisher)this.remainingBatteryTimePublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/battery/amp_hours_remaining", (RosTopicPublisher)this.remainingAmpHoursPublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/battery/charge_percentage_remaining", (RosTopicPublisher)this.remainingChargePercentagePublisher);
        rosMainNode.attachPublisher(rosNameSpace + "/output/battery/cycle_count", (RosTopicPublisher)this.cycleCountPublisher);
    }

    private void setupPumpPublishers(String rosNameSpace) {
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/pump/pump_inlet_pressure", (RosTopicPublisher)this.pumpInletPressurePublisher);
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/pump/pump_supply_pressure", (RosTopicPublisher)this.pumpSupplyPressurePublisher);
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/pump/air_sump_pressure", (RosTopicPublisher)this.airSumpPressurePublisher);
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/pump/pump_supply_temperature", (RosTopicPublisher)this.pumpSupplyTemperaturePublisher);
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/pump/pump_rpm", (RosTopicPublisher)this.pumpRPMPublisher);
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/pump/motor_temperature", (RosTopicPublisher)this.motorTemperaturePublisher);
        this.rosMainNode.attachPublisher(rosNameSpace + "/output/pump/motor_driver_temperature", (RosTopicPublisher)this.motorDriverTemperaturePublisher);
    }

    private void setupElectricForearmPublishers(String rosNameSpace) {
        for (AtlasElectricMotorPacketEnum value : AtlasElectricMotorPacketEnum.values) {
            RosBoolPublisher boolPublisher = new RosBoolPublisher(false);
            this.electricForearmEnabledPublishers.put(value, boolPublisher);
            this.rosMainNode.attachPublisher(rosNameSpace + "/output/electric_forearms/" + value.toString().toLowerCase() + "/enabled", (RosTopicPublisher)boolPublisher);
            RosDoublePublisher tempPublisher = new RosDoublePublisher(false);
            this.electricForearmTemperaturePublishers.put(value, tempPublisher);
            this.rosMainNode.attachPublisher(rosNameSpace + "/output/electric_forearms/" + value.toString().toLowerCase() + "/temperature", (RosTopicPublisher)tempPublisher);
            RosDoublePublisher currentPublisher = new RosDoublePublisher(false);
            this.electricForearmCurrentPublishers.put(value, currentPublisher);
            this.rosMainNode.attachPublisher(rosNameSpace + "/output/electric_forearms/" + value.toString().toLowerCase() + "/drive_current", (RosTopicPublisher)currentPublisher);
        }
    }

    @Override
    public void run() {
        while (true) {
            AtlasAuxiliaryRobotData auxiliaryRobotData;
            try {
                auxiliaryRobotData = this.availableAtlasAuxiliaryData.take();
            }
            catch (InterruptedException e) {
                continue;
            }
            if (!this.rosMainNode.isStarted()) continue;
            this.publishElectricForearmData(auxiliaryRobotData);
            this.publishPumpData(auxiliaryRobotData);
            this.publishBatteryData(auxiliaryRobotData);
        }
    }

    private void publishElectricForearmData(AtlasAuxiliaryRobotData auxiliaryRobotData) {
        for (AtlasElectricMotorPacketEnum value : AtlasElectricMotorPacketEnum.values) {
            RosBoolPublisher rosBoolPublisher = this.electricForearmEnabledPublishers.get(value);
            rosBoolPublisher.publish(auxiliaryRobotData.getElectricJointEnabledArray().get(value.getId()) == 1);
            RosDoublePublisher temperaturePublisher = this.electricForearmTemperaturePublishers.get(value);
            temperaturePublisher.publish((double)auxiliaryRobotData.getElectricJointTemperatures().get(value.getId()));
            RosDoublePublisher currentPublisher = this.electricForearmCurrentPublishers.get(value);
            currentPublisher.publish((double)auxiliaryRobotData.getElectricJointCurrents().get(value.getId()));
        }
    }

    private void publishPumpData(AtlasAuxiliaryRobotData auxiliaryRobotData) {
        this.pumpInletPressurePublisher.publish((double)auxiliaryRobotData.getPumpInletPressure());
        this.pumpSupplyPressurePublisher.publish((double)auxiliaryRobotData.getPumpSupplyPressure());
        this.airSumpPressurePublisher.publish((double)auxiliaryRobotData.getAirSumpPressure());
        this.pumpSupplyTemperaturePublisher.publish((double)auxiliaryRobotData.getPumpSupplyTemperature());
        this.pumpRPMPublisher.publish((double)auxiliaryRobotData.getPumpRpm());
        this.motorTemperaturePublisher.publish((double)auxiliaryRobotData.getMotorTemperature());
        this.motorDriverTemperaturePublisher.publish((double)auxiliaryRobotData.getMotorDriverTemperature());
    }

    private void publishBatteryData(AtlasAuxiliaryRobotData auxiliaryRobotData) {
        this.batteryChargingPublisher.publish(auxiliaryRobotData.getBatteryCharging());
        this.batteryVoltagePublisher.publish((double)auxiliaryRobotData.getBatteryVoltage());
        this.batteryCurrentPublisher.publish((double)auxiliaryRobotData.getBatteryCurrent());
        this.remainingBatteryTimePublisher.publish((double)auxiliaryRobotData.getRemainingBatteryTime());
        this.remainingAmpHoursPublisher.publish((double)auxiliaryRobotData.getRemainingAmpHours());
        this.remainingChargePercentagePublisher.publish((double)auxiliaryRobotData.getRemainingChargePercentage());
        this.cycleCountPublisher.publish(auxiliaryRobotData.getBatteryCycleCount());
    }

    public void receivedPacket(AtlasAuxiliaryRobotData auxiliaryRobotData) {
        if (!this.availableAtlasAuxiliaryData.offer(auxiliaryRobotData)) {
            this.availableAtlasAuxiliaryData.clear();
        }
    }
}

