/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.remote;

import java.awt.Container;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.filechooser.FileNameExtensionFilter;
import org.apache.batik.dom.util.HashTable;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformBasics;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DBasics;
import us.ihmc.graphicsDescription.yoGraphics.YoGraphicsListRegistry;
import us.ihmc.jMonkeyEngineToolkit.camera.CameraConfiguration;
import us.ihmc.robotDataLogger.HandshakeFileType;
import us.ihmc.robotDataLogger.LogProperties;
import us.ihmc.robotDataLogger.handshake.YoVariableHandshakeParser;
import us.ihmc.robotDataLogger.logger.LogPropertiesReader;
import us.ihmc.robotDataVisualizer.logger.MultiVideoDataPlayer;
import us.ihmc.robotDataVisualizer.logger.YoVariableLogPlaybackRobot;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.robotDescription.RobotDescription;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationconstructionset.Joint;
import us.ihmc.simulationconstructionset.PlaybackListener;
import us.ihmc.simulationconstructionset.RewoundListener;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.SimulationConstructionSet;
import us.ihmc.simulationconstructionset.SimulationConstructionSetParameters;
import us.ihmc.simulationconstructionset.SimulationDoneListener;
import us.ihmc.simulationconstructionset.UnreasonableAccelerationException;
import us.ihmc.tools.gui.SwingUtils;
import us.ihmc.yoVariables.buffer.YoBuffer;
import us.ihmc.yoVariables.buffer.YoBufferVariableEntry;
import us.ihmc.yoVariables.variable.YoVariable;

public class AtlasMultiDataExporter
implements SimulationDoneListener {
    private static final long CLOSING_SLEEP_TIME = 2000L;
    YoVariableLogPlaybackRobot robot;
    SimulationConstructionSet scs;
    YoVariableHandshakeParser parser;
    MultiVideoDataPlayer players = null;
    SimulateAndExport simulateExport;
    Thread simulation;
    boolean exportSCSVideo;
    boolean showCameraVideo;

    public AtlasMultiDataExporter(DRCRobotModel robotModel, int bufferSize, boolean showGUIAndSaveSCSVideo, boolean showCameraVideo, File logFile) throws IOException {
        this.initialize(robotModel, bufferSize, showGUIAndSaveSCSVideo, logFile);
        this.simulation = new Thread((Runnable)this.scs);
        this.exportSCSVideo = showGUIAndSaveSCSVideo;
        this.showCameraVideo = showCameraVideo;
    }

    public static void main(String[] args) throws IOException {
        AtlasRobotVersion ATLAS_ROBOT_VERSION = AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS;
        int numberOfEntries = 0;
        AtlasRobotModel model = new AtlasRobotModel(ATLAS_ROBOT_VERSION, RobotTarget.SCS, false);
        HumanoidJointNameMap jointMap = model.getJointMap();
        ArmJointName[] joints = jointMap.getArmJointNames();
        FullHumanoidRobotModel robotModel = model.createFullRobotModel();
        boolean showGUIAndSaveSCSVideo = false;
        boolean showCameraVideo = false;
        String[] vars = new String[49];
        int i = 0;
        int jj = 0;
        for (RobotSide side : RobotSide.values()) {
            jj = 0;
            for (ArmJointName joint : joints) {
                String jointName = robotModel.getArmJoint(side, joint).getName();
                vars[i * joints.length * 4 + jj + 1] = "ll_in_" + jointName + "_qd_bef";
                vars[i * joints.length * 4 + ++jj + 1] = "ll_in_" + jointName + "_qd_aft";
                vars[i * joints.length * 4 + ++jj + 1] = "ll_in_" + jointName + "_f";
                vars[i * joints.length * 4 + ++jj + 1] = "ll_in_" + jointName + "_q_bef";
                ++jj;
            }
            ++i;
        }
        File inputParameters = AtlasMultiDataExporter.selectInputFile();
        if (inputParameters == null) {
            System.out.println("Input parameters are not valid");
            return;
        }
        HashTable table = AtlasMultiDataExporter.readInputFile(inputParameters);
        numberOfEntries = (Integer)table.get((Object)"numberOfEntries");
        String[] cameraName = (String[])table.get((Object)"cameraName");
        double[] simulationCameraHeight = (double[])table.get((Object)"simulationCameraHeight");
        double[] simulationCameraRadius = (double[])table.get((Object)"simulationCameraRadius");
        double[] simulationCameraHour = (double[])table.get((Object)"simulationCameraHour");
        String[] outputFileName = (String[])table.get((Object)"outputFileName");
        File[] inFolder = (File[])table.get((Object)"inFolder");
        File[] outFolder = (File[])table.get((Object)"outFolder");
        int[] bufferSize = (int[])table.get((Object)"bufferSize");
        int[] startIndex = (int[])table.get((Object)"startIndex");
        double[] secondOfSimulation = (double[])table.get((Object)"secondOfSimulation");
        String[] timeVariable = (String[])table.get((Object)"timeVariable");
        for (int j = 0; j < numberOfEntries; ++j) {
            AtlasMultiDataExporter exportData;
            vars[0] = timeVariable[j];
            double[] cameraParameters = new double[]{simulationCameraHour[j], simulationCameraRadius[j], simulationCameraHeight[j]};
            String variableGroupName = "selectedVariables";
            AtlasMultiDataExporter atlasMultiDataExporter = exportData = new AtlasMultiDataExporter(model, bufferSize[j], showGUIAndSaveSCSVideo, showCameraVideo, inFolder[j]);
            atlasMultiDataExporter.getClass();
            SimulateAndExport simulateExport = atlasMultiDataExporter.new SimulateAndExport(exportData, startIndex[j], secondOfSimulation[j], cameraName[j], outputFileName[j], outFolder[j], "selectedVariables", vars, timeVariable[j], cameraParameters);
            exportData.setSimulateExport(simulateExport);
            exportData.simulateExport.startSimulation();
            while (!exportData.simulateExport.exportFinish) {
                System.out.println("Export not finished");
                try {
                    Thread.sleep(60000L);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
            System.out.println("Simulation finished");
            simulateExport.closeSCS();
            ThreadTools.sleep((long)2000L);
        }
    }

    private static File selectInputFile() {
        String defaultLogReadingDirectory = System.getProperty("user.home");
        JFileChooser fileChooser = new JFileChooser(new File(defaultLogReadingDirectory));
        File file = null;
        fileChooser.setFileFilter(new FileNameExtensionFilter("TEXT FILES", "txt", "text"));
        fileChooser.setDialogTitle("Select the save parameter file");
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            file = fileChooser.getSelectedFile();
        } else {
            System.err.println("No file selected, closing.");
        }
        return file;
    }

    private static HashTable readInputFile(File input) throws IOException {
        String[] timeVariable;
        double[] secondOfSimulation;
        int[] startIndex;
        int[] bufferSize;
        File[] outFolder;
        File[] inFolder;
        String[] outputFileName;
        double[] simulationCameraHour;
        double[] simulationCameraRadius;
        double[] simulationCameraHeight;
        String[] cameraName;
        int numberOfEntries;
        HashTable exportParameters = new HashTable();
        try {
            String count;
            BufferedReader d = new BufferedReader(new InputStreamReader(new FileInputStream(input)));
            String header = d.readLine();
            if (header == null) {
                System.out.println("Can not read input file!");
                return null;
            }
            numberOfEntries = Integer.parseInt(header.split(",")[11]);
            cameraName = new String[numberOfEntries];
            simulationCameraHeight = new double[numberOfEntries];
            simulationCameraRadius = new double[numberOfEntries];
            simulationCameraHour = new double[numberOfEntries];
            outputFileName = new String[numberOfEntries];
            inFolder = new File[numberOfEntries];
            outFolder = new File[numberOfEntries];
            bufferSize = new int[numberOfEntries];
            startIndex = new int[numberOfEntries];
            secondOfSimulation = new double[numberOfEntries];
            timeVariable = new String[numberOfEntries];
            for (int i = 0; i < numberOfEntries && (count = d.readLine()) != null; ++i) {
                String[] splittedLine = count.split(",");
                cameraName[i] = splittedLine[0];
                simulationCameraHeight[i] = Double.parseDouble(splittedLine[1]);
                simulationCameraRadius[i] = Double.parseDouble(splittedLine[2]);
                simulationCameraHour[i] = Double.parseDouble(splittedLine[3]);
                outputFileName[i] = splittedLine[4];
                inFolder[i] = new File(splittedLine[5]);
                outFolder[i] = new File(splittedLine[6]);
                bufferSize[i] = Integer.parseInt(splittedLine[7]);
                startIndex[i] = Integer.parseInt(splittedLine[8]);
                secondOfSimulation[i] = Double.parseDouble(splittedLine[9]);
                timeVariable[i] = splittedLine[10];
            }
            d.close();
        }
        catch (IOException e) {
            System.out.println("Can not read input file: " + e.getMessage());
            return null;
        }
        exportParameters.put((Object)"cameraName", (Object)cameraName);
        exportParameters.put((Object)"simulationCameraHeight", (Object)simulationCameraHeight);
        exportParameters.put((Object)"simulationCameraRadius", (Object)simulationCameraRadius);
        exportParameters.put((Object)"simulationCameraHour", (Object)simulationCameraHour);
        exportParameters.put((Object)"outputFileName", (Object)outputFileName);
        exportParameters.put((Object)"inFolder", (Object)inFolder);
        exportParameters.put((Object)"outFolder", (Object)outFolder);
        exportParameters.put((Object)"bufferSize", (Object)bufferSize);
        exportParameters.put((Object)"startIndex", (Object)startIndex);
        exportParameters.put((Object)"secondOfSimulation", (Object)secondOfSimulation);
        exportParameters.put((Object)"timeVariable", (Object)timeVariable);
        exportParameters.put((Object)"numberOfEntries", (Object)numberOfEntries);
        return exportParameters;
    }

    private static File selectDirectories() {
        String defaultLogReadingDirectory = System.getProperty("user.home");
        JFileChooser fileChooser = new JFileChooser(new File(defaultLogReadingDirectory));
        File file = null;
        AtlasMultiDataExporter.sortByDateHack(fileChooser);
        fileChooser.setFileSelectionMode(1);
        int returnValue = fileChooser.showOpenDialog(null);
        if (returnValue == 0) {
            file = fileChooser.getSelectedFile();
        } else {
            System.err.println("No file selected, closing.");
        }
        return file;
    }

    private void initialize(DRCRobotModel robotModel, int bufferSize, boolean showGUI, File logFile) throws IOException {
        if (logFile == null) {
            logFile = AtlasMultiDataExporter.selectDirectories();
        }
        if (logFile != null) {
            System.out.println("loading log from folder:" + logFile);
            SimulationConstructionSetParameters parameters = new SimulationConstructionSetParameters();
            parameters.setCreateGUI(showGUI);
            parameters.setDataBufferSize(bufferSize);
            this.scs = new SimulationConstructionSet(parameters);
            this.readLogFile(logFile, robotModel);
        } else {
            this.scs = null;
        }
    }

    private static void sortByDateHack(JFileChooser fileChooser) {
        ActionMap actionMap = fileChooser.getActionMap();
        Action details = actionMap.get("viewTypeDetails");
        if (details != null) {
            details.actionPerformed(null);
            JTable table = (JTable)SwingUtils.getDescendantsOfType(JTable.class, (Container)fileChooser).get(0);
            table.getRowSorter().toggleSortOrder(2);
            table.getRowSorter().toggleSortOrder(2);
        } else {
            System.err.println("sort by datetime doesn't work known on OSX ... bail out");
        }
    }

    private void readLogFile(File selectedFile, DRCRobotModel robotModel) throws IOException {
        LogPropertiesReader logProperties = new LogPropertiesReader(new File(selectedFile, "robotData.log"));
        File handshake = new File(selectedFile, logProperties.getVariables().getHandshakeAsString());
        if (!handshake.exists()) {
            throw new RuntimeException("Cannot find " + logProperties.getVariables().getHandshakeAsString());
        }
        DataInputStream handshakeStream = new DataInputStream(new FileInputStream(handshake));
        byte[] handshakeData = new byte[(int)handshake.length()];
        handshakeStream.readFully(handshakeData);
        handshakeStream.close();
        this.parser = YoVariableHandshakeParser.create((HandshakeFileType)logProperties.getVariables().getHandshakeFileType());
        this.parser.parseFrom(handshakeData);
        RobotDescription robotDescription = robotModel.getRobotDescription();
        this.robot = new YoVariableLogPlaybackRobot(selectedFile, robotDescription, this.parser.getJointStates(), this.parser.getYoVariablesList(), logProperties, this.scs);
        double dt = this.parser.getDt();
        System.out.println(this.getClass().getSimpleName() + ": dt set to " + dt);
        this.scs.setDT(dt, 1);
        this.scs.setPlaybackDesiredFrameRate(0.04);
        YoGraphicsListRegistry yoGraphicsListRegistry = this.parser.getYoGraphicsListRegistry();
        this.scs.addYoGraphicsListRegistry(yoGraphicsListRegistry);
        this.scs.getRootRegistry().addChild(this.parser.getRootRegistry());
        this.scs.setGroundVisible(false);
        try {
            this.players = new MultiVideoDataPlayer(selectedFile, (LogProperties)logProperties, this.robot.getTimestamp());
            if (!this.showCameraVideo) {
                this.players.setActivePlayer(null);
            }
            this.scs.attachPlaybackListener((PlaybackListener)this.players);
            this.scs.attachSimulationRewoundListener((RewoundListener)this.players);
        }
        catch (Exception e) {
            System.err.println("Couldn't load video file!");
            e.printStackTrace();
        }
        this.scs.hideAllYoGraphics();
        this.scs.setYoGraphicsListVisible("DesiredExternalWrench", true);
    }

    public void setSimulateExport(SimulateAndExport simulateExport) {
        this.simulateExport = simulateExport;
    }

    public void simulationDone() {
        System.out.println("Simulation done!");
        this.simulateExport.exportDataAndVideo();
    }

    public void simulationDoneWithException(Throwable throwable) {
        this.simulationDone();
    }

    private class SimulateAndExport {
        AtlasMultiDataExporter exportData;
        int inPointIndex;
        double secondsOfSimulation;
        String variableGroupName;
        String[] vars;
        String cameraName;
        String fileName;
        String savePath;
        String timeVariable;
        double[] cameraParameters;
        boolean exportFinish;

        public SimulateAndExport(AtlasMultiDataExporter exportData, int inPointIndex, double secondsOfSimulation, String cameraName, String fileName, File outFolder, String variableGroupName, String[] vars, String timeVariable, double[] cameraParameters) {
            if (outFolder == null) {
                outFolder = AtlasMultiDataExporter.selectDirectories();
            }
            this.exportFinish = false;
            this.exportData = exportData;
            this.inPointIndex = inPointIndex;
            this.secondsOfSimulation = secondsOfSimulation;
            this.variableGroupName = variableGroupName;
            this.vars = vars;
            this.cameraName = cameraName;
            this.fileName = fileName;
            this.savePath = outFolder.getPath();
            this.timeVariable = timeVariable;
            this.cameraParameters = cameraParameters;
        }

        private void startSimulation() {
            this.exportData.simulation.start();
            this.exportData.scs.setupVarGroup(this.variableGroupName, this.vars);
            this.gotoPoint(this.inPointIndex, this.exportData);
            this.exportData.scs.setInPoint();
            this.setCamera(this.exportData, this.cameraParameters);
            this.exportData.scs.simulate(this.secondsOfSimulation);
            this.exportData.scs.addSimulateDoneListener((SimulationDoneListener)this.exportData);
        }

        private void closeSCS() {
            ThreadTools.sleep((long)2000L);
            AtlasMultiDataExporter.this.scs.closeAndDispose();
            AtlasMultiDataExporter.this.scs = null;
        }

        private void exportDataAndVideo() {
            this.exportData.scs.setOutPoint();
            this.exportData.scs.cropBuffer();
            if (this.exportData.exportSCSVideo) {
                this.exportData.scs.createVideo(this.savePath + File.separator + this.fileName + "SCS");
            }
            this.switchVideoUpdate(this.exportData, this.cameraName);
            this.exportVideo(this.exportData, this.savePath, this.fileName + this.cameraName);
            File dataFile = new File(this.savePath + File.separator + this.fileName + ".csv");
            this.writeSpreadsheetFormattedData(dataFile, this.timeVariable);
            this.exportData.scs.closeAndDispose();
            this.exportData.simulation = null;
        }

        private void setCamera(AtlasMultiDataExporter exportM3Data, double[] cameraParameters) {
            double hour = cameraParameters[0];
            double radius = cameraParameters[1];
            double height = cameraParameters[2];
            RigidBodyTransform ret = new RigidBodyTransform();
            Vector3D cameraFix = new Vector3D();
            double angle = 1.5707963267948966 + hour * Math.PI / 6.0;
            Vector3D cameraPosition = new Vector3D(radius * Math.sin(angle), radius * Math.cos(angle), height);
            Robot[] robot = exportM3Data.scs.getRobots();
            List joint = robot[0].getRootJoints();
            ((Joint)joint.get(0)).getTransformToWorld((RigidBodyTransformBasics)ret);
            ret.transform((Vector3DBasics)cameraPosition);
            cameraFix.set((Tuple3DReadOnly)ret.getTranslation());
            CameraConfiguration cameraConfiguration = new CameraConfiguration("testCamera");
            cameraConfiguration.setCameraFix((Tuple3DBasics)cameraFix);
            cameraConfiguration.setCameraPosition((Tuple3DBasics)cameraPosition);
            cameraConfiguration.setCameraTracking(true, true, true, false);
            exportM3Data.scs.setupCamera(cameraConfiguration);
            exportM3Data.scs.selectCamera("testCamera");
        }

        private void gotoPoint(int newValue, AtlasMultiDataExporter exportM3Data) {
            if (!exportM3Data.scs.isSimulating()) {
                exportM3Data.robot.seek(newValue);
                try {
                    exportM3Data.scs.simulateOneRecordStepNow();
                    exportM3Data.scs.setInPoint();
                }
                catch (UnreasonableAccelerationException e) {
                    e.printStackTrace();
                }
                exportM3Data.players.indexChanged(0);
            }
        }

        private void writeSpreadsheetFormattedData(File chosenFile, String timeVariable) {
            PrintTools.info((Object)this, (String)("Writing Data File " + chosenFile.getAbsolutePath()));
            YoBuffer dataBuffer = this.exportData.scs.getDataBuffer();
            List varsYo = Stream.of(this.vars).map(varName -> this.exportData.scs.findVariable(varName)).collect(Collectors.toList());
            this.writeSpreadsheetFormattedData(chosenFile, dataBuffer, varsYo, timeVariable);
        }

        private void exportVideo(final AtlasMultiDataExporter exportM3Data, String savePath, String fileName) {
            if (exportM3Data.players != null) {
                long[] timestamps = this.getInAndOut(exportM3Data);
                if (timestamps.length != 2) {
                    return;
                }
                final long startTimestamp = timestamps[0];
                final long endTimestamp = timestamps[1];
                final File selectedFile = new File(savePath + File.separator + fileName + ".mov");
                new Thread(){

                    @Override
                    public void run() {
                        exportM3Data.players.exportCurrentVideo(selectedFile, startTimestamp, endTimestamp);
                    }
                }.start();
            }
        }

        private void switchVideoUpdate(AtlasMultiDataExporter exportM3Data, String videoName) {
            if (exportM3Data.players != null) {
                if (videoName.equals("none") || !AtlasMultiDataExporter.this.showCameraVideo) {
                    exportM3Data.players.setActivePlayer(null);
                } else {
                    exportM3Data.players.setActivePlayer(videoName);
                }
            }
        }

        private void writeSpreadsheetFormattedData(File chosenFile, YoBuffer dataBuffer, List<? extends YoVariable> vars, String timeVariable) {
            List entries = dataBuffer.getEntries();
            try {
                int i;
                PrintStream printStream = new PrintStream(new BufferedOutputStream(new FileOutputStream(chosenFile)));
                int bufferLength = dataBuffer.getBufferInOutLength();
                String[] varnamesToWrite = new String[vars.size()];
                double[][] dataToWrite = new double[vars.size()][];
                for (i = 0; i < entries.size(); ++i) {
                    YoBufferVariableEntry entry = (YoBufferVariableEntry)entries.get(i);
                    YoVariable variable = entry.getVariable();
                    entry.getBuffer();
                    if (!vars.contains(variable)) continue;
                    varnamesToWrite[vars.indexOf((Object)variable)] = entry.getVariable().getName();
                    double[] allData = entry.getBuffer();
                    double[] data = this.getWindowedData(dataBuffer.getInPoint(), allData, bufferLength);
                    if (entry.getVariable().getName().equals(timeVariable)) {
                        double initialTime = data[0];
                        int j = 0;
                        while (j < data.length) {
                            int n = j++;
                            data[n] = data[n] - initialTime;
                        }
                    }
                    dataToWrite[vars.indexOf((Object)variable)] = data;
                }
                for (i = 0; i < varnamesToWrite.length; ++i) {
                    printStream.print(varnamesToWrite[i]);
                    if (i < varnamesToWrite.length - 1) {
                        printStream.print(",");
                        continue;
                    }
                    printStream.println("");
                }
                for (int j = 0; j < bufferLength; ++j) {
                    for (int i2 = 0; i2 < dataToWrite.length; ++i2) {
                        double[] data = dataToWrite[i2];
                        printStream.print(data[j]);
                        if (i2 < dataToWrite.length - 1) {
                            printStream.print(",");
                            continue;
                        }
                        printStream.println("");
                    }
                }
                printStream.close();
                this.exportFinish = true;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }

        private long[] getInAndOut(AtlasMultiDataExporter exportM3Data) {
            if (exportM3Data.scs.isSimulating()) {
                exportM3Data.scs.stop();
            }
            exportM3Data.scs.gotoInPointNow();
            long startTimestamp = exportM3Data.players.getCurrentTimestamp();
            exportM3Data.scs.gotoOutPointNow();
            long endTimestamp = exportM3Data.players.getCurrentTimestamp();
            if (startTimestamp > endTimestamp) {
                JOptionPane.showMessageDialog(null, "startTimestamp > endTimestamp. Please set the in-point and out-point correctly", "Timestmap error", 0);
                return new long[0];
            }
            return new long[]{startTimestamp, endTimestamp};
        }

        private double[] getWindowedData(int in, double[] allData, int bufferLength) {
            double[] ret = new double[bufferLength];
            int n = in;
            for (int i = 0; i < bufferLength; ++i) {
                ret[i] = allData[n];
                if (++n < allData.length) continue;
                n = 0;
            }
            return ret;
        }
    }
}

