/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import com.jme3.math.Transform;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.parameters.AtlasPhysicalProperties;
import us.ihmc.atlas.parameters.AtlasUIFootstepGeneratorParameters;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.humanoidRobotics.footstep.footstepGenerator.UIFootstepGeneratorParameters;
import us.ihmc.jMonkeyEngineToolkit.jme.util.JMEDataTypeUtils;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.wholeBodyController.UIParameters;

public class AtlasUIParameters
implements UIParameters {
    private final double spineYawLimit = 0.7853981633974483;
    private final double spinePitchUpperLimit = 0.4;
    private final double spinePitchLowerLimit = -0.1;
    private final double spineRollLimit = 0.7853981633974483;
    private final AtlasPhysicalProperties physicalProperties;
    private final AtlasRobotVersion selectedVersion;

    public AtlasUIParameters(AtlasRobotVersion selectedVersion, AtlasPhysicalProperties physicalProperties) {
        this.selectedVersion = selectedVersion;
        this.physicalProperties = physicalProperties;
    }

    public double pelvisToAnkleThresholdForWalking() {
        return 0.623;
    }

    public double getSideLengthOfBoundingBoxForFootstepHeight() {
        return 2.6 * Math.sqrt(this.physicalProperties.getFootForwardForControl() * this.physicalProperties.getFootForwardForControl() + 0.25 * this.physicalProperties.getFootWidthForControl() * this.physicalProperties.getFootWidthForControl());
    }

    public double getSpineYawLimit() {
        return 0.7853981633974483;
    }

    public double getSpinePitchUpperLimit() {
        return 0.4;
    }

    public double getSpinePitchLowerLimit() {
        return -0.1;
    }

    public double getSpineRollLimit() {
        return 0.7853981633974483;
    }

    public boolean isSpinePitchReversed() {
        return false;
    }

    public double getAnkleHeight() {
        return Math.abs(((RigidBodyTransform)this.physicalProperties.getSoleToAnkleFrameTransforms().get((Enum)RobotSide.LEFT)).getTranslationZ());
    }

    public Transform getJmeTransformWristToHand(RobotSide side) {
        RigidBodyTransform attachmentPlateToPalm = this.selectedVersion.getOffsetFromAttachmentPlate(side);
        Transform jmeAttachmentPlateToPalm = JMEDataTypeUtils.j3dTransform3DToJMETransform((RigidBodyTransformReadOnly)attachmentPlateToPalm);
        return jmeAttachmentPlateToPalm;
    }

    public UIFootstepGeneratorParameters getUIFootstepGeneratorParameters() {
        return new AtlasUIFootstepGeneratorParameters();
    }
}

