/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.commonWalkingControlModules.configurations.GroupParameter;
import us.ihmc.commonWalkingControlModules.momentumBasedController.optimization.MomentumOptimizationSettings;
import us.ihmc.euclid.tuple2D.Vector2D;
import us.ihmc.euclid.tuple3D.interfaces.Vector3DReadOnly;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.SpineJointName;

public class AtlasMomentumOptimizationSettings
extends MomentumOptimizationSettings {
    private static final double defaultRhoWeight = 1.0E-5;
    private static final double defaultRhoMin = 4.0;
    private static final double defaultRhoRateDefaultWeight = 3.2E-8;
    private static final double defaultRhoRateHighWeight = 8.0E-7;
    private static final boolean useWarmStartInSolver = true;
    private static final boolean disableRhosWhenNotInContact = true;
    private final int nBasisVectorsPerContactPoint = 4;
    private final int nContactPointsPerContactableBody = 4;
    private final int nContactableBodies;
    private final double jointAccelerationWeight = 0.005;
    private final double jointJerkWeight = 1.6E-6;
    private final double jointTorqueWeight = 0.005;
    private final Vector2D copWeight = new Vector2D(0.001, 0.002);
    private final Vector2D copRateDefaultWeight = new Vector2D(3.2E-7, 3.2E-7);
    private final Vector2D copRateHighWeight = new Vector2D(4.0E-5, 1.6E-4);
    private final double rhoWeight;
    private final double rhoMin;
    private final double rhoRateDefaultWeight;
    private final double rhoRateHighWeight;
    private final List<GroupParameter<Double>> jointspaceWeightGroups = new ArrayList<GroupParameter<Double>>();
    private final List<GroupParameter<Double>> userModeWeightGroups = new ArrayList<GroupParameter<Double>>();
    private final List<GroupParameter<Vector3DReadOnly>> taskspaceAngularWeightGroups = new ArrayList<GroupParameter<Vector3DReadOnly>>();
    private final List<GroupParameter<Vector3DReadOnly>> taskspaceLinearWeightGroups = new ArrayList<GroupParameter<Vector3DReadOnly>>();

    public AtlasMomentumOptimizationSettings(HumanoidJointNameMap jointMap, int numberOfContactableBodies) {
        double scale = Math.pow(jointMap.getModelScale(), jointMap.getMassScalePower());
        this.rhoWeight = 1.0E-5 / scale;
        this.rhoMin = 4.0 * scale;
        this.rhoRateDefaultWeight = 3.2E-8 / (scale * scale);
        this.rhoRateHighWeight = 8.0E-7 / (scale * scale);
        this.userModeWeightGroups.add((GroupParameter<Double>)new GroupParameter("Spine", jointMap.getSpineJointNamesAsStrings()));
        this.jointspaceWeightGroups.add((GroupParameter<Double>)new GroupParameter(SpineJointName.SPINE_YAW.toString(), jointMap.getSpineJointName(SpineJointName.SPINE_YAW)));
        this.jointspaceWeightGroups.add((GroupParameter<Double>)new GroupParameter(SpineJointName.SPINE_PITCH.toString(), jointMap.getSpineJointName(SpineJointName.SPINE_PITCH)));
        this.jointspaceWeightGroups.add((GroupParameter<Double>)new GroupParameter(SpineJointName.SPINE_ROLL.toString(), jointMap.getSpineJointName(SpineJointName.SPINE_ROLL)));
        this.jointspaceWeightGroups.add((GroupParameter<Double>)new GroupParameter("Arms", jointMap.getArmJointNamesAsStrings()));
        this.userModeWeightGroups.add((GroupParameter<Double>)new GroupParameter("Arms", jointMap.getArmJointNamesAsStrings()));
        this.jointspaceWeightGroups.add((GroupParameter<Double>)new GroupParameter("Neck", jointMap.getNeckJointNamesAsStrings()));
        this.userModeWeightGroups.add((GroupParameter<Double>)new GroupParameter("Neck", jointMap.getNeckJointNamesAsStrings()));
        this.taskspaceAngularWeightGroups.add((GroupParameter<Vector3DReadOnly>)new GroupParameter("Chest", jointMap.getChestName()));
        this.taskspaceAngularWeightGroups.add((GroupParameter<Vector3DReadOnly>)new GroupParameter("Head", jointMap.getHeadName()));
        this.taskspaceAngularWeightGroups.add((GroupParameter<Vector3DReadOnly>)new GroupParameter("Pelvis", jointMap.getPelvisName()));
        this.taskspaceLinearWeightGroups.add((GroupParameter<Vector3DReadOnly>)new GroupParameter("Pelvis", jointMap.getPelvisName()));
        List handNames = jointMap.getHandNames();
        List footNames = jointMap.getFootNames();
        this.taskspaceAngularWeightGroups.add((GroupParameter<Vector3DReadOnly>)new GroupParameter("Hand", handNames));
        this.taskspaceLinearWeightGroups.add((GroupParameter<Vector3DReadOnly>)new GroupParameter("Hand", handNames));
        this.taskspaceAngularWeightGroups.add((GroupParameter<Vector3DReadOnly>)new GroupParameter("Foot", footNames));
        this.taskspaceLinearWeightGroups.add((GroupParameter<Vector3DReadOnly>)new GroupParameter("Foot", footNames));
        this.nContactableBodies = numberOfContactableBodies;
    }

    public double getJointAccelerationWeight() {
        return 0.005;
    }

    public double getJointJerkWeight() {
        return 1.6E-6;
    }

    public double getJointTorqueWeight() {
        return 0.005;
    }

    public double getRhoWeight() {
        return this.rhoWeight;
    }

    public double getRhoMin() {
        return this.rhoMin;
    }

    public double getRhoRateDefaultWeight() {
        return this.rhoRateDefaultWeight;
    }

    public double getRhoRateHighWeight() {
        return this.rhoRateHighWeight;
    }

    public Vector2D getCoPWeight() {
        return this.copWeight;
    }

    public Vector2D getCoPRateDefaultWeight() {
        return this.copRateDefaultWeight;
    }

    public Vector2D getCoPRateHighWeight() {
        return this.copRateHighWeight;
    }

    public int getNumberOfBasisVectorsPerContactPoint() {
        return 4;
    }

    public int getNumberOfContactPointsPerContactableBody() {
        return 4;
    }

    public int getNumberOfContactableBodies() {
        return this.nContactableBodies;
    }

    public List<GroupParameter<Double>> getJointspaceWeights() {
        return this.jointspaceWeightGroups;
    }

    public List<GroupParameter<Double>> getUserModeWeights() {
        return this.userModeWeightGroups;
    }

    public List<GroupParameter<Vector3DReadOnly>> getTaskspaceAngularWeights() {
        return this.taskspaceAngularWeightGroups;
    }

    public List<GroupParameter<Vector3DReadOnly>> getTaskspaceLinearWeights() {
        return this.taskspaceLinearWeightGroups;
    }

    public boolean useWarmStartInSolver() {
        return true;
    }

    public boolean getDeactivateRhoWhenNotInContact() {
        return true;
    }
}

