/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import us.ihmc.commonWalkingControlModules.configurations.LegConfigurationParameters;
import us.ihmc.commonWalkingControlModules.controlModules.legConfiguration.LegConfigurationGains;

public class AtlasLegConfigurationParameters
extends LegConfigurationParameters {
    private final boolean runningOnRealRobot;

    public AtlasLegConfigurationParameters(boolean runningOnRealRobot) {
        this.runningOnRealRobot = runningOnRealRobot;
    }

    public boolean attemptToStraightenLegs() {
        return false;
    }

    public LegConfigurationGains getBentLegGains() {
        LegConfigurationGains gains = new LegConfigurationGains();
        gains.setJointSpaceKp(this.runningOnRealRobot ? 40.0 : 150.0);
        gains.setJointSpaceKd(6.0);
        return gains;
    }

    public LegConfigurationGains getStraightLegGains() {
        LegConfigurationGains gains = new LegConfigurationGains();
        gains.setActuatorSpaceKp(750.0);
        gains.setJointSpaceKd(this.runningOnRealRobot ? 3.0 : 10.0);
        return gains;
    }

    public double getLegPrivilegedHighWeight() {
        return this.runningOnRealRobot ? 50.0 : 100.0;
    }

    public double getFractionOfSwingToStraightenLeg() {
        return this.runningOnRealRobot ? 0.6 : 0.4;
    }

    public double getKneeAngleWhenExtended() {
        return this.runningOnRealRobot ? 0.2 : 0.0;
    }

    public double getKneeAngleWhenStraight() {
        return this.runningOnRealRobot ? 0.35 : 0.25;
    }
}

