/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGains;
import us.ihmc.commonWalkingControlModules.capturePoint.ICPControlGainsReadOnly;
import us.ihmc.commonWalkingControlModules.capturePoint.optimization.ICPOptimizationParameters;

public class AtlasICPOptimizationParameters
extends ICPOptimizationParameters {
    private final boolean runningOnRealRobot;
    private final boolean useAngularMomentum = true;
    private final boolean useStepAdjustment = true;

    public AtlasICPOptimizationParameters(boolean runningOnRealRobot) {
        this.runningOnRealRobot = runningOnRealRobot;
    }

    public double getForwardFootstepWeight() {
        return this.runningOnRealRobot ? 20.0 : 20.0;
    }

    public double getLateralFootstepWeight() {
        return this.runningOnRealRobot ? 20.0 : 20.0;
    }

    public double getFootstepRateWeight() {
        return this.runningOnRealRobot ? 4.0E-9 : 4.0E-7;
    }

    public double getFeedbackLateralWeight() {
        return this.runningOnRealRobot ? 1.5 : 1.5;
    }

    public double getFeedbackForwardWeight() {
        return this.runningOnRealRobot ? 1.5 : 1.5;
    }

    public double getFeedbackRateWeight() {
        return 5.0E-8;
    }

    public double getCoPCMPFeedbackRateWeight() {
        return 0.0;
    }

    public ICPControlGainsReadOnly getICPFeedbackGains() {
        ICPControlGains gains = new ICPControlGains();
        gains.setKpOrthogonalToMotion(2.0);
        gains.setKpParallelToMotion(2.5);
        gains.setIntegralLeakRatio(0.97);
        gains.setMaxIntegralError(0.05);
        gains.setKi(1.0);
        return gains;
    }

    public double getDynamicsObjectiveWeight() {
        return 10000.0;
    }

    public double getDynamicsObjectiveDoubleSupportWeightModifier() {
        return 1.0;
    }

    public double getAngularMomentumMinimizationWeight() {
        return 10.0;
    }

    public boolean scaleStepRateWeightWithTime() {
        return false;
    }

    public boolean scaleFeedbackWeightWithGain() {
        return true;
    }

    public boolean useFeedbackRate() {
        return true;
    }

    public boolean allowStepAdjustment() {
        return true;
    }

    public boolean useAngularMomentum() {
        return true;
    }

    public double getSafeCoPDistanceToEdge() {
        return 0.001;
    }

    public boolean useFootstepRate() {
        return true;
    }

    public double getMinimumTimeRemaining() {
        return 1.0E-4;
    }

    public double getAdjustmentDeadband() {
        return 0.02;
    }

    public double getFeedbackDirectionWeight() {
        return 1000000.0;
    }

    public boolean getLimitReachabilityFromAdjustment() {
        return false;
    }

    public double getTransferSplitFraction() {
        return 0.2;
    }

    public double getMinimumFootstepMultiplier() {
        return 0.25;
    }

    public boolean useSmartICPIntegrator() {
        return true;
    }
}

