/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.euclid.geometry.LineSegment2D;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple2D.Point2D;
import us.ihmc.euclid.tuple2D.interfaces.Point2DReadOnly;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DBasics;
import us.ihmc.euclid.tuple2D.interfaces.Tuple2DReadOnly;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.partNames.LeggedJointNameMap;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SegmentDependentList;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.robotiq.model.RobotiqHandModel;
import us.ihmc.simulationconstructionset.util.LinearGroundContactModel;
import us.ihmc.wholeBodyController.DRCHandType;
import us.ihmc.wholeBodyController.FootContactPoints;
import us.ihmc.wholeBodyController.RobotContactPointParameters;

public class AtlasContactPointParameters
extends RobotContactPointParameters<RobotSide> {
    public static final boolean USE_SIX_CONTACT_POINTS = false;
    private final int numberOfContactableBodies;
    private boolean handContactPointsHaveBeenCreated = false;
    private final AtlasJointMap jointMap;
    private final AtlasRobotVersion atlasVersion;
    private boolean useSoftGroundContactParameters = false;

    public AtlasContactPointParameters(AtlasJointMap jointMap, AtlasRobotVersion atlasVersion, boolean createFootContactPoints, FootContactPoints<RobotSide> footContactPoints, boolean createAdditionalContactPoints) {
        super((LeggedJointNameMap)jointMap, jointMap.getPhysicalProperties().getToeWidthForControl(), jointMap.getPhysicalProperties().getFootWidthForControl(), jointMap.getPhysicalProperties().getFootLengthForControl(), (SegmentDependentList)jointMap.getPhysicalProperties().getSoleToAnkleFrameTransforms());
        this.jointMap = jointMap;
        this.atlasVersion = atlasVersion;
        if (createFootContactPoints) {
            if (footContactPoints != null) {
                this.createFootContactPoints(footContactPoints);
            } else {
                this.createDefaultFootContactPoints();
            }
        }
        int totalContacts = 2;
        if (createAdditionalContactPoints) {
            totalContacts += this.createAdditionalHandContactPoints();
        }
        this.numberOfContactableBodies = totalContacts;
    }

    public int createAdditionalHandContactPoints() {
        switch (this.atlasVersion) {
            case ATLAS_UNPLUGGED_V5_NO_HANDS: {
                this.createHandKnobContactPoints();
                return 2;
            }
            case ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ: {
                if (DRCHandType.ROBOTIQ.isHandSimulated()) {
                    for (RobotSide robotSide : RobotSide.values) {
                        this.createRobotiqHandContactPoints(robotSide, false);
                    }
                }
                return 2;
            }
        }
        return 0;
    }

    private void addAdditionalContactPoint(String bodyName, String contactName, RigidBodyTransform transformToContactFrame) {
        this.additionalContactRigidBodyNames.add(bodyName);
        this.additionalContactNames.add(contactName);
        this.additionalContactTransforms.add(transformToContactFrame);
    }

    private void createHandKnobContactPoints() {
        if (this.handContactPointsHaveBeenCreated) {
            throw new RuntimeException("Contact points for the hands have already been created");
        }
        this.handContactPointsHaveBeenCreated = true;
        SideDependentList<String> nameOfJointBeforeHands = this.jointMap.getNameOfJointBeforeHands();
        for (RobotSide robotSide : RobotSide.values) {
            String bodyName = this.jointMap.getHandName(robotSide);
            Point3D pointLocationInParentJoint = new Point3D(0.0, robotSide.negateIfRightSide(0.13), 0.0);
            RigidBodyTransform transformToContactFrame = new RigidBodyTransform((Orientation3DReadOnly)new Quaternion(), (Tuple3DReadOnly)pointLocationInParentJoint);
            if (robotSide == RobotSide.LEFT) {
                transformToContactFrame.appendRollRotation(Math.PI);
            }
            this.addSimulationContactPoint((String)nameOfJointBeforeHands.get((Enum)robotSide), (Tuple3DBasics)pointLocationInParentJoint);
            this.addAdditionalContactPoint(bodyName, bodyName + "Contact", transformToContactFrame);
        }
    }

    private void createRobotiqHandContactPoints(RobotSide robotSide, boolean areHandsFlipped) {
        String nameOfJointBeforeHand = (String)this.jointMap.getNameOfJointBeforeHands().get((Enum)robotSide);
        String finger_1_joint_1 = RobotiqHandModel.RobotiqHandJointNameMinimal.FINGER_1_JOINT_1.getJointName(robotSide);
        String finger_1_joint_2 = RobotiqHandModel.RobotiqHandJointNameMinimal.FINGER_1_JOINT_2.getJointName(robotSide);
        String finger_1_joint_3 = RobotiqHandModel.RobotiqHandJointNameMinimal.FINGER_1_JOINT_3.getJointName(robotSide);
        String finger_2_joint_1 = RobotiqHandModel.RobotiqHandJointNameMinimal.FINGER_2_JOINT_1.getJointName(robotSide);
        String finger_2_joint_2 = RobotiqHandModel.RobotiqHandJointNameMinimal.FINGER_2_JOINT_2.getJointName(robotSide);
        String finger_2_joint_3 = RobotiqHandModel.RobotiqHandJointNameMinimal.FINGER_2_JOINT_3.getJointName(robotSide);
        String thumb_joint_1 = RobotiqHandModel.RobotiqHandJointNameMinimal.FINGER_MIDDLE_JOINT_1.getJointName(robotSide);
        String thumb_joint_2 = RobotiqHandModel.RobotiqHandJointNameMinimal.FINGER_MIDDLE_JOINT_2.getJointName(robotSide);
        String thumb_joint_3 = RobotiqHandModel.RobotiqHandJointNameMinimal.FINGER_MIDDLE_JOINT_3.getJointName(robotSide);
        this.createRobotiqHandPalmContactPoints(robotSide, nameOfJointBeforeHand, areHandsFlipped);
        double plusOrMinusY = robotSide.negateIfRightSide(1.0);
        double plusOrMinusZ = 1.0;
        if (areHandsFlipped) {
            plusOrMinusZ = robotSide.negateIfRightSide(1.0);
        }
        Vector3D thumbJoint1ContactPoint = new Vector3D(0.0, plusOrMinusY * 0.033, plusOrMinusZ * 0.0105);
        Vector3D thumbJoint2ContactPoint1 = new Vector3D(0.0, plusOrMinusY * 0.005, plusOrMinusZ * -0.005);
        Vector3D thumbJoint2ContactPoint2 = new Vector3D(0.0, plusOrMinusY * 0.027, plusOrMinusZ * 0.007);
        Vector3D thumbJoint3ContactPoint = new Vector3D(0.0, plusOrMinusY * 0.025, plusOrMinusZ * -0.006);
        Vector3D fingersJoint1ContactPoint = new Vector3D(0.0, plusOrMinusY * 0.032, plusOrMinusZ * -0.011);
        Vector3D fingersJoint2ContactPoint1 = new Vector3D(0.0, thumbJoint2ContactPoint1.getY(), -thumbJoint2ContactPoint1.getZ());
        Vector3D fingersJoint2ContactPoint2 = new Vector3D(0.0, thumbJoint2ContactPoint2.getY(), -thumbJoint2ContactPoint2.getZ());
        Vector3D fingersJoint3ContactPoint = new Vector3D(0.0, thumbJoint3ContactPoint.getY(), -thumbJoint3ContactPoint.getZ());
        this.addSimulationContactPoint(finger_1_joint_1, (Tuple3DBasics)fingersJoint1ContactPoint);
        this.addSimulationContactPoint(finger_1_joint_2, (Tuple3DBasics)fingersJoint2ContactPoint1);
        this.addSimulationContactPoint(finger_1_joint_2, (Tuple3DBasics)fingersJoint2ContactPoint2);
        this.addSimulationContactPoint(finger_1_joint_3, (Tuple3DBasics)fingersJoint3ContactPoint);
        this.addSimulationContactPoint(finger_2_joint_1, (Tuple3DBasics)fingersJoint1ContactPoint);
        this.addSimulationContactPoint(finger_2_joint_2, (Tuple3DBasics)fingersJoint2ContactPoint1);
        this.addSimulationContactPoint(finger_2_joint_2, (Tuple3DBasics)fingersJoint2ContactPoint2);
        this.addSimulationContactPoint(finger_2_joint_3, (Tuple3DBasics)fingersJoint3ContactPoint);
        this.addSimulationContactPoint(thumb_joint_1, (Tuple3DBasics)thumbJoint1ContactPoint);
        this.addSimulationContactPoint(thumb_joint_2, (Tuple3DBasics)thumbJoint2ContactPoint1);
        this.addSimulationContactPoint(thumb_joint_2, (Tuple3DBasics)thumbJoint2ContactPoint2);
        this.addSimulationContactPoint(thumb_joint_3, (Tuple3DBasics)thumbJoint3ContactPoint);
    }

    private void createRobotiqHandPalmContactPoints(RobotSide robotSide, String nameOfJointBeforeHand, boolean areHandsFlipped) {
        double offsetFromWristToPalmPlane = 0.22;
        Point3D palmCenter = new Point3D(-0.002, robotSide.negateIfRightSide(offsetFromWristToPalmPlane), 0.0);
        double palmWidth = 0.07;
        double palmHeight = 0.075;
        if (areHandsFlipped) {
            palmHeight = robotSide.negateIfLeftSide(palmHeight);
        }
        Vector3D palmContactPoint1 = new Vector3D(palmCenter.getX() - palmWidth / 2.0, palmCenter.getY(), palmCenter.getZ());
        Vector3D palmContactPoint1b = new Vector3D(palmCenter.getX() - palmWidth / 4.0, palmCenter.getY(), palmCenter.getZ());
        Vector3D palmContactPointCenter = new Vector3D(palmCenter.getX(), palmCenter.getY(), palmCenter.getZ());
        Vector3D palmContactPoint2b = new Vector3D(palmCenter.getX() + palmWidth / 4.0, palmCenter.getY(), palmCenter.getZ());
        Vector3D palmContactPoint3 = new Vector3D(palmCenter.getX() + palmWidth / 2.0, palmCenter.getY(), palmCenter.getZ());
        Vector3D palmContactPoint4 = new Vector3D(palmCenter.getX(), palmCenter.getY(), palmCenter.getZ() - palmHeight / 2.0);
        Vector3D palmContactPoint4b = new Vector3D(palmCenter.getX(), palmCenter.getY(), palmCenter.getZ() - palmHeight / 4.0);
        Vector3D palmContactPoint5 = new Vector3D(palmContactPoint3.getX(), palmCenter.getY(), palmCenter.getZ() + palmHeight / 2.0);
        Vector3D palmContactPoint5b = new Vector3D(palmContactPoint3.getX(), palmCenter.getY(), palmCenter.getZ() + palmHeight / 4.0);
        Vector3D palmContactPoint6 = new Vector3D(palmContactPoint1.getX(), palmCenter.getY(), palmContactPoint5.getZ());
        Vector3D palmContactPoint6b = new Vector3D(palmContactPoint1.getX(), palmCenter.getY(), palmContactPoint5b.getZ());
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPointCenter);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint1);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint3);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint4);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint5);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint6);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint1b);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint2b);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint4b);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint5b);
        this.addSimulationContactPoint(nameOfJointBeforeHand, (Tuple3DBasics)palmContactPoint6b);
    }

    public void setupGroundContactModelParameters(LinearGroundContactModel linearGroundContactModel) {
        double scale = Math.pow(this.jointMap.getModelScale(), this.jointMap.getMassScalePower());
        if (this.useSoftGroundContactParameters) {
            linearGroundContactModel.setZStiffness(scale * 4000.0);
            linearGroundContactModel.setZDamping(scale * 750.0);
            linearGroundContactModel.setXYStiffness(scale * 50000.0);
            linearGroundContactModel.setXYDamping(scale * 1000.0);
        } else {
            linearGroundContactModel.setZStiffness(scale * 2000.0);
            linearGroundContactModel.setZDamping(scale * 1500.0);
            linearGroundContactModel.setXYStiffness(scale * 50000.0);
            linearGroundContactModel.setXYDamping(scale * 2000.0);
        }
    }

    public int getNumberOfContactableBodies() {
        return this.numberOfContactableBodies;
    }

    private class AtlasSixContactFoot
    implements FootContactPoints<RobotSide> {
        private AtlasSixContactFoot() {
        }

        public Map<String, List<Tuple3DBasics>> getSimulationContactPoints(double footLength, double footWidth, double toeWidth, LeggedJointNameMap<RobotSide> jointMap, SegmentDependentList<RobotSide, RigidBodyTransform> soleToAnkleFrameTransforms) {
            HashMap<String, List<Tuple3DBasics>> ret = new HashMap<String, List<Tuple3DBasics>>();
            for (RobotSide robotSide : RobotSide.values) {
                ArrayList<Point3D> footContactPoints = new ArrayList<Point3D>();
                String parentJointName = jointMap.getJointBeforeFootName((Enum)robotSide);
                RigidBodyTransform transformToParentJointFrame = (RigidBodyTransform)soleToAnkleFrameTransforms.get((Enum)robotSide);
                Point3D hindLeftContactPoint = new Point3D(-footLength / 2.0, footWidth / 2.0, 0.0);
                transformToParentJointFrame.transform((Point3DBasics)hindLeftContactPoint);
                footContactPoints.add(hindLeftContactPoint);
                Point3D hindRightContactPoint = new Point3D(-footLength / 2.0, -footWidth / 2.0, 0.0);
                transformToParentJointFrame.transform((Point3DBasics)hindRightContactPoint);
                footContactPoints.add(hindRightContactPoint);
                Point3D frontLeftContactPoint = new Point3D(footLength / 2.0, toeWidth / 2.0, 0.0);
                transformToParentJointFrame.transform((Point3DBasics)frontLeftContactPoint);
                footContactPoints.add(frontLeftContactPoint);
                Point3D frontRightContactPoint = new Point3D(footLength / 2.0, -toeWidth / 2.0, 0.0);
                transformToParentJointFrame.transform((Point3DBasics)frontRightContactPoint);
                footContactPoints.add(frontRightContactPoint);
                for (RobotSide footSide : RobotSide.values) {
                    Point3D extraContactPoint = new Point3D(0.0, footSide.negateIfRightSide(footWidth / 2.0), 0.0);
                    transformToParentJointFrame.transform((Point3DBasics)extraContactPoint);
                    footContactPoints.add(extraContactPoint);
                }
                ret.put(parentJointName, footContactPoints);
            }
            return ret;
        }

        public boolean useSoftContactPointParameters() {
            return false;
        }

        public SideDependentList<List<Tuple2DBasics>> getControllerContactPoints(double footLength, double footWidth, double toeWidth) {
            SideDependentList ret = new SideDependentList();
            for (RobotSide robotSide : RobotSide.values) {
                ArrayList<Point2D> footContactPoints = new ArrayList<Point2D>();
                double scale = 0.95;
                Point2D hindLeftContactPoint = new Point2D(-footLength / 2.0 * scale, footWidth / 2.0 * scale);
                footContactPoints.add(hindLeftContactPoint);
                Point2D hindRightContactPoint = new Point2D(-footLength / 2.0 * scale, -footWidth / 2.0 * scale);
                footContactPoints.add(hindRightContactPoint);
                Point2D frontLeftContactPoint = new Point2D(footLength / 2.0 * scale, toeWidth / 2.0 * scale);
                footContactPoints.add(frontLeftContactPoint);
                Point2D frontRightContactPoint = new Point2D(footLength / 2.0 * scale, -toeWidth / 2.0 * scale);
                footContactPoints.add(frontRightContactPoint);
                for (RobotSide footSide : RobotSide.values) {
                    Point2D extraContactPoint = new Point2D(0.0, footSide.negateIfRightSide(footWidth / 2.0));
                    extraContactPoint.scale(scale);
                    footContactPoints.add(extraContactPoint);
                }
                ret.put((Enum)robotSide, footContactPoints);
            }
            return ret;
        }

        public SideDependentList<Tuple2DBasics> getToeOffContactPoints(double footLength, double footWidth, double toeWidth) {
            SideDependentList ret = new SideDependentList();
            for (RobotSide robotSide : RobotSide.values) {
                Point2D frontLeftContactPoint = new Point2D(footLength / 2.0, toeWidth);
                Point2D frontRightContactPoint = new Point2D(footLength / 2.0, -toeWidth);
                Point2D toeContactPoint = new Point2D();
                toeContactPoint.interpolate((Tuple2DReadOnly)frontLeftContactPoint, (Tuple2DReadOnly)frontRightContactPoint, 0.5);
                ret.put((Enum)robotSide, (Object)toeContactPoint);
            }
            return ret;
        }

        public SideDependentList<LineSegment2D> getToeOffContactLines(double footLength, double footWidth, double toeWidth) {
            SideDependentList ret = new SideDependentList();
            for (RobotSide robotSide : RobotSide.values) {
                Point2D frontLeftContactPoint = new Point2D(footLength / 2.0, toeWidth);
                Point2D frontRightContactPoint = new Point2D(footLength / 2.0, -toeWidth);
                ret.put((Enum)robotSide, (Object)new LineSegment2D((Point2DReadOnly)frontLeftContactPoint, (Point2DReadOnly)frontRightContactPoint));
            }
            return ret;
        }
    }
}

