/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.parameters;

import us.ihmc.atlas.AtlasJointMap;
import us.ihmc.atlas.parameters.AtlasPhysicalProperties;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotDescription.collisionMeshDefinitionData.BoxCollisionMeshDefinitionData;
import us.ihmc.robotics.robotDescription.collisionMeshDefinitionData.CollisionMeshDefinitionData;
import us.ihmc.robotics.robotDescription.collisionMeshDefinitionData.CollisionMeshDefinitionDataHolder;
import us.ihmc.robotics.robotSide.RobotSide;

public class AtlasCollisionMeshDefinitionDataHolder
extends CollisionMeshDefinitionDataHolder {
    public AtlasCollisionMeshDefinitionDataHolder(AtlasJointMap jointMap, AtlasPhysicalProperties atlasPhysicalProperties) {
        double footLength = atlasPhysicalProperties.getActualFootLength();
        double footWidth = atlasPhysicalProperties.getActualFootWidth();
        double footHeight = Math.abs(((RigidBodyTransform)atlasPhysicalProperties.getSoleToAnkleFrameTransforms().get((Enum)RobotSide.RIGHT)).getM23());
        RigidBodyTransform transformToAnkle = new RigidBodyTransform((RigidBodyTransformReadOnly)atlasPhysicalProperties.getSoleToAnkleFrameTransforms().get((Enum)RobotSide.RIGHT));
        transformToAnkle.appendTranslation(0.0, 0.0, 0.5 * footHeight);
        BoxCollisionMeshDefinitionData rightFootCollisionMeshData = new BoxCollisionMeshDefinitionData(jointMap.getLegJointName(RobotSide.RIGHT, LegJointName.ANKLE_ROLL), footLength, footWidth, footHeight);
        rightFootCollisionMeshData.setTransformToParentJoint(transformToAnkle);
        this.addCollisionMeshDefinitionData((CollisionMeshDefinitionData)rightFootCollisionMeshData);
        BoxCollisionMeshDefinitionData leftFootCollisionMeshData = new BoxCollisionMeshDefinitionData(jointMap.getLegJointName(RobotSide.LEFT, LegJointName.ANKLE_ROLL), footLength, footWidth, footHeight);
        leftFootCollisionMeshData.setTransformToParentJoint(transformToAnkle);
        this.addCollisionMeshDefinitionData((CollisionMeshDefinitionData)leftFootCollisionMeshData);
    }
}

