/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.operatorInterfaceDebugging;

import controller_msgs.msg.dds.HandJointAnglePacket;
import controller_msgs.msg.dds.PointCloudWorldPacket;
import controller_msgs.msg.dds.RobotConfigurationData;
import controller_msgs.msg.dds.SpatialVectorMessage;
import java.io.IOException;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.commons.Conversions;
import us.ihmc.commons.PrintTools;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.net.ConnectionStateListener;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.euclid.tools.EuclidCoreRandomTools;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointBasics;
import us.ihmc.mecano.multiBodySystem.interfaces.OneDoFJointReadOnly;
import us.ihmc.robotModels.FullHumanoidRobotModel;
import us.ihmc.robotModels.FullRobotModelUtils;
import us.ihmc.robotics.random.RandomGeometry;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.sensors.ForceSensorDefinition;
import us.ihmc.robotics.sensors.IMUDefinition;
import us.ihmc.robotiq.data.RobotiqHandSensorData;
import us.ihmc.sensorProcessing.communication.packets.dataobjects.RobotConfigurationDataFactory;

public class AtlasNoSimPacketBlaster
implements Runnable {
    private static final long PACKET_SEND_PERIOD_MILLIS = 1L;
    private PacketCommunicator packetCommunicator;
    private Random random = new Random();
    private AtlasRobotModel atlasRobotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.SCS, false);
    private boolean includeFingerJoints;
    private OneDoFJointBasics[] jointList;
    private FullHumanoidRobotModel fullRobotModel = this.atlasRobotModel.createFullRobotModel();
    private int numberOfJoints;
    private double[] jointLowerLimits;
    private double[] jointUpperLimits;
    private IMUDefinition[] imuDefinitions;
    private ForceSensorDefinition[] forceSensorDefinitions;
    private int momentFixedPointMax;
    private int forceFixedPointMax;
    int debug = 0;
    int skip = 0;

    public AtlasNoSimPacketBlaster() throws IOException {
        this.initRobotConfiguration();
        this.packetCommunicator = PacketCommunicator.createTCPPacketCommunicatorServer((NetworkPorts)NetworkPorts.NETWORK_PROCESSOR_TO_UI_TCP_PORT, (NetClassList)new IHMCCommunicationKryoNetClassList());
        this.packetCommunicator.attachStateListener(new ConnectionStateListener(){

            public void disconnected() {
                PrintTools.info((String)"Disconnected");
            }

            public void connected() {
                PrintTools.info((String)"Connected");
            }
        });
        this.packetCommunicator.connect();
        ScheduledExecutorService threadExecutor = Executors.newSingleThreadScheduledExecutor(ThreadTools.getNamedThreadFactory((String)this.getClass().getSimpleName()));
        threadExecutor.scheduleAtFixedRate(this, 0L, 1L, TimeUnit.MILLISECONDS);
    }

    public void initRobotConfiguration() {
        this.jointList = this.includeFingerJoints ? this.fullRobotModel.getOneDoFJoints() : FullRobotModelUtils.getAllJointsExcludingHands((FullHumanoidRobotModel)this.fullRobotModel);
        this.numberOfJoints = this.jointList.length;
        this.jointLowerLimits = new double[this.numberOfJoints];
        this.jointUpperLimits = new double[this.numberOfJoints];
        this.imuDefinitions = this.fullRobotModel.getIMUDefinitions();
        this.forceSensorDefinitions = this.fullRobotModel.getForceSensorDefinitions();
        for (int i = 0; i < this.numberOfJoints; ++i) {
            this.jointLowerLimits[i] = Math.max(-Math.PI, this.jointList[i].getJointLimitLower());
            this.jointUpperLimits[i] = Math.min(Math.PI, this.jointList[i].getJointLimitUpper());
        }
    }

    @Override
    public void run() {
        OneDoFJointBasics[] joints = Arrays.copyOf(this.jointList, this.jointList.length);
        RobotConfigurationData robotConfigurationData = RobotConfigurationDataFactory.create((OneDoFJointReadOnly[])joints, (ForceSensorDefinition[])this.forceSensorDefinitions, (IMUDefinition[])this.imuDefinitions);
        robotConfigurationData.setWallTime((long)this.random.nextInt(1800) * Conversions.millisecondsToNanoseconds((long)100L));
        robotConfigurationData.setMonotonicTime((long)this.random.nextInt(1800) * Conversions.millisecondsToNanoseconds((long)100L));
        for (int i = 0; i < this.numberOfJoints; ++i) {
            float min = (float)this.jointLowerLimits[i];
            float max = (float)this.jointUpperLimits[i];
            robotConfigurationData.getJointAngles().add(min + this.random.nextFloat() * (max - min));
        }
        robotConfigurationData.getRootTranslation().set(new Vector3D(this.random.nextDouble(), this.random.nextDouble(), 1.0 * this.random.nextDouble()));
        robotConfigurationData.getRootOrientation().set(RandomGeometry.nextQuaternion((Random)this.random));
        for (int sensorNumber = 0; sensorNumber < this.forceSensorDefinitions.length; ++sensorNumber) {
            SpatialVectorMessage wrench = (SpatialVectorMessage)robotConfigurationData.getForceSensorData().add();
            wrench.getAngularPart().set(EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)(-this.momentFixedPointMax), (double)this.momentFixedPointMax));
            wrench.getLinearPart().set(EuclidCoreRandomTools.nextVector3D((Random)this.random, (double)(-this.forceFixedPointMax), (double)this.forceFixedPointMax));
        }
        PointCloudWorldPacket pointCloudWorldPacket = new PointCloudWorldPacket();
        pointCloudWorldPacket.setTimestamp(1L);
        if (this.skip++ > 20) {
            System.out.print(".");
            ++this.debug;
            this.skip = 0;
        }
        if (this.debug > 500) {
            this.debug = 0;
            System.out.println();
            ThreadTools.sleepSeconds((double)5.0);
        }
        RobotiqHandSensorData robotiqHandSensorData = new RobotiqHandSensorData();
        double[] leftFingerJointAngles = robotiqHandSensorData.getFingerJointAngles(RobotSide.LEFT);
        HandJointAnglePacket leftHandJointAnglePacket = HumanoidMessageTools.createHandJointAnglePacket((RobotSide)RobotSide.LEFT, (boolean)true, (boolean)true, (double[])leftFingerJointAngles);
        double[] rightFingerJointAngles = robotiqHandSensorData.getFingerJointAngles(RobotSide.RIGHT);
        HandJointAnglePacket rightHandJointAnglePacket = HumanoidMessageTools.createHandJointAnglePacket((RobotSide)RobotSide.RIGHT, (boolean)true, (boolean)true, (double[])rightFingerJointAngles);
        this.packetCommunicator.send((Packet)rightHandJointAnglePacket);
        this.packetCommunicator.send((Packet)leftHandJointAnglePacket);
        this.packetCommunicator.send((Packet)robotConfigurationData);
    }

    public static void main(String[] args) throws IOException {
        new AtlasNoSimPacketBlaster();
    }
}

