/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.multisenseMocapExperiments;

import com.martiansoftware.jsap.JSAPException;
import controller_msgs.msg.dds.PointCloudWorldPacket;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.concurrent.atomic.AtomicReference;
import optiTrack.IHMCMocapDataClient;
import optiTrack.MocapRigidBody;
import optiTrack.MocapRigidbodiesListener;
import sensor_msgs.PointCloud2;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.communication.configuration.NetworkParameters;
import us.ihmc.communication.net.NetClassList;
import us.ihmc.communication.packetCommunicator.PacketCommunicator;
import us.ihmc.communication.packets.Packet;
import us.ihmc.communication.util.NetworkPorts;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Point3D;
import us.ihmc.euclid.tuple3D.interfaces.Point3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Point3DReadOnly;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.kryo.IHMCCommunicationKryoNetClassList;
import us.ihmc.utilities.ros.RosMainNode;
import us.ihmc.utilities.ros.subscriber.RosPointCloudSubscriber;
import us.ihmc.utilities.ros.subscriber.RosTopicSubscriberInterface;

public class MultisenseHeadOnAStickManualTestMinimalNetworkProcessor
extends RosPointCloudSubscriber
implements MocapRigidbodiesListener {
    private static final NetClassList NETCLASSLIST = new IHMCCommunicationKryoNetClassList();
    private static final int MULTISENSE_MOCAP_ID = 0;
    private final PacketCommunicator uiPacketServer = PacketCommunicator.createTCPPacketCommunicatorServer((NetworkPorts)NetworkPorts.NETWORK_PROCESSOR_TO_UI_TCP_PORT, (NetClassList)NETCLASSLIST);
    private final RigidBodyTransform orientationTransformFromLeftOpticalFrameToZUp = new RigidBodyTransform();
    private final IHMCMocapDataClient mocapDataClient;
    private final AtomicReference<RigidBodyTransform> headPoseInZUp = new AtomicReference<RigidBodyTransform>(new RigidBodyTransform());
    RigidBodyTransform rpyCalibrationOffset = new RigidBodyTransform();

    public MultisenseHeadOnAStickManualTestMinimalNetworkProcessor(DRCRobotModel robotModel) throws IOException {
        URI rosMasterURI = NetworkParameters.getROSURI();
        RosMainNode rosMainNode = new RosMainNode(rosMasterURI, "atlas/AtlasMinimalMultisenseMocapNetworkProcessor", true);
        rosMainNode.attachSubscriber("/multisense/lidar_points2", (RosTopicSubscriberInterface)this);
        rosMainNode.execute();
        this.uiPacketServer.connect();
        this.mocapDataClient = new IHMCMocapDataClient();
        this.mocapDataClient.registerRigidBodiesListener((MocapRigidbodiesListener)this);
        System.out.println("running minimal experiment");
    }

    public void onNewMessage(PointCloud2 pointCloud) {
        RosPointCloudSubscriber.UnpackedPointCloud pointCloudData = MultisenseHeadOnAStickManualTestMinimalNetworkProcessor.unpackPointsAndIntensities((PointCloud2)pointCloud);
        Point3D[] points = pointCloudData.getPoints();
        this.orientationTransformFromLeftOpticalFrameToZUp.setRotationEulerAndZeroTranslation(-1.5707963267948966, 0.0, -1.5707963267948966);
        this.rpyCalibrationOffset.setRotationEulerAndZeroTranslation(Math.toRadians(-1.4), Math.toRadians(0.5), Math.toRadians(2.0));
        this.rpyCalibrationOffset.getTranslation().set(-0.005, -0.003, -0.003);
        for (int i = 0; i < points.length; ++i) {
            this.orientationTransformFromLeftOpticalFrameToZUp.transform((Point3DBasics)points[i]);
            this.rpyCalibrationOffset.transform((Point3DBasics)points[i]);
            this.headPoseInZUp.get().transform((Point3DBasics)points[i]);
        }
        PointCloudWorldPacket pointCloudPacket = new PointCloudWorldPacket();
        HumanoidMessageTools.setDecayingWorldScan((Point3DReadOnly[])points, (PointCloudWorldPacket)pointCloudPacket);
        this.uiPacketServer.send((Packet)pointCloudPacket);
    }

    public void updateRigidbodies(ArrayList<MocapRigidBody> listOfRigidbodies) {
        for (int i = 0; i < listOfRigidbodies.size(); ++i) {
            MocapRigidBody mocapObject = listOfRigidbodies.get(i);
            int id = mocapObject.getId();
            if (id != 0) continue;
            RigidBodyTransform pose = new RigidBodyTransform();
            mocapObject.packPose(pose);
            this.headPoseInZUp.set(pose);
        }
    }

    public static void main(String[] args) throws JSAPException, IOException {
        boolean headless = false;
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.HEAD_ON_A_STICK, headless);
        new MultisenseHeadOnAStickManualTestMinimalNetworkProcessor(robotModel);
    }
}

