/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.jfxvisualizer;

import controller_msgs.msg.dds.AbortWalkingMessage;
import controller_msgs.msg.dds.AtlasLowLevelControlModeMessage;
import controller_msgs.msg.dds.BDIBehaviorCommandPacket;
import controller_msgs.msg.dds.PauseWalkingMessage;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.humanoidRobotics.communication.packets.HumanoidMessageTools;
import us.ihmc.humanoidRobotics.communication.packets.atlas.AtlasLowLevelControlMode;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;

public class AtlasLowLevelMessenger
implements RobotLowLevelMessenger {
    private final IHMCRealtimeROS2Publisher<AtlasLowLevelControlModeMessage> lowLevelModePublisher;
    private final IHMCRealtimeROS2Publisher<BDIBehaviorCommandPacket> bdiBehaviorPublisher;
    private final IHMCRealtimeROS2Publisher<AbortWalkingMessage> abortWalkingPublisher;
    private final IHMCRealtimeROS2Publisher<PauseWalkingMessage> pauseWalkingPublisher;

    public AtlasLowLevelMessenger(RealtimeROS2Node ros2Node, String robotName) {
        ROS2Topic inputTopic = ROS2Tools.getControllerInputTopic((String)robotName);
        this.lowLevelModePublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)ros2Node, AtlasLowLevelControlModeMessage.class, (ROS2Topic)inputTopic);
        this.bdiBehaviorPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)ros2Node, BDIBehaviorCommandPacket.class, (ROS2Topic)inputTopic);
        this.abortWalkingPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)ros2Node, AbortWalkingMessage.class, (ROS2Topic)inputTopic);
        this.pauseWalkingPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)ros2Node, PauseWalkingMessage.class, (ROS2Topic)inputTopic);
    }

    public void sendFreezeRequest() {
        AtlasLowLevelControlModeMessage message = new AtlasLowLevelControlModeMessage();
        message.setRequestedAtlasLowLevelControlMode(AtlasLowLevelControlMode.FREEZE.toByte());
        this.lowLevelModePublisher.publish((Object)message);
    }

    public void sendStandRequest() {
        AtlasLowLevelControlModeMessage message = new AtlasLowLevelControlModeMessage();
        message.setRequestedAtlasLowLevelControlMode(AtlasLowLevelControlMode.STAND_PREP.toByte());
        this.lowLevelModePublisher.publish((Object)message);
    }

    public void sendShutdownRequest() {
        BDIBehaviorCommandPacket message = HumanoidMessageTools.createBDIBehaviorCommandPacket((boolean)true);
        this.bdiBehaviorPublisher.publish((Object)message);
    }

    public void sendAbortWalkingRequest() {
        this.abortWalkingPublisher.publish((Object)new AbortWalkingMessage());
    }

    public void sendPauseWalkingRequest() {
        PauseWalkingMessage message = new PauseWalkingMessage();
        message.setPause(true);
        this.pauseWalkingPublisher.publish((Object)message);
    }

    public void sendContinueWalkingRequest() {
        PauseWalkingMessage message = new PauseWalkingMessage();
        message.setPause(false);
        this.pauseWalkingPublisher.publish((Object)message);
    }
}

