/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.jfxvisualizer;

import java.io.IOException;
import javafx.animation.AnimationTimer;
import javafx.application.Application;
import javafx.scene.AmbientLight;
import javafx.scene.Node;
import javafx.scene.paint.Color;
import javafx.stage.Stage;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotModelFactory;
import us.ihmc.graphicsDescription.structure.Graphics3DNode;
import us.ihmc.javaFXToolkit.node.JavaFXGraphics3DNode;
import us.ihmc.javaFXToolkit.scenes.View3DFactory;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;
import us.ihmc.simulationconstructionset.Robot;
import us.ihmc.simulationconstructionset.graphics.GraphicsRobot;

public class AtlasJavaFxRobotVisualizer
extends Application {
    private HumanoidFloatingRootJointRobot humanoidFloatingRootJointRobot;
    private GraphicsRobot graphicsRobot;
    private JavaFXGraphics3DNode rootNode;
    private double t;

    public void start(Stage primaryStage) throws Exception {
        primaryStage.setTitle("SDF Viewer");
        AtlasRobotModel robotModel = AtlasRobotModelFactory.createDefaultRobotModel();
        this.humanoidFloatingRootJointRobot = robotModel.createHumanoidFloatingRootJointRobot(false);
        this.graphicsRobot = new GraphicsRobot((Robot)this.humanoidFloatingRootJointRobot);
        this.graphicsRobot.update();
        this.rootNode = new JavaFXGraphics3DNode(this.graphicsRobot.getRootNode());
        this.addNodesRecursively(this.graphicsRobot.getRootNode(), this.rootNode);
        this.rootNode.update();
        View3DFactory view3DFactory = new View3DFactory(1024.0, 768.0);
        view3DFactory.addCameraController();
        view3DFactory.addNodeToView((Node)new AmbientLight(Color.WHITE));
        view3DFactory.addPointLight(5.0, 0.0, 2.0, Color.GRAY);
        view3DFactory.addPointLight(-5.0, 0.0, 2.0, Color.GRAY);
        view3DFactory.addNodeToView((Node)this.rootNode);
        primaryStage.setScene(view3DFactory.getScene());
        primaryStage.show();
        AnimationTimer animationTimer = new AnimationTimer(){

            public void handle(long arg0) {
                AtlasJavaFxRobotVisualizer.this.updateRobotAndGraphics();
            }
        };
        animationTimer.start();
    }

    public void addNodesRecursively(Graphics3DNode graphics3dNode, JavaFXGraphics3DNode parentNode) {
        JavaFXGraphics3DNode node = new JavaFXGraphics3DNode(graphics3dNode);
        parentNode.addChild(node);
        for (Graphics3DNode child : graphics3dNode.getChildrenNodes()) {
            this.addNodesRecursively(child, node);
        }
    }

    public void updateRobotAndGraphics() {
        OneDegreeOfFreedomJoint[] oneDegreeOfFreedomJoints = this.humanoidFloatingRootJointRobot.getOneDegreeOfFreedomJoints();
        this.humanoidFloatingRootJointRobot.update();
        this.graphicsRobot.update();
        this.rootNode.update();
    }

    public static void main(String[] args) throws IOException {
        AtlasJavaFxRobotVisualizer.launch((String[])args);
    }
}

