/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.jfxvisualizer;

import controller_msgs.msg.dds.REAStateRequestMessage;
import java.util.List;
import javafx.application.Application;
import javafx.application.Platform;
import javafx.stage.Stage;
import org.apache.commons.lang3.tuple.Triple;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.jfxvisualizer.AtlasLowLevelMessenger;
import us.ihmc.atlas.parameters.AtlasUIAuxiliaryData;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.networkProcessor.footstepPlanningModule.FootstepPlanningModuleLauncher;
import us.ihmc.commonWalkingControlModules.configurations.WalkingControllerParameters;
import us.ihmc.communication.IHMCRealtimeROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.communication.controllerAPI.RobotLowLevelMessenger;
import us.ihmc.footstepPlanning.FootstepPlannerOutput;
import us.ihmc.footstepPlanning.FootstepPlannerTerminationCondition;
import us.ihmc.footstepPlanning.FootstepPlanningModule;
import us.ihmc.footstepPlanning.communication.FootstepPlannerMessagerAPI;
import us.ihmc.footstepPlanning.graphSearch.parameters.FootstepPlannerParametersBasics;
import us.ihmc.footstepPlanning.log.FootstepPlannerLogger;
import us.ihmc.footstepPlanning.swing.SwingPlannerParametersBasics;
import us.ihmc.footstepPlanning.ui.FootstepPlannerUI;
import us.ihmc.footstepPlanning.ui.RemoteUIMessageConverter;
import us.ihmc.footstepPlanning.ui.UIAuxiliaryRobotData;
import us.ihmc.javaFXToolkit.messager.JavaFXMessager;
import us.ihmc.javaFXToolkit.messager.SharedMemoryJavaFXMessager;
import us.ihmc.messager.Messager;
import us.ihmc.pathPlanning.visibilityGraphs.parameters.VisibilityGraphsParametersBasics;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotEnvironmentAwareness.communication.REACommunicationProperties;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.ros2.ROS2Topic;
import us.ihmc.ros2.RealtimeROS2Node;
import us.ihmc.wholeBodyController.RobotContactPointParameters;

public class AtlasFootstepPlannerUI
extends Application {
    private static final double GOAL_DISTANCE_PROXIMITY = 0.1;
    private SharedMemoryJavaFXMessager messager;
    private RemoteUIMessageConverter messageConverter;
    private FootstepPlannerUI ui;
    private FootstepPlanningModule plannerModule;

    public void start(Stage primaryStage) throws Exception {
        List parameters = this.getParameters().getRaw();
        boolean launchPlannerToolbox = parameters == null || !parameters.contains(AtlasFootstepPlannerUI.getSuppressToolboxFlag());
        AtlasRobotModel drcRobotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.REAL_ROBOT, false);
        AtlasRobotModel previewModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.REAL_ROBOT, false);
        this.messager = new SharedMemoryJavaFXMessager(FootstepPlannerMessagerAPI.API);
        RealtimeROS2Node ros2Node = ROS2Tools.createRealtimeROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"ihmc_footstep_planner_ui");
        AtlasLowLevelMessenger robotLowLevelMessenger = new AtlasLowLevelMessenger(ros2Node, drcRobotModel.getSimpleRobotName());
        IHMCRealtimeROS2Publisher reaStateRequestPublisher = ROS2Tools.createPublisherTypeNamed((RealtimeROS2Node)ros2Node, REAStateRequestMessage.class, (ROS2Topic)REACommunicationProperties.inputTopic);
        this.messageConverter = new RemoteUIMessageConverter(ros2Node, (Messager)this.messager, drcRobotModel.getSimpleRobotName());
        this.messager.startMessager();
        this.messager.submitMessage(FootstepPlannerMessagerAPI.GoalDistanceProximity, (Object)0.1);
        this.ui = FootstepPlannerUI.createMessagerUI((Stage)primaryStage, (JavaFXMessager)this.messager, (VisibilityGraphsParametersBasics)drcRobotModel.getVisibilityGraphsParameters(), (FootstepPlannerParametersBasics)drcRobotModel.getFootstepPlannerParameters(), (SwingPlannerParametersBasics)drcRobotModel.getSwingPlannerParameters(), (FullHumanoidRobotModelFactory)drcRobotModel, (FullHumanoidRobotModelFactory)previewModel, (HumanoidJointNameMap)drcRobotModel.getJointMap(), (RobotContactPointParameters)drcRobotModel.getContactPointParameters(), (WalkingControllerParameters)drcRobotModel.getWalkingControllerParameters(), (UIAuxiliaryRobotData)new AtlasUIAuxiliaryData());
        this.ui.setRobotLowLevelMessenger((RobotLowLevelMessenger)robotLowLevelMessenger);
        this.ui.setREAStateRequestPublisher(reaStateRequestPublisher);
        this.ui.show();
        if (launchPlannerToolbox) {
            this.plannerModule = FootstepPlanningModuleLauncher.createModule((DRCRobotModel)drcRobotModel, (DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
            FootstepPlannerLogger logger = new FootstepPlannerLogger(this.plannerModule);
            Runnable loggerRunnable = () -> logger.logSessionAndReportToMessager((Messager)this.messager);
            this.messager.registerTopicListener(FootstepPlannerMessagerAPI.RequestGenerateLog, b -> new Thread(loggerRunnable).start());
            this.messager.registerTopicListener(FootstepPlannerMessagerAPI.PlanSingleStep, planSingleStep -> {
                if (planSingleStep.booleanValue()) {
                    FootstepPlannerTerminationCondition terminationCondition = (plannerTime, iterations, bestPathFinalStep, bestSecondToFinalStep, bestPathSize) -> bestPathSize >= 1;
                    this.plannerModule.addCustomTerminationCondition(terminationCondition);
                } else {
                    this.plannerModule.clearCustomTerminationConditions();
                }
            });
            this.plannerModule.addStatusCallback(status -> this.handleMessagerCallbacks(this.plannerModule, (FootstepPlannerOutput)status));
        }
    }

    private void handleMessagerCallbacks(FootstepPlanningModule planningModule, FootstepPlannerOutput status) {
        if (status.getFootstepPlanningResult() != null && status.getFootstepPlanningResult().terminalResult()) {
            this.messager.submitMessage(FootstepPlannerMessagerAPI.GraphData, (Object)Triple.of((Object)planningModule.getEdgeDataMap(), (Object)planningModule.getIterationData(), (Object)planningModule.getVariableDescriptors()));
            this.messager.submitMessage(FootstepPlannerMessagerAPI.StartVisibilityMap, (Object)planningModule.getBodyPathPlanner().getSolution().getStartMap());
            this.messager.submitMessage(FootstepPlannerMessagerAPI.GoalVisibilityMap, (Object)planningModule.getBodyPathPlanner().getSolution().getGoalMap());
            this.messager.submitMessage(FootstepPlannerMessagerAPI.InterRegionVisibilityMap, (Object)planningModule.getBodyPathPlanner().getSolution().getInterRegionVisibilityMap());
            this.messager.submitMessage(FootstepPlannerMessagerAPI.VisibilityMapWithNavigableRegionData, (Object)planningModule.getBodyPathPlanner().getSolution().getVisibilityMapsWithNavigableRegions());
        }
    }

    public void stop() throws Exception {
        super.stop();
        this.messager.closeMessager();
        this.messageConverter.destroy();
        this.ui.stop();
        if (this.plannerModule != null) {
            this.plannerModule.closeAndDispose();
        }
        Platform.exit();
    }

    public static String getSuppressToolboxFlag() {
        return "suppressToolbox";
    }

    public static void main(String[] args) {
        AtlasFootstepPlannerUI.launch((String[])args);
    }
}

