/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.initialSetup;

import java.util.EnumMap;
import us.ihmc.atlas.ros.AtlasOrderedJointMap;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.robotics.robotSide.SideDependentList;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;

public class MultiContactDRCRobotInitialSetup
implements DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> {
    public void initializeRobot(HumanoidFloatingRootJointRobot robot, HumanoidJointNameMap jointMap) {
        SideDependentList<EnumMap<ArmJointName, Double>> defaultArmPosition = MultiContactDRCRobotInitialSetup.getDefaultArmPositionForMultiContactSimulation();
        for (RobotSide robotSide : RobotSide.values) {
            String[] forcedSideJointNames = (String[])AtlasOrderedJointMap.forcedSideDependentJointNames.get((Enum)robotSide);
            robot.getOneDegreeOfFreedomJoint(forcedSideJointNames[16]).setQ(((Double)((EnumMap)defaultArmPosition.get((Enum)robotSide)).get(ArmJointName.SHOULDER_YAW)).doubleValue());
            robot.getOneDegreeOfFreedomJoint(forcedSideJointNames[17]).setQ(((Double)((EnumMap)defaultArmPosition.get((Enum)robotSide)).get(ArmJointName.SHOULDER_ROLL)).doubleValue());
            robot.getOneDegreeOfFreedomJoint(forcedSideJointNames[18]).setQ(((Double)((EnumMap)defaultArmPosition.get((Enum)robotSide)).get(ArmJointName.ELBOW_PITCH)).doubleValue());
            robot.getOneDegreeOfFreedomJoint(forcedSideJointNames[19]).setQ(((Double)((EnumMap)defaultArmPosition.get((Enum)robotSide)).get(ArmJointName.ELBOW_ROLL)).doubleValue());
            robot.getOneDegreeOfFreedomJoint(forcedSideJointNames[20]).setQ(((Double)((EnumMap)defaultArmPosition.get((Enum)robotSide)).get(ArmJointName.FIRST_WRIST_PITCH)).doubleValue());
            robot.getOneDegreeOfFreedomJoint(forcedSideJointNames[21]).setQ(((Double)((EnumMap)defaultArmPosition.get((Enum)robotSide)).get(ArmJointName.WRIST_ROLL)).doubleValue());
        }
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[4]).setQ(0.4);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[5]).setQ(0.4);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[6]).setQ(0.3);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[7]).setQ(0.8);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[11]).setQ(-0.4);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[12]).setQ(0.3);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[13]).setQ(0.4);
    }

    public static SideDependentList<EnumMap<ArmJointName, Double>> getDefaultArmPositionForMultiContactSimulation() {
        SideDependentList defaultArmPosition = SideDependentList.createListOfEnumMaps(ArmJointName.class);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.LEFT)).put(ArmJointName.SHOULDER_YAW, -0.4);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.LEFT)).put(ArmJointName.SHOULDER_ROLL, -0.7);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.LEFT)).put(ArmJointName.ELBOW_PITCH, 1.8);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.LEFT)).put(ArmJointName.ELBOW_ROLL, 1.4);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.LEFT)).put(ArmJointName.FIRST_WRIST_PITCH, 0.0);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.LEFT)).put(ArmJointName.WRIST_ROLL, 0.5);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.LEFT)).put(ArmJointName.SECOND_WRIST_PITCH, 0.0);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.RIGHT)).put(ArmJointName.SHOULDER_YAW, 0.3);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.RIGHT)).put(ArmJointName.SHOULDER_ROLL, 1.0);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.RIGHT)).put(ArmJointName.ELBOW_PITCH, 1.0);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.RIGHT)).put(ArmJointName.ELBOW_ROLL, -1.6);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.RIGHT)).put(ArmJointName.FIRST_WRIST_PITCH, 0.0);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.RIGHT)).put(ArmJointName.WRIST_ROLL, 0.0);
        ((EnumMap)defaultArmPosition.get((Enum)RobotSide.RIGHT)).put(ArmJointName.SECOND_WRIST_PITCH, 0.0);
        return defaultArmPosition;
    }

    public void getOffset(Vector3D offsetToPack) {
    }

    public void setOffset(Vector3D offset) {
    }

    public void setInitialYaw(double yaw) {
    }

    public void setInitialGroundHeight(double groundHeight) {
    }

    public double getInitialYaw() {
        return 0.0;
    }

    public double getInitialGroundHeight() {
        return 0.0;
    }
}

