/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.initialSetup;

import us.ihmc.atlas.ros.AtlasOrderedJointMap;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;

public class AtlasVehicleSimDrivingDRCRobotInitialSetup
implements DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> {
    private double groundZ;
    private final RigidBodyTransform rootToWorld = new RigidBodyTransform();
    private final Vector3D offset = new Vector3D();

    public AtlasVehicleSimDrivingDRCRobotInitialSetup(double groundZ) {
        this.groundZ = groundZ;
    }

    public void initializeRobot(HumanoidFloatingRootJointRobot robot, HumanoidJointNameMap jointMap) {
        double thighPitch = 0.0;
        double forwardLean = 0.0;
        double hipBend = -1.5707963267948966 - forwardLean;
        double kneeBend = 1.22;
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[17]).setQ(-1.57);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[24]).setQ(1.57);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[18]).setQ(1.57);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[19]).setQ(1.57);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[25]).setQ(1.57);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[26]).setQ(-1.57);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[20]).setQ(0.0);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[27]).setQ(0.0);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[6]).setQ(hipBend + thighPitch);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[12]).setQ(hipBend + thighPitch);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[7]).setQ(kneeBend);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[13]).setQ(kneeBend);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[8]).setQ(thighPitch - 0.3);
        robot.getOneDegreeOfFreedomJoint(AtlasOrderedJointMap.jointNames[14]).setQ(thighPitch - 0.3);
        this.offset.setX(0.7);
        this.offset.setY(-0.07);
        this.offset.setZ(this.groundZ + 1.04);
        robot.setPositionInWorld((Tuple3DReadOnly)this.offset);
        robot.setOrientation(1.5707963267948966, forwardLean, 0.0);
    }

    public void getOffset(Vector3D offsetToPack) {
        offsetToPack.set(this.offset);
    }

    public void setOffset(Vector3D offset) {
        this.offset.set(offset);
    }

    public void setInitialYaw(double yaw) {
    }

    public void setInitialGroundHeight(double groundHeight) {
        this.groundZ = groundHeight;
    }

    public double getInitialYaw() {
        return 0.0;
    }

    public double getInitialGroundHeight() {
        return this.groundZ;
    }
}

