/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.initialSetup;

import java.util.ArrayList;
import java.util.List;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.euclid.geometry.Pose3D;
import us.ihmc.euclid.geometry.interfaces.Pose3DReadOnly;
import us.ihmc.euclid.orientation.interfaces.Orientation3DBasics;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.referenceFrame.FrameQuaternion;
import us.ihmc.euclid.referenceFrame.ReferenceFrame;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DBasics;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.euclid.tuple4D.interfaces.QuaternionReadOnly;
import us.ihmc.euclid.yawPitchRoll.YawPitchRoll;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.GroundContactPoint;
import us.ihmc.simulationconstructionset.OneDegreeOfFreedomJoint;

public class AtlasSimInitialSetup
implements DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> {
    public static final Pose3D PELVIS_POSE = new Pose3D();
    public static final ArrayList<Double> JOINT_Qs = new ArrayList(31);
    private double groundZ;
    private double initialYaw;
    private double initialX;
    private double initialY;
    private final RigidBodyTransform rootToWorld = new RigidBodyTransform();
    private final Vector3D positionInWorld = new Vector3D();
    private final Vector3D offset = new Vector3D();
    private final Quaternion rotation = new Quaternion();

    public AtlasSimInitialSetup() {
        this(0.0, 0.0);
    }

    public AtlasSimInitialSetup(double groundZ, double initialYaw) {
        this(groundZ, initialYaw, 0.0, 0.0);
    }

    public AtlasSimInitialSetup(double groundZ, double initialYaw, double initialX, double initialY) {
        this.groundZ = groundZ;
        this.initialYaw = initialYaw;
        this.initialX = initialX;
        this.initialY = initialY;
    }

    public void initializeRobot(HumanoidFloatingRootJointRobot robot, HumanoidJointNameMap jointMap) {
        this.setActuatorPositions(robot, jointMap);
        this.positionRobotInWorld(robot);
    }

    public void setActuatorPositions(HumanoidFloatingRootJointRobot robot, HumanoidJointNameMap jointMap) {
        for (RobotSide robotSide : RobotSide.values) {
            robot.getOneDegreeOfFreedomJoint(jointMap.getLegJointName(robotSide, LegJointName.HIP_YAW)).setQ(JOINT_Qs.get(19).doubleValue());
            robot.getOneDegreeOfFreedomJoint(jointMap.getLegJointName(robotSide, LegJointName.HIP_ROLL)).setQ(robotSide.negateIfRightSide(JOINT_Qs.get(20).doubleValue()));
            robot.getOneDegreeOfFreedomJoint(jointMap.getLegJointName(robotSide, LegJointName.HIP_PITCH)).setQ(JOINT_Qs.get(21).doubleValue());
            robot.getOneDegreeOfFreedomJoint(jointMap.getLegJointName(robotSide, LegJointName.KNEE_PITCH)).setQ(JOINT_Qs.get(22).doubleValue());
            robot.getOneDegreeOfFreedomJoint(jointMap.getLegJointName(robotSide, LegJointName.ANKLE_PITCH)).setQ(JOINT_Qs.get(23).doubleValue());
            robot.getOneDegreeOfFreedomJoint(jointMap.getLegJointName(robotSide, LegJointName.ANKLE_ROLL)).setQ(robotSide.negateIfRightSide(JOINT_Qs.get(24).doubleValue()));
            this.setArmJointPosition(robot, jointMap, robotSide, ArmJointName.SHOULDER_YAW, robotSide.negateIfRightSide(JOINT_Qs.get(3).doubleValue()));
            this.setArmJointPosition(robot, jointMap, robotSide, ArmJointName.SHOULDER_ROLL, robotSide.negateIfRightSide(JOINT_Qs.get(4).doubleValue()));
            this.setArmJointPosition(robot, jointMap, robotSide, ArmJointName.ELBOW_PITCH, JOINT_Qs.get(5));
            this.setArmJointPosition(robot, jointMap, robotSide, ArmJointName.ELBOW_ROLL, robotSide.negateIfRightSide(JOINT_Qs.get(6).doubleValue()));
            this.setArmJointPosition(robot, jointMap, robotSide, ArmJointName.FIRST_WRIST_PITCH, JOINT_Qs.get(7));
            this.setArmJointPosition(robot, jointMap, robotSide, ArmJointName.WRIST_ROLL, robotSide.negateIfRightSide(JOINT_Qs.get(8).doubleValue()));
            this.setArmJointPosition(robot, jointMap, robotSide, ArmJointName.SECOND_WRIST_PITCH, JOINT_Qs.get(9));
        }
        robot.update();
    }

    private void setArmJointPosition(HumanoidFloatingRootJointRobot robot, HumanoidJointNameMap jointMap, RobotSide robotSide, ArmJointName armJointName, double q) {
        String armJointString = jointMap.getArmJointName(robotSide, armJointName);
        if (armJointString == null) {
            return;
        }
        OneDegreeOfFreedomJoint joint = robot.getOneDegreeOfFreedomJoint(armJointString);
        if (joint == null) {
            return;
        }
        joint.setQ(q);
    }

    public void positionRobotInWorld(HumanoidFloatingRootJointRobot robot) {
        robot.getRootJoint().setPosition(0.0, 0.0, 0.0);
        robot.update();
        robot.getRootJointToWorldTransform(this.rootToWorld);
        this.rootToWorld.get((Orientation3DBasics)this.rotation, (Tuple3DBasics)this.positionInWorld);
        this.positionInWorld.add((Tuple3DReadOnly)this.offset);
        this.positionInWorld.addZ(this.groundZ - this.getLowestFootContactPointHeight(robot));
        robot.setPositionInWorld((Tuple3DReadOnly)this.positionInWorld);
        FrameQuaternion frameOrientation = new FrameQuaternion(ReferenceFrame.getWorldFrame(), (QuaternionReadOnly)this.rotation);
        YawPitchRoll yawPitchRoll = new YawPitchRoll((Orientation3DReadOnly)frameOrientation);
        yawPitchRoll.setYaw(this.initialYaw);
        frameOrientation.set((Orientation3DReadOnly)yawPitchRoll);
        robot.setOrientation((QuaternionReadOnly)frameOrientation);
        robot.update();
    }

    private double getLowestFootContactPointHeight(HumanoidFloatingRootJointRobot robot) {
        List contactPoints = robot.getFootGroundContactPoints(RobotSide.LEFT);
        double height = Double.POSITIVE_INFINITY;
        if (contactPoints.size() == 0) {
            height = -PELVIS_POSE.getZ();
        } else {
            for (GroundContactPoint gc : contactPoints) {
                height = Math.min(height, gc.getPositionCopy().getZ());
            }
        }
        return height;
    }

    public List<Double> getInitialJointAngles() {
        return JOINT_Qs;
    }

    public Pose3DReadOnly getInitialPelvisPose() {
        Pose3D resultPose = new Pose3D();
        resultPose.appendTranslation(this.initialX, this.initialY, this.groundZ + PELVIS_POSE.getZ());
        resultPose.appendTranslation((Tuple3DReadOnly)this.offset);
        resultPose.appendYawRotation(this.initialYaw);
        return resultPose;
    }

    public void getOffset(Vector3D offsetToPack) {
        offsetToPack.set(this.offset);
    }

    public void setOffset(Vector3D offset) {
        this.offset.set(offset);
    }

    public void setInitialYaw(double yaw) {
        this.initialYaw = yaw;
    }

    public void setInitialGroundHeight(double groundHeight) {
        this.groundZ = groundHeight;
    }

    public double getInitialYaw() {
        return this.initialYaw;
    }

    public double getInitialGroundHeight() {
        return this.groundZ;
    }

    public boolean supportsReset() {
        return true;
    }

    static {
        PELVIS_POSE.getPosition().set(0.0, 0.0, 0.9286147465454951);
        PELVIS_POSE.getOrientation().set(0.0, 0.0, 0.841, 0.54);
        JOINT_Qs.add(0.0);
        JOINT_Qs.add(0.0);
        JOINT_Qs.add(0.0);
        JOINT_Qs.add(0.785398);
        JOINT_Qs.add(-0.52379);
        JOINT_Qs.add(2.33708);
        JOINT_Qs.add(2.35619);
        JOINT_Qs.add(-0.337807);
        JOINT_Qs.add(0.20773);
        JOINT_Qs.add(-0.026599);
        JOINT_Qs.add(0.0);
        JOINT_Qs.add(0.0);
        JOINT_Qs.add(-JOINT_Qs.get(3).doubleValue());
        JOINT_Qs.add(-JOINT_Qs.get(4).doubleValue());
        JOINT_Qs.add((double)JOINT_Qs.get(5));
        JOINT_Qs.add(-JOINT_Qs.get(6).doubleValue());
        JOINT_Qs.add((double)JOINT_Qs.get(7));
        JOINT_Qs.add(-JOINT_Qs.get(8).doubleValue());
        JOINT_Qs.add((double)JOINT_Qs.get(9));
        JOINT_Qs.add(0.0);
        JOINT_Qs.add(0.062);
        JOINT_Qs.add(-0.233);
        JOINT_Qs.add(0.518);
        JOINT_Qs.add(-0.276);
        JOINT_Qs.add(-0.062);
        JOINT_Qs.add((double)JOINT_Qs.get(19));
        JOINT_Qs.add(-JOINT_Qs.get(20).doubleValue());
        JOINT_Qs.add((double)JOINT_Qs.get(21));
        JOINT_Qs.add((double)JOINT_Qs.get(22));
        JOINT_Qs.add((double)JOINT_Qs.get(23));
        JOINT_Qs.add(-JOINT_Qs.get(24).doubleValue());
    }
}

