/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.initialSetup;

import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import us.ihmc.avatar.initialSetup.DRCRobotInitialSetup;
import us.ihmc.commons.PrintTools;
import us.ihmc.euclid.orientation.interfaces.Orientation3DReadOnly;
import us.ihmc.euclid.transform.RigidBodyTransform;
import us.ihmc.euclid.transform.interfaces.RigidBodyTransformReadOnly;
import us.ihmc.euclid.tuple3D.Vector3D;
import us.ihmc.euclid.tuple3D.interfaces.Tuple3DReadOnly;
import us.ihmc.euclid.tuple4D.Quaternion;
import us.ihmc.robotics.partNames.ArmJointName;
import us.ihmc.robotics.partNames.HumanoidJointNameMap;
import us.ihmc.robotics.partNames.LegJointName;
import us.ihmc.robotics.partNames.SpineJointName;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.simulationConstructionSetTools.util.HumanoidFloatingRootJointRobot;
import us.ihmc.simulationconstructionset.FloatingRootJointRobot;

public class AtlasInitialSetupFromFile
implements DRCRobotInitialSetup<HumanoidFloatingRootJointRobot> {
    private String initialConditionsFileName;
    private static final String POSITION_KEY = "pelvisPos";
    private static final String ORIENTATION_KEY = "pelvisRot";
    private final RigidBodyTransform pelvisPoseInWorld = new RigidBodyTransform();
    private boolean robotInitialized = false;

    public AtlasInitialSetupFromFile(String initialConditionsFile) {
        this.initialConditionsFileName = initialConditionsFile;
    }

    public void initializeRobot(HumanoidFloatingRootJointRobot robot, HumanoidJointNameMap jointMap) {
        if (this.robotInitialized) {
            return;
        }
        PrintTools.info((String)("Loading initial joint configuration for driving simulation from " + this.initialConditionsFileName));
        try {
            Properties properties = new Properties();
            InputStream stream = this.getClass().getClassLoader().getResourceAsStream(this.initialConditionsFileName);
            properties.load(stream);
            for (RobotSide robotSide : RobotSide.values()) {
                String key;
                for (LegJointName legJointName : LegJointName.values) {
                    key = jointMap.getLegJointName(robotSide, legJointName);
                    this.setRobotAngle(key, properties, (FloatingRootJointRobot)robot);
                }
                for (LegJointName legJointName : ArmJointName.values()) {
                    key = jointMap.getArmJointName(robotSide, (ArmJointName)legJointName);
                    this.setRobotAngle(key, properties, (FloatingRootJointRobot)robot);
                }
            }
            for (RobotSide robotSide : SpineJointName.values) {
                String key = jointMap.getSpineJointName((SpineJointName)robotSide);
                this.setRobotAngle(key, properties, (FloatingRootJointRobot)robot);
            }
            if (properties.containsKey(POSITION_KEY)) {
                String[] position = properties.getProperty(POSITION_KEY).split(" ");
                this.pelvisPoseInWorld.getTranslation().set((Tuple3DReadOnly)new Vector3D(Double.parseDouble(position[0]), Double.parseDouble(position[1]), Double.parseDouble(position[2])));
            }
            if (properties.containsKey(ORIENTATION_KEY)) {
                String[] quat = properties.getProperty(ORIENTATION_KEY).split(" ");
                this.pelvisPoseInWorld.getRotation().set((Orientation3DReadOnly)new Quaternion(Double.parseDouble(quat[0]), Double.parseDouble(quat[1]), Double.parseDouble(quat[2]), 1.0));
            }
            stream.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Atlas joint parameter file  cannot be loaded. ", e);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Make sure all fields are doubles in File", e);
        }
        robot.getRootJoint().setRotationAndTranslation((RigidBodyTransformReadOnly)this.pelvisPoseInWorld);
        robot.update();
        this.robotInitialized = true;
    }

    private void setRobotAngle(String jointName, Properties properties, FloatingRootJointRobot robot) {
        if (jointName == null) {
            return;
        }
        if (properties.containsKey(jointName)) {
            String jointAngle = properties.getProperty(jointName);
            robot.getOneDegreeOfFreedomJoint(jointName).setQ(Double.parseDouble(jointAngle) / 100.0);
        } else {
            PrintTools.info((String)("Did not find initial angle for " + jointName));
        }
    }

    public void getOffset(Vector3D offsetToPack) {
        offsetToPack.set((Tuple3DReadOnly)this.pelvisPoseInWorld.getTranslation());
    }

    public void setOffset(Vector3D offset) {
        this.pelvisPoseInWorld.getTranslation().set((Tuple3DReadOnly)offset);
    }

    public void setInitialYaw(double yaw) {
        PrintTools.info((String)"not implemented");
    }

    public void setInitialGroundHeight(double groundHeight) {
        PrintTools.info((String)"not implemented");
    }

    public double getInitialYaw() {
        PrintTools.info((String)"not implemented");
        return 0.0;
    }

    public double getInitialGroundHeight() {
        PrintTools.info((String)"not implemented");
        return 0.0;
    }

    public String getFileName() {
        return this.initialConditionsFileName;
    }
}

