/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.handControl.sandia;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.DefaultBoundedRangeModel;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import org.ros.namespace.GraphName;
import org.ros.node.AbstractNodeMain;
import org.ros.node.ConnectedNode;
import org.ros.node.DefaultNodeMainExecutor;
import org.ros.node.NodeConfiguration;
import org.ros.node.NodeMain;
import org.ros.node.NodeMainExecutor;
import org.ros.node.topic.Publisher;
import osrf_msgs.JointCommands;
import sandia_hand_msgs.SimpleGrasp;
import us.ihmc.atlas.handControl.sandia.SandiaHandModel;
import us.ihmc.utilities.ros.RosTools;

public class SandiaHandManualControlUI
extends AbstractNodeMain {
    private static final String MASTER_URI = "http://localhost:11311";
    private static final int joinSliderBounds = 20;
    private static final int jointSliderMin = -60;
    private static final int jointSliderMax = 60;
    private static final int graspSliderMax = 10;
    private static final int graspSliderMin = 0;
    private Publisher<JointCommands> indexFingerJointPublisher;
    private Publisher<JointCommands> middleFingerJointPublisher;
    private Publisher<JointCommands> ringFingerJointPublisher;
    private Publisher<JointCommands> thumbJointPublisher;
    private JointCommands indexFingerJointCommand;
    private JointCommands middleFingerJointCommand;
    private JointCommands ringFingerJointCommand;
    private JointCommands thumbJointCommand;
    private Publisher<SimpleGrasp> simpleGraspPublisher;
    private SimpleGrasp simpleGraspCommand;
    private HashMap<SandiaHandModel.SandiaFingerName, Publisher<JointCommands>> fingerPublishers = new HashMap();
    private HashMap<SandiaHandModel.SandiaFingerName, JointCommands> jointCommands = new HashMap();
    private ConnectedNode connectedNode;
    private JFrame frame = new JFrame("Sandia Hand Manual Control");
    private GridBagConstraints c;
    private JPanel panel;
    private JPanel leftPanel;
    private JPanel rightPanel;
    private JPanel fingerSelectionPanel;
    private JPanel sliderPanel;
    private JPanel actionButtonPanel;
    private JPanel graspTypePanel;
    private JPanel graspControlPanel;
    private JLabel graspSelectionLabel;
    private JLabel fingerLabel;
    private JLabel baseJointLabel;
    private JLabel firstJointLabel;
    private JLabel secondJointLabel;
    private JLabel graspControlLabel;
    private JComboBox<GraspTypes> graspTypeComboBox;
    private JCheckBox thumbCheckBox;
    private JCheckBox indexCheckBox;
    private JCheckBox middleCheckBox;
    private JCheckBox ringCheckBox;
    private HashMap<SandiaHandModel.SandiaFingerName, JCheckBox> fingerCheckBoxes = new HashMap();
    private JSlider baseJointSlider;
    private JSlider firstJointSlider;
    private JSlider secondJointSlider;
    private JSlider graspControlSlider;
    private JButton resetButton;

    public GraphName getDefaultNodeName() {
        return GraphName.of((String)"darpaRoboticsChallenge/SandiaHandManualControlUI");
    }

    public void onStart(ConnectedNode connectedNode) {
        this.connectedNode = connectedNode;
        this.setupFrame();
        this.setupPublishers();
        this.setupJointCommandMessages();
        this.setupFingerMaps();
    }

    private void setupFingerMaps() {
        this.fingerPublishers.put(SandiaHandModel.SandiaFingerName.INDEX, this.indexFingerJointPublisher);
        this.fingerPublishers.put(SandiaHandModel.SandiaFingerName.MIDDLE, this.middleFingerJointPublisher);
        this.fingerPublishers.put(SandiaHandModel.SandiaFingerName.RING, this.ringFingerJointPublisher);
        this.fingerPublishers.put(SandiaHandModel.SandiaFingerName.THUMB, this.thumbJointPublisher);
        this.jointCommands.put(SandiaHandModel.SandiaFingerName.INDEX, this.indexFingerJointCommand);
        this.jointCommands.put(SandiaHandModel.SandiaFingerName.MIDDLE, this.middleFingerJointCommand);
        this.jointCommands.put(SandiaHandModel.SandiaFingerName.RING, this.ringFingerJointCommand);
        this.jointCommands.put(SandiaHandModel.SandiaFingerName.THUMB, this.thumbJointCommand);
    }

    private void setupFrame() {
        this.c = new GridBagConstraints();
        this.addPanels();
        this.frame.add(this.panel);
        this.frame.setDefaultCloseOperation(3);
        this.frame.pack();
        this.frame.setResizable(false);
        this.frame.setVisible(true);
    }

    private void setupPublishers() {
        this.indexFingerJointPublisher = this.connectedNode.newPublisher("/finger_0/joint_commands", "osrf_msgs/JointCommands");
        this.middleFingerJointPublisher = this.connectedNode.newPublisher("/finger_1/joint_commands", "osrf_msgs/JointCommands");
        this.ringFingerJointPublisher = this.connectedNode.newPublisher("/finger_2/joint_commands", "osrf_msgs/JointCommands");
        this.thumbJointPublisher = this.connectedNode.newPublisher("/finger_3/joint_commands", "osrf_msgs/JointCommands");
        this.simpleGraspPublisher = this.connectedNode.newPublisher("/simple_grasp", "sandia_hand_msgs/SimpleGrasp");
    }

    private void setupJointCommandMessages() {
        this.indexFingerJointCommand = (JointCommands)this.indexFingerJointPublisher.newMessage();
        this.middleFingerJointCommand = (JointCommands)this.middleFingerJointPublisher.newMessage();
        this.ringFingerJointCommand = (JointCommands)this.ringFingerJointPublisher.newMessage();
        this.thumbJointCommand = (JointCommands)this.thumbJointPublisher.newMessage();
        this.simpleGraspCommand = (SimpleGrasp)this.simpleGraspPublisher.newMessage();
    }

    private void addPanels() {
        this.panel = new JPanel(new GridBagLayout());
        this.setupLeftPanel();
        this.setupRightPanel();
        this.setupActionButtonPanel();
        this.c.insets = new Insets(5, 5, 5, 5);
        this.c.fill = 1;
        this.c.ipadx = 50;
        JPanel controlBoardPanel = new JPanel(new GridBagLayout());
        this.c.gridx = 0;
        this.c.gridy = 0;
        controlBoardPanel.add((Component)this.leftPanel, this.c);
        ++this.c.gridx;
        controlBoardPanel.add((Component)this.rightPanel, this.c);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.panel.add((Component)controlBoardPanel, this.c);
        ++this.c.gridy;
        this.panel.add((Component)this.actionButtonPanel, this.c);
    }

    private void setupLeftPanel() {
        this.leftPanel = new JPanel(new GridBagLayout());
        this.leftPanel.setBorder(BorderFactory.createEtchedBorder());
        this.setupFingerSelectionPanel();
        this.setupSliderPanel();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.leftPanel.add((Component)this.fingerSelectionPanel, this.c);
        ++this.c.gridy;
        this.leftPanel.add((Component)this.sliderPanel, this.c);
    }

    private void setupRightPanel() {
        this.rightPanel = new JPanel(new GridBagLayout());
        this.rightPanel.setBorder(BorderFactory.createEtchedBorder());
        this.setupGraspSelectionPanel();
        this.setupGraspControlPanel();
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.rightPanel.add((Component)this.graspTypePanel, this.c);
        ++this.c.gridy;
        this.rightPanel.add((Component)this.graspControlPanel, this.c);
    }

    private void setupFingerSelectionPanel() {
        this.fingerSelectionPanel = new JPanel(new GridBagLayout());
        this.fingerLabel = new JLabel("Select Fingers:");
        this.thumbCheckBox = new JCheckBox("Thumb");
        this.indexCheckBox = new JCheckBox("Index");
        this.middleCheckBox = new JCheckBox("Middle");
        this.ringCheckBox = new JCheckBox("Ring");
        JPanel leftFingerCheckBoxPanel = new JPanel(new GridBagLayout());
        JPanel rightFingerCheckBoxPanel = new JPanel(new GridBagLayout());
        this.c.anchor = 17;
        this.c.gridx = 0;
        this.c.gridy = 0;
        leftFingerCheckBoxPanel.add((Component)this.thumbCheckBox, this.c);
        this.thumbCheckBox.setAlignmentX(0.0f);
        this.fingerCheckBoxes.put(SandiaHandModel.SandiaFingerName.THUMB, this.thumbCheckBox);
        rightFingerCheckBoxPanel.add((Component)this.middleCheckBox, this.c);
        this.middleCheckBox.setAlignmentX(0.0f);
        this.fingerCheckBoxes.put(SandiaHandModel.SandiaFingerName.MIDDLE, this.middleCheckBox);
        ++this.c.gridy;
        leftFingerCheckBoxPanel.add((Component)this.indexCheckBox, this.c);
        this.indexCheckBox.setAlignmentX(0.0f);
        this.fingerCheckBoxes.put(SandiaHandModel.SandiaFingerName.INDEX, this.indexCheckBox);
        rightFingerCheckBoxPanel.add((Component)this.ringCheckBox, this.c);
        this.ringCheckBox.setAlignmentX(0.0f);
        this.fingerCheckBoxes.put(SandiaHandModel.SandiaFingerName.RING, this.ringCheckBox);
        JPanel fingerCheckBoxPanel = new JPanel(new GridBagLayout());
        this.c.gridx = 0;
        this.c.gridy = 0;
        fingerCheckBoxPanel.add((Component)leftFingerCheckBoxPanel, this.c);
        ++this.c.gridx;
        fingerCheckBoxPanel.add((Component)rightFingerCheckBoxPanel, this.c);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.anchor = 10;
        this.fingerSelectionPanel.add((Component)this.fingerLabel, this.c);
        ++this.c.gridy;
        this.fingerSelectionPanel.add((Component)fingerCheckBoxPanel, this.c);
    }

    private void setupSliderPanel() {
        this.sliderPanel = new JPanel(new GridBagLayout());
        this.baseJointLabel = new JLabel("Base Joint:");
        this.baseJointSlider = new JSlider(new DefaultBoundedRangeModel(0, 1, -60, 60));
        this.baseJointSlider.addMouseListener(new FingerJointSliderMouseListener());
        this.firstJointLabel = new JLabel("First Joint:");
        this.firstJointSlider = new JSlider(new DefaultBoundedRangeModel(0, 1, -60, 60));
        this.firstJointSlider.addMouseListener(new FingerJointSliderMouseListener());
        this.secondJointLabel = new JLabel("Second Joint:");
        this.secondJointSlider = new JSlider(new DefaultBoundedRangeModel(0, 1, -60, 60));
        this.secondJointSlider.addMouseListener(new FingerJointSliderMouseListener());
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.sliderPanel.add((Component)this.baseJointLabel, this.c);
        this.c.gridx = 1;
        this.sliderPanel.add((Component)this.baseJointSlider, this.c);
        this.c.gridx = 0;
        this.c.gridy = 1;
        this.sliderPanel.add((Component)this.firstJointLabel, this.c);
        this.c.gridx = 1;
        this.sliderPanel.add((Component)this.firstJointSlider, this.c);
        this.c.gridx = 0;
        this.c.gridy = 2;
        this.sliderPanel.add((Component)this.secondJointLabel, this.c);
        this.c.gridx = 1;
        this.sliderPanel.add((Component)this.secondJointSlider, this.c);
    }

    private void setupGraspSelectionPanel() {
        this.graspTypePanel = new JPanel(new GridBagLayout());
        this.graspSelectionLabel = new JLabel("Select Grasp Type:");
        this.graspTypeComboBox = new JComboBox<GraspTypes>(GraspTypes.values());
        this.graspTypeComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                SandiaHandManualControlUI.this.graspControlSlider.setValue(0);
                SandiaHandManualControlUI.this.simpleGraspCommand.setName(SandiaHandManualControlUI.this.graspTypeComboBox.getSelectedItem().toString().toLowerCase());
                SandiaHandManualControlUI.this.simpleGraspCommand.setClosedAmount(0.0);
                SandiaHandManualControlUI.this.simpleGraspPublisher.publish((Object)SandiaHandManualControlUI.this.simpleGraspCommand);
            }
        });
        JPanel graspSelectionPanel = new JPanel(new GridBagLayout());
        this.c.anchor = 10;
        this.c.gridx = 0;
        this.c.gridy = 0;
        graspSelectionPanel.add((Component)this.graspSelectionLabel, this.c);
        ++this.c.gridx;
        graspSelectionPanel.add(this.graspTypeComboBox, this.c);
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.c.ipady = 10;
        this.graspTypePanel.add((Component)this.graspSelectionLabel, this.c);
        ++this.c.gridy;
        this.graspTypePanel.add((Component)graspSelectionPanel, this.c);
    }

    private void setupGraspControlPanel() {
        this.graspControlPanel = new JPanel(new GridBagLayout());
        this.graspControlLabel = new JLabel("Grasp Control:");
        this.graspControlSlider = new JSlider(new DefaultBoundedRangeModel(0, 1, 0, 10));
        this.graspControlSlider.addMouseListener(new GraspControlSliderMouseListener());
        this.c.anchor = 10;
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.graspControlPanel.add((Component)this.graspControlLabel, this.c);
        ++this.c.gridx;
        this.graspControlPanel.add((Component)this.graspControlSlider, this.c);
    }

    private void setupActionButtonPanel() {
        this.actionButtonPanel = new JPanel(new GridBagLayout());
        this.resetButton = new JButton("Reset");
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent arg0) {
                SandiaHandManualControlUI.this.baseJointSlider.setValue(0);
                SandiaHandManualControlUI.this.firstJointSlider.setValue(0);
                SandiaHandManualControlUI.this.secondJointSlider.setValue(0);
                SandiaHandManualControlUI.this.graspControlSlider.setValue(0);
                SandiaHandManualControlUI.this.graspTypeComboBox.setSelectedIndex(0);
                for (SandiaHandModel.SandiaFingerName fingerName : SandiaHandModel.SandiaFingerName.values()) {
                    ((JCheckBox)SandiaHandManualControlUI.this.fingerCheckBoxes.get((Object)fingerName)).setSelected(false);
                }
                SandiaHandManualControlUI.this.simpleGraspCommand.setName(GraspTypes.CYLINDRICAL.toString().toLowerCase());
                SandiaHandManualControlUI.this.simpleGraspCommand.setClosedAmount(0.0);
                SandiaHandManualControlUI.this.simpleGraspPublisher.publish((Object)SandiaHandManualControlUI.this.simpleGraspCommand);
            }
        });
        this.c.gridx = 0;
        this.c.gridy = 0;
        this.actionButtonPanel.add((Component)this.resetButton, this.c);
    }

    public static void main(String[] args) throws URISyntaxException {
        URI master = args.length > 0 ? new URI(args[0]) : new URI(MASTER_URI);
        NodeConfiguration nodeConfiguration = RosTools.createNodeConfiguration((URI)master);
        NodeMainExecutor nodeMainExecutor = DefaultNodeMainExecutor.newDefault();
        nodeMainExecutor.execute((NodeMain)new SandiaHandManualControlUI(), nodeConfiguration);
    }

    class GraspControlSliderMouseListener
    implements MouseListener {
        GraspControlSliderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            SandiaHandManualControlUI.this.simpleGraspCommand.setName(SandiaHandManualControlUI.this.graspTypeComboBox.getSelectedItem().toString().toLowerCase());
            SandiaHandManualControlUI.this.simpleGraspCommand.setClosedAmount((double)SandiaHandManualControlUI.this.graspControlSlider.getValue() / 10.0);
            SandiaHandManualControlUI.this.simpleGraspPublisher.publish((Object)SandiaHandManualControlUI.this.simpleGraspCommand);
        }
    }

    class FingerJointSliderMouseListener
    implements MouseListener {
        FingerJointSliderMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent arg0) {
        }

        @Override
        public void mouseEntered(MouseEvent arg0) {
        }

        @Override
        public void mouseExited(MouseEvent arg0) {
        }

        @Override
        public void mousePressed(MouseEvent arg0) {
        }

        @Override
        public void mouseReleased(MouseEvent arg0) {
            double baseJointPosition = (double)SandiaHandManualControlUI.this.baseJointSlider.getValue() / 20.0;
            double firstJointPosition = (double)SandiaHandManualControlUI.this.firstJointSlider.getValue() / 20.0;
            double secondJointPosition = (double)SandiaHandManualControlUI.this.secondJointSlider.getValue() / 20.0;
            double[] position = new double[]{baseJointPosition, firstJointPosition, secondJointPosition};
            for (SandiaHandModel.SandiaFingerName fingerName : SandiaHandModel.SandiaFingerName.values()) {
                if (!((JCheckBox)SandiaHandManualControlUI.this.fingerCheckBoxes.get((Object)fingerName)).isSelected()) continue;
                JointCommands tempJointCommand = (JointCommands)SandiaHandManualControlUI.this.jointCommands.get((Object)fingerName);
                Publisher tempJointPublisher = (Publisher)SandiaHandManualControlUI.this.fingerPublishers.get((Object)fingerName);
                tempJointCommand.setPosition(position);
                tempJointPublisher.publish((Object)tempJointCommand);
            }
        }
    }

    static enum GraspTypes {
        CYLINDRICAL,
        SPHERICAL,
        PRISMATIC,
        NUMBER_ONE,
        PEACE,
        ROCK_N_ROLL;

    }
}

