/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import us.ihmc.atlas.behaviors.AtlasPerceptionSimulation;
import us.ihmc.atlas.behaviors.tools.AtlasSimulationBasics;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.environments.BehaviorPlanarRegionEnvironments;
import us.ihmc.behaviors.BehaviorDefinition;
import us.ihmc.behaviors.BehaviorModule;
import us.ihmc.behaviors.BehaviorRegistry;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUI;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUIDefinition;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUIRegistry;
import us.ihmc.behaviors.javafx.behaviors.LookAndStepBehaviorUI;
import us.ihmc.behaviors.simulation.EnvironmentInitialSetup;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.CommunicationMode;
import us.ihmc.log.LogTools;
import us.ihmc.messager.Messager;
import us.ihmc.robotics.geometry.PlanarRegionsList;

public class AtlasLookAndStepBehaviorDemo
extends AtlasSimulationBasics {
    private static boolean RUN_REALSENSE_SLAM = Boolean.parseBoolean(System.getProperty("run.realsense.slam", "true"));
    private static boolean RUN_LIDAR_REA = Boolean.parseBoolean(System.getProperty("run.lidar.rea", "true"));
    private static boolean SHOW_REALSENSE_SLAM_UIS = Boolean.parseBoolean(System.getProperty("show.realsense.slam.uis"));
    private JavaFXBehaviorUI behaviorUI;
    private final BehaviorModule behaviorModule;
    private AtlasPerceptionSimulation perceptionStack;

    public AtlasLookAndStepBehaviorDemo() {
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateTriplePalletCinderBlockAngledStepsUpAndDown, 0.0, 0.0, 0.0, 0.0));
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateTriplePalletCinderBlockAngledStepsUpAndDown, 0.0, Math.PI, 6.0, 0.0));
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateTriplePalletCinderBlockAngledStepsUpAndDown, 0.44999999999999996, Math.PI, 2.8, 0.0));
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateTriplePalletCinderBlockAngledStepsUpAndDown, 0.44999999999999996, 0.0, 2.8, 0.0));
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateTriplePalletCinderBlockStepsUpAndDown, 0.0, 0.0, 0.0, 0.0));
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateTriplePalletCinderBlockStepsUpAndDown, 0.0, Math.PI, 6.0, 0.0));
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateTriplePalletCinderBlockStepsUpAndDown, 0.44999999999999996, Math.PI, 2.8, 0.0));
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateTriplePalletCinderBlockStepsUpAndDown, 0.44999999999999996, 0.0, 2.8, 0.0));
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateRealisticEasierStartingBlockRegions, 0.3, 0.0, 0.0, 0.0));
        this.environmentInitialSetups.add(new EnvironmentInitialSetup(BehaviorPlanarRegionEnvironments::generateTriplePalletCinderBlockStepsUpAndDown, 0.0, 0.0, 0.0, 0.0));
        this.selectEnvironment();
        ThreadTools.startAsDaemon(() -> {
            this.perceptionStack = new AtlasPerceptionSimulation(COMMUNICATION_MODE_ROS2, (PlanarRegionsList)this.environmentInitialSetup.getPlanarRegionsSupplier().get(), RUN_REALSENSE_SLAM, SHOW_REALSENSE_SLAM_UIS, RUN_LIDAR_REA, this.createRobotModel(), AtlasPerceptionSimulation.Fidelity.HIGH);
        }, (String)"PerceptionStack");
        ThreadTools.startAsDaemon((Runnable)this.simulation, (String)"Simulation");
        if (RUN_LIDAR_AND_CAMERA_SIMULATION) {
            ThreadTools.startAsDaemon(this::lidarAndCameraSimulator, (String)"LidarAndCamera");
        }
        JavaFXBehaviorUIRegistry behaviorRegistry = JavaFXBehaviorUIRegistry.of((BehaviorDefinition)LookAndStepBehaviorUI.DEFINITION, (JavaFXBehaviorUIDefinition[])new JavaFXBehaviorUIDefinition[0]);
        this.behaviorModule = new BehaviorModule((BehaviorRegistry)behaviorRegistry, (DRCRobotModel)this.createRobotModel(), COMMUNICATION_MODE_ROS2, COMMUNICATION_MODE_MESSAGER);
        LogTools.info((String)"Creating behavior user interface");
        this.behaviorUI = JavaFXBehaviorUI.create((JavaFXBehaviorUIRegistry)behaviorRegistry, (DRCRobotModel)this.createRobotModel(), (CommunicationMode)COMMUNICATION_MODE_ROS2, (CommunicationMode)COMMUNICATION_MODE_MESSAGER, (String)"localhost", (Messager)this.behaviorModule.getMessager());
        this.behaviorUI.addOnCloseRequestListener(() -> ThreadTools.startAThread(() -> {
            this.destroy();
            Runtime.getRuntime().exit(0);
        }, (String)"DestroyViaUI"));
        Runtime.getRuntime().addShutdownHook(new Thread(this::destroy, "DestroyViaKill"));
    }

    @Override
    protected boolean destroy() {
        boolean destroy = super.destroy();
        if (destroy) {
            this.behaviorUI.closeMessager();
            this.behaviorModule.destroy();
            this.perceptionStack.destroy();
        }
        return destroy;
    }

    public static void main(String[] args) {
        AtlasSimulationBasics.runOrLogToFile(AtlasLookAndStepBehaviorDemo.class);
    }
}

