/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import controller_msgs.msg.dds.VideoPacket;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.behaviors.AtlasKinematicSimulation;
import us.ihmc.atlas.behaviors.scsSensorSimulation.SCSLidarAndCameraSimulator;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationParameters;
import us.ihmc.behaviors.javafx.simulation.RobotAndMapViewer;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.communication.IHMCROS2Publisher;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.log.LogTools;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.ros2.ROS2Node;
import us.ihmc.simulationConstructionSetTools.util.environments.CommonAvatarEnvironmentInterface;
import us.ihmc.simulationConstructionSetTools.util.environments.FlatGroundEnvironment;
import us.ihmc.wholeBodyController.AdditionalSimulationContactPoints;
import us.ihmc.wholeBodyController.FootContactPoints;

public class AtlasKinematicSimForUI {
    private static boolean SHOW_ROBOT_VIEWER = false;
    private static boolean LOG_TO_FILE = Boolean.parseBoolean(System.getProperty("log.to.file"));
    private static boolean CREATE_YOVARIABLE_SERVER = Boolean.parseBoolean(System.getProperty("create.yovariable.server"));
    private IHMCROS2Publisher<VideoPacket> scsCameraPublisher;

    public AtlasKinematicSimForUI(CommonAvatarEnvironmentInterface environment) {
        AtlasRobotModel robotModel = this.createRobotModel();
        HumanoidKinematicsSimulationParameters kinematicsSimulationParameters = new HumanoidKinematicsSimulationParameters();
        kinematicsSimulationParameters.setPubSubImplementation(DomainFactory.PubSubImplementation.FAST_RTPS);
        kinematicsSimulationParameters.setLogToFile(LOG_TO_FILE);
        kinematicsSimulationParameters.setCreateYoVariableServer(CREATE_YOVARIABLE_SERVER);
        AtlasKinematicSimulation.create(robotModel, kinematicsSimulationParameters);
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS, (String)"kinematic_camera");
        if (SHOW_ROBOT_VIEWER) {
            ThreadTools.startAThread(() -> {
                LogTools.info((String)"Creating robot and map viewer");
                new RobotAndMapViewer((DRCRobotModel)this.createRobotModel(), ros2Node);
            }, (String)"RobotAndMapViewer");
        }
        new SCSLidarAndCameraSimulator(DomainFactory.PubSubImplementation.FAST_RTPS, environment, (DRCRobotModel)this.createRobotModel());
    }

    private AtlasRobotModel createRobotModel() {
        AdditionalSimulationContactPoints simulationContactPoints = new AdditionalSimulationContactPoints((Enum[])RobotSide.values, 8, 3, true, true);
        return new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS, RobotTarget.SCS, false, (FootContactPoints<RobotSide>)simulationContactPoints);
    }

    public static void main(String[] args) {
        new AtlasKinematicSimForUI((CommonAvatarEnvironmentInterface)new FlatGroundEnvironment());
    }
}

