/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.Scene;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.layout.AnchorPane;
import javafx.stage.Stage;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.parameters.AtlasUIAuxiliaryData;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.behaviors.javafx.tools.DirectRobotUI;
import us.ihmc.communication.ROS2Tools;
import us.ihmc.footstepPlanning.ui.UIAuxiliaryRobotData;
import us.ihmc.footstepPlanning.ui.controllers.RobotIKUI;
import us.ihmc.javafx.JavaFXMissingTools;
import us.ihmc.javafx.applicationCreator.JavaFXApplicationCreator;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotModels.FullHumanoidRobotModelFactory;
import us.ihmc.ros2.ROS2Node;

public class AtlasDirectControlUI {
    private final DomainFactory.PubSubImplementation pubSubImplementation;

    public AtlasDirectControlUI() {
        this(DomainFactory.PubSubImplementation.FAST_RTPS);
    }

    public AtlasDirectControlUI(DomainFactory.PubSubImplementation pubSubImplementation) {
        this.pubSubImplementation = pubSubImplementation;
        JavaFXApplicationCreator.createAJavaFXApplication();
        Platform.runLater(this::buildApp);
    }

    private void buildApp() {
        AtlasRobotModel robotModel = new AtlasRobotModel(AtlasRobotVersion.ATLAS_UNPLUGGED_V5_DUAL_ROBOTIQ, RobotTarget.REAL_ROBOT, false);
        ROS2Node ros2Node = ROS2Tools.createROS2Node((DomainFactory.PubSubImplementation)this.pubSubImplementation, (String)"direct_robot_ui");
        Stage stage = new Stage();
        stage.setTitle(this.getClass().getSimpleName());
        TabPane tabPane = new TabPane();
        DirectRobotUI directRobotUI = new DirectRobotUI();
        AnchorPane directRobotUIPane = (AnchorPane)JavaFXMissingTools.loadFromFXML((Object)directRobotUI);
        directRobotUI.init(ros2Node, (DRCRobotModel)robotModel);
        RobotIKUI robotIKUI = new RobotIKUI();
        AtlasUIAuxiliaryData atlasUIAuxiliaryData = new AtlasUIAuxiliaryData();
        robotIKUI.setAuxiliaryRobotData((UIAuxiliaryRobotData)atlasUIAuxiliaryData);
        robotIKUI.setFullRobotModel(robotModel.createFullRobotModel(), (FullHumanoidRobotModelFactory)robotModel);
        AnchorPane robotIKUIPane = (AnchorPane)JavaFXMissingTools.loadFromFXML((Object)robotIKUI);
        tabPane.getTabs().add((Object)new Tab("General", (Node)directRobotUIPane));
        tabPane.getTabs().add((Object)new Tab("IK", (Node)robotIKUIPane));
        Scene mainScene = new Scene((Parent)tabPane);
        stage.setScene(mainScene);
        stage.show();
    }

    public static void main(String[] args) {
        new AtlasDirectControlUI();
    }
}

