/*
 * Decompiled with CFR 0.152.
 */
package us.ihmc.atlas.behaviors;

import java.util.function.Supplier;
import javafx.application.Application;
import us.ihmc.atlas.AtlasRobotModel;
import us.ihmc.atlas.AtlasRobotVersion;
import us.ihmc.atlas.jfxvisualizer.AtlasFootstepPlannerUI;
import us.ihmc.avatar.drcRobot.DRCRobotModel;
import us.ihmc.avatar.drcRobot.RobotTarget;
import us.ihmc.avatar.environments.BehaviorPlanarRegionEnvironments;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulation;
import us.ihmc.avatar.kinematicsSimulation.HumanoidKinematicsSimulationParameters;
import us.ihmc.avatar.networkProcessor.footstepPlanningModule.FootstepPlanningModuleLauncher;
import us.ihmc.avatar.networkProcessor.supportingPlanarRegionPublisher.BipedalSupportPlanarRegionPublisher;
import us.ihmc.behaviors.BehaviorModule;
import us.ihmc.behaviors.BehaviorRegistry;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUI;
import us.ihmc.behaviors.javafx.JavaFXBehaviorUIRegistry;
import us.ihmc.behaviors.tools.perception.SimulatedREAModule;
import us.ihmc.commons.thread.ThreadTools;
import us.ihmc.javafx.JavaFXMissingTools;
import us.ihmc.javafx.applicationCreator.JavaFXApplicationCreator;
import us.ihmc.log.LogTools;
import us.ihmc.parameterTuner.remote.ParameterTuner;
import us.ihmc.pathPlanning.PlannerTestEnvironments;
import us.ihmc.pubsub.DomainFactory;
import us.ihmc.robotics.geometry.PlanarRegionsList;
import us.ihmc.robotics.robotSide.RobotSide;
import us.ihmc.tools.processManagement.JavaProcessSpawner;
import us.ihmc.wholeBodyController.AdditionalSimulationContactPoints;
import us.ihmc.wholeBodyController.FootContactPoints;

public class AtlasBehaviorUIDemo {
    private static final AtlasRobotVersion ATLAS_VERSION = AtlasRobotVersion.ATLAS_UNPLUGGED_V5_NO_HANDS;
    private static final RobotTarget ATLAS_TARGET = RobotTarget.SCS;
    private static final boolean USE_KINEMATIC_SIMULATION = true;
    private static final boolean CREATE_YO_VARIABLE_SERVER = false;
    private static final boolean LAUNCH_PARAMETER_TUNER = false;
    private static final boolean LAUNCH_FOOTSTEP_PLANNER_UI = false;
    private static final Supplier<PlanarRegionsList> FLAT_GROUND = () -> PlanarRegionsList.flatGround((double)10.0);
    private static final Supplier<PlanarRegionsList> UP_DOWN_OPEN_HOUSE = BehaviorPlanarRegionEnvironments::createUpDownOpenHouseRegions;
    private static final Supplier<PlanarRegionsList> UP_DOWN_TWO_HIGH_FLAT_IN_BETWEEN = BehaviorPlanarRegionEnvironments::createUpDownTwoHighWithFlatBetween;
    private static final Supplier<PlanarRegionsList> UP_DOWN_FOUR_HIGH_WITH_FLAT_CENTER = BehaviorPlanarRegionEnvironments::createUpDownFourHighWithFlatCenter;
    private static final Supplier<PlanarRegionsList> STAIRS = BehaviorPlanarRegionEnvironments::createStairs;
    private static final Supplier<PlanarRegionsList> SLAM_REAL_DATA = BehaviorPlanarRegionEnvironments::realDataFromAtlasSLAMDataset20190710;
    private static final Supplier<PlanarRegionsList> CORRIDOR = PlannerTestEnvironments::getTrickCorridor;
    private static final Supplier<PlanarRegionsList> ENVIRONMENT = CORRIDOR;
    private final int recordFrequencySpeedup = 10;

    public AtlasBehaviorUIDemo() {
        JavaFXApplicationCreator.createAJavaFXApplication();
        if (ENVIRONMENT != FLAT_GROUND) {
            ThreadTools.startAThread(this::simulatedREAModule, (String)"SimulatedREAModule");
            ThreadTools.startAThread(this::bipedalSupportRegionPublisher, (String)"BipedalSupportRegionPublisher");
        }
        ThreadTools.startAThread(this::simulation, (String)"Simulation");
        ThreadTools.startAThread(this::footstepPlanningToolbox, (String)"FootstepPlanningToolbox");
        JavaFXBehaviorUIRegistry behaviorRegistry = JavaFXBehaviorUIRegistry.DEFAULT_BEHAVIORS;
        LogTools.info((String)"Creating behavior module");
        BehaviorModule.createInterprocess((BehaviorRegistry)behaviorRegistry, (DRCRobotModel)this.createRobotModel());
        LogTools.info((String)"Creating behavior user interface");
        JavaFXBehaviorUI.createInterprocess((JavaFXBehaviorUIRegistry)behaviorRegistry, (DRCRobotModel)this.createRobotModel(), (String)"localhost");
    }

    private void simulation() {
        LogTools.info((String)"Creating kinematics simulation");
        HumanoidKinematicsSimulationParameters kinematicsSimulationParameters = new HumanoidKinematicsSimulationParameters();
        kinematicsSimulationParameters.setPubSubImplementation(DomainFactory.PubSubImplementation.FAST_RTPS);
        kinematicsSimulationParameters.setCreateYoVariableServer(false);
        HumanoidKinematicsSimulation.create((DRCRobotModel)this.createRobotModel(), (HumanoidKinematicsSimulationParameters)kinematicsSimulationParameters);
    }

    private void simulatedREAModule() {
        LogTools.info((String)"Creating planar region publisher");
        new SimulatedREAModule(ENVIRONMENT.get(), (DRCRobotModel)this.createRobotModel(), DomainFactory.PubSubImplementation.FAST_RTPS).start();
    }

    private void bipedalSupportRegionPublisher() {
        LogTools.info((String)"Creating bipedal support region publisher");
        new BipedalSupportPlanarRegionPublisher((DRCRobotModel)this.createRobotModel(), DomainFactory.PubSubImplementation.FAST_RTPS).start();
    }

    private void footstepPlanningToolbox() {
        LogTools.info((String)"Starting footstep toolbox");
        FootstepPlanningModuleLauncher.createModule((DRCRobotModel)this.createRobotModel(), (DomainFactory.PubSubImplementation)DomainFactory.PubSubImplementation.FAST_RTPS);
    }

    private void parameterTuner() {
        LogTools.info((String)"Spawning parameter tuner");
        new JavaProcessSpawner(true).spawn(ParameterTuner.class);
    }

    private void footstepPlannerUI() {
        LogTools.info((String)"Launching remote footstep planner UI");
        AtlasFootstepPlannerUI atlasFootstepPlannerUI = new AtlasFootstepPlannerUI();
        JavaFXMissingTools.runApplication((Application)atlasFootstepPlannerUI);
    }

    private AtlasRobotModel createRobotModel() {
        AdditionalSimulationContactPoints simulationContactPoints = new AdditionalSimulationContactPoints((Enum[])RobotSide.values, 8, 3, true, true);
        return new AtlasRobotModel(ATLAS_VERSION, ATLAS_TARGET, false, (FootContactPoints<RobotSide>)simulationContactPoints);
    }

    public static void main(String[] args) {
        new AtlasBehaviorUIDemo();
    }
}

